/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToMessageCodec;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyHttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class SpdyHttpResponseStreamIdHandler
extends MessageToMessageCodec<Object, HttpMessage> {
    private static final Integer NO_ID = -1;
    private final Queue<Integer> ids = new LinkedList<Integer>();

    @Override
    public boolean acceptInboundMessage(Object object) {
        return object instanceof HttpMessage || object instanceof SpdyRstStreamFrame;
    }

    @Override
    protected void encode(ChannelHandlerContext object, HttpMessage httpMessage, List<Object> list) {
        object = this.ids.poll();
        if (object != null && ((Integer)object).intValue() != NO_ID.intValue() && !httpMessage.headers().contains("x-spdy-stream-id")) {
            SpdyHttpHeaders.setStreamId(httpMessage, (Integer)object);
        }
        list.add(ReferenceCountUtil.retain(httpMessage));
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, Object object, List<Object> list) {
        if (object instanceof HttpMessage) {
            boolean bl = ((HttpMessage)object).headers().contains("x-spdy-stream-id");
            if (!bl) {
                this.ids.add(NO_ID);
            } else {
                this.ids.add(SpdyHttpHeaders.getStreamId((HttpMessage)object));
            }
        } else if (object instanceof SpdyRstStreamFrame) {
            this.ids.remove(((SpdyRstStreamFrame)object).streamId());
        }
        list.add(ReferenceCountUtil.retain(object));
    }
}

