/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyOrHttpChooser$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyOrHttpChooser$SelectedProtocol;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdyVersion;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;

public abstract class SpdyOrHttpChooser
extends ByteToMessageDecoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SpdyOrHttpChooser.class);

    protected SpdyOrHttpChooser() {
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.configurePipeline(channelHandlerContext)) {
            channelHandlerContext.pipeline().remove(this);
        }
    }

    private boolean configurePipeline(ChannelHandlerContext channelHandlerContext) {
        Object object = channelHandlerContext.pipeline().get(SslHandler.class);
        if (object == null) {
            throw new IllegalStateException("cannot find a SslHandler in the pipeline (required for SPDY)");
        }
        if (!((SslHandler)object).handshakeFuture().isDone()) {
            return false;
        }
        try {
            object = this.selectProtocol((SslHandler)object);
        }
        catch (Exception exception) {
            throw new IllegalStateException("failed to get the selected protocol", exception);
        }
        if (object == null) {
            throw new IllegalStateException("unknown protocol");
        }
        switch (SpdyOrHttpChooser$1.$SwitchMap$io$netty$handler$codec$spdy$SpdyOrHttpChooser$SelectedProtocol[((Enum)object).ordinal()]) {
            case 1: {
                try {
                    this.configureSpdy(channelHandlerContext, SpdyVersion.SPDY_3_1);
                    break;
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to configure a SPDY pipeline", exception);
                }
            }
            case 2: 
            case 3: {
                try {
                    this.configureHttp1(channelHandlerContext);
                    break;
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to configure a HTTP/1 pipeline", exception);
                }
            }
        }
        return true;
    }

    protected SpdyOrHttpChooser$SelectedProtocol selectProtocol(SslHandler object) {
        if ((object = ((SslHandler)object).applicationProtocol()) != null) {
            return SpdyOrHttpChooser$SelectedProtocol.protocol((String)object);
        }
        return SpdyOrHttpChooser$SelectedProtocol.HTTP_1_1;
    }

    protected abstract void configureSpdy(ChannelHandlerContext var1, SpdyVersion var2);

    protected abstract void configureHttp1(ChannelHandlerContext var1);

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        logger.warn("{} Failed to select the application-level protocol:", (Object)channelHandlerContext.channel(), (Object)throwable);
        channelHandlerContext.close();
    }
}

