/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.spdy;

import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdySession$PendingWrite;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdySession$StreamComparator;
import com.aliyun.openservices.shade.io.netty.handler.codec.spdy.SpdySession$StreamState;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

final class SpdySession {
    private final AtomicInteger activeLocalStreams = new AtomicInteger();
    private final AtomicInteger activeRemoteStreams = new AtomicInteger();
    private final Map<Integer, SpdySession$StreamState> activeStreams = PlatformDependent.newConcurrentHashMap();
    private final SpdySession$StreamComparator streamComparator = new SpdySession$StreamComparator(this);
    private final AtomicInteger sendWindowSize;
    private final AtomicInteger receiveWindowSize;

    SpdySession(int n2, int n3) {
        this.sendWindowSize = new AtomicInteger(n2);
        this.receiveWindowSize = new AtomicInteger(n3);
    }

    final int numActiveStreams(boolean bl) {
        if (bl) {
            return this.activeRemoteStreams.get();
        }
        return this.activeLocalStreams.get();
    }

    final boolean noActiveStreams() {
        return this.activeStreams.isEmpty();
    }

    final boolean isActiveStream(int n2) {
        return this.activeStreams.containsKey(n2);
    }

    final Map<Integer, SpdySession$StreamState> activeStreams() {
        TreeMap<Integer, SpdySession$StreamState> treeMap = new TreeMap<Integer, SpdySession$StreamState>(this.streamComparator);
        treeMap.putAll(this.activeStreams);
        return treeMap;
    }

    final void acceptStream(int n2, byte by, boolean bl, boolean bl2, int n3, int n4, boolean bl3) {
        SpdySession$StreamState spdySession$StreamState;
        if (!(bl && bl2 || (spdySession$StreamState = this.activeStreams.put(n2, new SpdySession$StreamState(by, bl, bl2, n3, n4))) != null)) {
            if (bl3) {
                this.activeRemoteStreams.incrementAndGet();
                return;
            }
            this.activeLocalStreams.incrementAndGet();
        }
    }

    private SpdySession$StreamState removeActiveStream(int n2, boolean bl) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.remove(n2);
        if (spdySession$StreamState != null) {
            if (bl) {
                this.activeRemoteStreams.decrementAndGet();
            } else {
                this.activeLocalStreams.decrementAndGet();
            }
        }
        return spdySession$StreamState;
    }

    final void removeStream(int n2, Throwable throwable, boolean bl) {
        SpdySession$StreamState spdySession$StreamState = this.removeActiveStream(n2, bl);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.clearPendingWrites(throwable);
        }
    }

    final boolean isRemoteSideClosed(int n2) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        return spdySession$StreamState == null || spdySession$StreamState.isRemoteSideClosed();
    }

    final void closeRemoteSide(int n2, boolean bl) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.closeRemoteSide();
            if (spdySession$StreamState.isLocalSideClosed()) {
                this.removeActiveStream(n2, bl);
            }
        }
    }

    final boolean isLocalSideClosed(int n2) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        return spdySession$StreamState == null || spdySession$StreamState.isLocalSideClosed();
    }

    final void closeLocalSide(int n2, boolean bl) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.closeLocalSide();
            if (spdySession$StreamState.isRemoteSideClosed()) {
                this.removeActiveStream(n2, bl);
            }
        }
    }

    final boolean hasReceivedReply(int n2) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        return spdySession$StreamState != null && spdySession$StreamState.hasReceivedReply();
    }

    final void receivedReply(int n2) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        if (spdySession$StreamState != null) {
            spdySession$StreamState.receivedReply();
        }
    }

    final int getSendWindowSize(int n2) {
        if (n2 == 0) {
            return this.sendWindowSize.get();
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        if (spdySession$StreamState != null) {
            return spdySession$StreamState.getSendWindowSize();
        }
        return -1;
    }

    final int updateSendWindowSize(int n2, int n3) {
        if (n2 == 0) {
            return this.sendWindowSize.addAndGet(n3);
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        if (spdySession$StreamState != null) {
            return spdySession$StreamState.updateSendWindowSize(n3);
        }
        return -1;
    }

    final int updateReceiveWindowSize(int n2, int n3) {
        if (n2 == 0) {
            return this.receiveWindowSize.addAndGet(n3);
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        if (spdySession$StreamState == null) {
            return -1;
        }
        if (n3 > 0) {
            spdySession$StreamState.setReceiveWindowSizeLowerBound(0);
        }
        return spdySession$StreamState.updateReceiveWindowSize(n3);
    }

    final int getReceiveWindowSizeLowerBound(int n2) {
        if (n2 == 0) {
            return 0;
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        if (spdySession$StreamState != null) {
            return spdySession$StreamState.getReceiveWindowSizeLowerBound();
        }
        return 0;
    }

    final void updateAllSendWindowSizes(int n2) {
        for (SpdySession$StreamState spdySession$StreamState : this.activeStreams.values()) {
            spdySession$StreamState.updateSendWindowSize(n2);
        }
    }

    final void updateAllReceiveWindowSizes(int n2) {
        for (SpdySession$StreamState spdySession$StreamState : this.activeStreams.values()) {
            spdySession$StreamState.updateReceiveWindowSize(n2);
            if (n2 >= 0) continue;
            spdySession$StreamState.setReceiveWindowSizeLowerBound(n2);
        }
    }

    final boolean putPendingWrite(int n2, SpdySession$PendingWrite spdySession$PendingWrite) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        return spdySession$StreamState != null && spdySession$StreamState.putPendingWrite(spdySession$PendingWrite);
    }

    final SpdySession$PendingWrite getPendingWrite(int n2) {
        if (n2 == 0) {
            for (Map.Entry<Integer, SpdySession$StreamState> entry : this.activeStreams().entrySet()) {
                SpdySession$PendingWrite spdySession$PendingWrite;
                SpdySession$StreamState spdySession$StreamState = entry.getValue();
                if (spdySession$StreamState.getSendWindowSize() <= 0 || (spdySession$PendingWrite = spdySession$StreamState.getPendingWrite()) == null) continue;
                return spdySession$PendingWrite;
            }
            return null;
        }
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        if (spdySession$StreamState != null) {
            return spdySession$StreamState.getPendingWrite();
        }
        return null;
    }

    final SpdySession$PendingWrite removePendingWrite(int n2) {
        SpdySession$StreamState spdySession$StreamState = this.activeStreams.get(n2);
        if (spdySession$StreamState != null) {
            return spdySession$StreamState.removePendingWrite();
        }
        return null;
    }

    static /* synthetic */ Map access$000(SpdySession spdySession) {
        return spdySession.activeStreams;
    }
}

