/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ipfilter;

import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.SocketAddress;

public abstract class AbstractRemoteAddressFilter<T extends SocketAddress>
extends ChannelInboundHandlerAdapter {
    @Override
    public void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        this.handleNewChannel(channelHandlerContext);
        channelHandlerContext.fireChannelRegistered();
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        if (!this.handleNewChannel(channelHandlerContext)) {
            throw new IllegalStateException("cannot determine to accept or reject a channel: " + channelHandlerContext.channel());
        }
        channelHandlerContext.fireChannelActive();
    }

    private boolean handleNewChannel(ChannelHandlerContext channelHandlerContext) {
        Object object = channelHandlerContext.channel().remoteAddress();
        if (object == null) {
            return false;
        }
        channelHandlerContext.pipeline().remove(this);
        if (this.accept(channelHandlerContext, object)) {
            this.channelAccepted(channelHandlerContext, object);
        } else if ((object = this.channelRejected(channelHandlerContext, object)) != null) {
            object.addListener(ChannelFutureListener.CLOSE);
        } else {
            channelHandlerContext.close();
        }
        return true;
    }

    protected abstract boolean accept(ChannelHandlerContext var1, T var2);

    protected void channelAccepted(ChannelHandlerContext channelHandlerContext, T t2) {
    }

    protected ChannelFuture channelRejected(ChannelHandlerContext channelHandlerContext, T t2) {
        return null;
    }
}

