/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ipfilter;

import com.aliyun.openservices.shade.io.netty.handler.ipfilter.IpFilterRule;
import com.aliyun.openservices.shade.io.netty.handler.ipfilter.IpFilterRuleType;
import com.aliyun.openservices.shade.io.netty.handler.ipfilter.IpSubnetFilterRule;
import com.aliyun.openservices.shade.io.netty.handler.ipfilter.IpSubnetFilterRule$1;
import java.net.Inet4Address;
import java.net.InetSocketAddress;

final class IpSubnetFilterRule$Ip4SubnetFilterRule
implements IpFilterRule {
    private final int networkAddress;
    private final int subnetMask;
    private final IpFilterRuleType ruleType;
    static final /* synthetic */ boolean $assertionsDisabled;

    private IpSubnetFilterRule$Ip4SubnetFilterRule(Inet4Address inet4Address, int n2, IpFilterRuleType ipFilterRuleType) {
        if (n2 < 0 || n2 > 32) {
            throw new IllegalArgumentException(String.format("IPv4 requires the subnet prefix to be in range of [0,32]. The prefix was: %d", n2));
        }
        this.subnetMask = IpSubnetFilterRule$Ip4SubnetFilterRule.prefixToSubnetMask(n2);
        this.networkAddress = IpSubnetFilterRule$Ip4SubnetFilterRule.ipToInt(inet4Address) & this.subnetMask;
        this.ruleType = ipFilterRuleType;
    }

    @Override
    public final boolean matches(InetSocketAddress inetSocketAddress) {
        int n2 = IpSubnetFilterRule$Ip4SubnetFilterRule.ipToInt((Inet4Address)inetSocketAddress.getAddress());
        return (n2 & this.subnetMask) == this.networkAddress;
    }

    @Override
    public final IpFilterRuleType ruleType() {
        return this.ruleType;
    }

    private static int ipToInt(Inet4Address object) {
        object = ((Inet4Address)object).getAddress();
        if (!$assertionsDisabled && ((Object)object).length != 4) {
            throw new AssertionError();
        }
        return (object[0] & 0xFF) << 24 | (object[1] & 0xFF) << 16 | (object[2] & 0xFF) << 8 | object[3] & 0xFF;
    }

    private static int prefixToSubnetMask(int n2) {
        return (int)(-1L << 32 - n2);
    }

    /* synthetic */ IpSubnetFilterRule$Ip4SubnetFilterRule(Inet4Address inet4Address, int n2, IpFilterRuleType ipFilterRuleType, IpSubnetFilterRule$1 ipSubnetFilterRule$1) {
        this(inet4Address, n2, ipFilterRuleType);
    }

    static {
        $assertionsDisabled = !IpSubnetFilterRule.class.desiredAssertionStatus();
    }
}

