/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ipfilter;

import com.aliyun.openservices.shade.io.netty.handler.ipfilter.IpFilterRule;
import com.aliyun.openservices.shade.io.netty.handler.ipfilter.IpFilterRuleType;
import com.aliyun.openservices.shade.io.netty.handler.ipfilter.IpSubnetFilterRule;
import com.aliyun.openservices.shade.io.netty.handler.ipfilter.IpSubnetFilterRule$1;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetSocketAddress;

final class IpSubnetFilterRule$Ip6SubnetFilterRule
implements IpFilterRule {
    private static final BigInteger MINUS_ONE;
    private final BigInteger networkAddress;
    private final BigInteger subnetMask;
    private final IpFilterRuleType ruleType;
    static final /* synthetic */ boolean $assertionsDisabled;

    private IpSubnetFilterRule$Ip6SubnetFilterRule(Inet6Address inet6Address, int n2, IpFilterRuleType ipFilterRuleType) {
        if (n2 < 0 || n2 > 128) {
            throw new IllegalArgumentException(String.format("IPv6 requires the subnet prefix to be in range of [0,128]. The prefix was: %d", n2));
        }
        this.subnetMask = IpSubnetFilterRule$Ip6SubnetFilterRule.prefixToSubnetMask(n2);
        this.networkAddress = IpSubnetFilterRule$Ip6SubnetFilterRule.ipToInt(inet6Address).and(this.subnetMask);
        this.ruleType = ipFilterRuleType;
    }

    @Override
    public final boolean matches(InetSocketAddress serializable) {
        serializable = IpSubnetFilterRule$Ip6SubnetFilterRule.ipToInt((Inet6Address)serializable.getAddress());
        return ((BigInteger)serializable).and(this.subnetMask).equals(this.networkAddress);
    }

    @Override
    public final IpFilterRuleType ruleType() {
        return this.ruleType;
    }

    private static BigInteger ipToInt(Inet6Address object) {
        object = ((Inet6Address)object).getAddress();
        if (!$assertionsDisabled && ((Object)object).length != 16) {
            throw new AssertionError();
        }
        return new BigInteger((byte[])object);
    }

    private static BigInteger prefixToSubnetMask(int n2) {
        return MINUS_ONE.shiftLeft(128 - n2);
    }

    /* synthetic */ IpSubnetFilterRule$Ip6SubnetFilterRule(Inet6Address inet6Address, int n2, IpFilterRuleType ipFilterRuleType, IpSubnetFilterRule$1 ipSubnetFilterRule$1) {
        this(inet6Address, n2, ipFilterRuleType);
    }

    static {
        $assertionsDisabled = !IpSubnetFilterRule.class.desiredAssertionStatus();
        MINUS_ONE = BigInteger.valueOf(-1L);
    }
}

