/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ipfilter;

import com.aliyun.openservices.shade.io.netty.handler.ipfilter.IpFilterRule;
import com.aliyun.openservices.shade.io.netty.handler.ipfilter.IpFilterRuleType;
import com.aliyun.openservices.shade.io.netty.handler.ipfilter.IpSubnetFilterRule$Ip4SubnetFilterRule;
import com.aliyun.openservices.shade.io.netty.handler.ipfilter.IpSubnetFilterRule$Ip6SubnetFilterRule;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class IpSubnetFilterRule
implements IpFilterRule {
    private final IpFilterRule filterRule;

    public IpSubnetFilterRule(String string, int n2, IpFilterRuleType ipFilterRuleType) {
        try {
            this.filterRule = IpSubnetFilterRule.selectFilterRule(InetAddress.getByName(string), n2, ipFilterRuleType);
            return;
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("ipAddress", unknownHostException);
        }
    }

    public IpSubnetFilterRule(InetAddress inetAddress, int n2, IpFilterRuleType ipFilterRuleType) {
        this.filterRule = IpSubnetFilterRule.selectFilterRule(inetAddress, n2, ipFilterRuleType);
    }

    private static IpFilterRule selectFilterRule(InetAddress inetAddress, int n2, IpFilterRuleType ipFilterRuleType) {
        if (inetAddress == null) {
            throw new NullPointerException("ipAddress");
        }
        if (ipFilterRuleType == null) {
            throw new NullPointerException("ruleType");
        }
        if (inetAddress instanceof Inet4Address) {
            return new IpSubnetFilterRule$Ip4SubnetFilterRule((Inet4Address)inetAddress, n2, ipFilterRuleType, null);
        }
        if (inetAddress instanceof Inet6Address) {
            return new IpSubnetFilterRule$Ip6SubnetFilterRule((Inet6Address)inetAddress, n2, ipFilterRuleType, null);
        }
        throw new IllegalArgumentException("Only IPv4 and IPv6 addresses are supported");
    }

    @Override
    public final boolean matches(InetSocketAddress inetSocketAddress) {
        return this.filterRule.matches(inetSocketAddress);
    }

    @Override
    public final IpFilterRuleType ruleType() {
        return this.filterRule.ruleType();
    }
}

