/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.logging;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufHolder;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil;
import com.aliyun.openservices.shade.io.netty.channel.ChannelDuplexHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandler$Sharable;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.logging.LogLevel;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogLevel;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;

@ChannelHandler$Sharable
public class LoggingHandler
extends ChannelDuplexHandler {
    private static final LogLevel DEFAULT_LEVEL = LogLevel.DEBUG;
    protected final InternalLogger logger;
    protected final InternalLogLevel internalLevel;
    private final LogLevel level;

    public LoggingHandler() {
        this(DEFAULT_LEVEL);
    }

    public LoggingHandler(LogLevel logLevel) {
        if (logLevel == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(this.getClass());
        this.level = logLevel;
        this.internalLevel = logLevel.toInternalLevel();
    }

    public LoggingHandler(Class<?> clazz) {
        this(clazz, DEFAULT_LEVEL);
    }

    public LoggingHandler(Class<?> clazz, LogLevel logLevel) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (logLevel == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(clazz);
        this.level = logLevel;
        this.internalLevel = logLevel.toInternalLevel();
    }

    public LoggingHandler(String string) {
        this(string, DEFAULT_LEVEL);
    }

    public LoggingHandler(String string, LogLevel logLevel) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (logLevel == null) {
            throw new NullPointerException("level");
        }
        this.logger = InternalLoggerFactory.getInstance(string);
        this.level = logLevel;
        this.internalLevel = logLevel.toInternalLevel();
    }

    public LogLevel level() {
        return this.level;
    }

    protected String format(ChannelHandlerContext object, String string) {
        object = object.channel().toString();
        return new StringBuilder(((String)object).length() + string.length() + 1).append((String)object).append(' ').append(string).toString();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "REGISTERED"));
        }
        super.channelRegistered(channelHandlerContext);
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext channelHandlerContext) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "UNREGISTERED"));
        }
        super.channelUnregistered(channelHandlerContext);
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "ACTIVE"));
        }
        super.channelActive(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "INACTIVE"));
        }
        super.channelInactive(channelHandlerContext);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "EXCEPTION: " + throwable), throwable);
        }
        super.exceptionCaught(channelHandlerContext, throwable);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "USER_EVENT: " + object));
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "BIND(" + socketAddress + ')'));
        }
        super.bind(channelHandlerContext, socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "CONNECT(" + socketAddress + ", " + socketAddress2 + ')'));
        }
        super.connect(channelHandlerContext, socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "DISCONNECT()"));
        }
        super.disconnect(channelHandlerContext, channelPromise);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "CLOSE()"));
        }
        super.close(channelHandlerContext, channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "DEREGISTER()"));
        }
        super.deregister(channelHandlerContext, channelPromise);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        this.logMessage(channelHandlerContext, "RECEIVED", object);
        channelHandlerContext.fireChannelRead(object);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        this.logMessage(channelHandlerContext, "WRITE", object);
        channelHandlerContext.write(object, channelPromise);
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, "FLUSH"));
        }
        channelHandlerContext.flush();
    }

    private void logMessage(ChannelHandlerContext channelHandlerContext, String string, Object object) {
        if (this.logger.isEnabled(this.internalLevel)) {
            this.logger.log(this.internalLevel, this.format(channelHandlerContext, this.formatMessage(string, object)));
        }
    }

    protected String formatMessage(String string, Object object) {
        if (object instanceof ByteBuf) {
            return this.formatByteBuf(string, (ByteBuf)object);
        }
        if (object instanceof ByteBufHolder) {
            return this.formatByteBufHolder(string, (ByteBufHolder)object);
        }
        return this.formatNonByteBuf(string, object);
    }

    protected String formatByteBuf(String string, ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + 4);
            stringBuilder.append(string).append(": 0B");
            return stringBuilder.toString();
        }
        int n3 = n2 / 16 + (n2 % 15 == 0 ? 0 : 1) + 4;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2 + 10 + 1 + 2 + n3 * 80);
        stringBuilder.append(string).append(": ").append(n2).append('B').append(StringUtil.NEWLINE);
        ByteBufUtil.appendPrettyHexDump(stringBuilder, byteBuf);
        return stringBuilder.toString();
    }

    protected String formatNonByteBuf(String string, Object object) {
        return string + ": " + object;
    }

    protected String formatByteBufHolder(String string, ByteBufHolder referenceCounted) {
        String string2 = referenceCounted.toString();
        int n2 = ((ByteBuf)(referenceCounted = referenceCounted.content())).readableBytes();
        if (n2 == 0) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + 2 + string2.length() + 4);
            stringBuilder.append(string).append(", ").append(string2).append(", 0B");
            return stringBuilder.toString();
        }
        int n3 = n2 / 16 + (n2 % 15 == 0 ? 0 : 1) + 4;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2 + string2.length() + 2 + 10 + 1 + 2 + n3 * 80);
        stringBuilder.append(string).append(": ").append(string2).append(", ").append(n2).append('B').append(StringUtil.NEWLINE);
        ByteBufUtil.appendPrettyHexDump(stringBuilder, (ByteBuf)referenceCounted);
        return stringBuilder.toString();
    }
}

