/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class ApplicationProtocolNegotiationHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ApplicationProtocolNegotiationHandler.class);
    private final String fallbackProtocol;

    protected ApplicationProtocolNegotiationHandler(String string) {
        this.fallbackProtocol = ObjectUtil.checkNotNull(string, "fallbackProtocol");
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof SslHandshakeCompletionEvent) {
            channelHandlerContext.pipeline().remove(this);
            Object object2 = (SslHandshakeCompletionEvent)object;
            if (((SslHandshakeCompletionEvent)object2).isSuccess()) {
                object2 = channelHandlerContext.pipeline().get(SslHandler.class);
                if (object2 == null) {
                    throw new IllegalStateException("cannot find a SslHandler in the pipeline (required for application-level protocol negotiation)");
                }
                this.configurePipeline(channelHandlerContext, (String)((object2 = ((SslHandler)object2).applicationProtocol()) != null ? object2 : this.fallbackProtocol));
            } else {
                this.handshakeFailure(channelHandlerContext, ((SslHandshakeCompletionEvent)object2).cause());
            }
        }
        channelHandlerContext.fireUserEventTriggered(object);
    }

    protected abstract void configurePipeline(ChannelHandlerContext var1, String var2);

    protected void handshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        logger.warn("{} TLS handshake failed:", (Object)channelHandlerContext.channel(), (Object)throwable);
        channelHandlerContext.close();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        logger.warn("{} Failed to select the application-level protocol:", (Object)channelHandlerContext.channel(), (Object)throwable);
        channelHandlerContext.close();
    }
}

