/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.handler.ssl.JdkAlpnSslEngine$1;
import com.aliyun.openservices.shade.io.netty.handler.ssl.JdkAlpnSslEngine$2;
import com.aliyun.openservices.shade.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import com.aliyun.openservices.shade.io.netty.handler.ssl.JdkApplicationProtocolNegotiator$ProtocolSelectionListener;
import com.aliyun.openservices.shade.io.netty.handler.ssl.JdkApplicationProtocolNegotiator$ProtocolSelector;
import com.aliyun.openservices.shade.io.netty.handler.ssl.JdkSslEngine;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import java.util.LinkedHashSet;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.ALPN;

final class JdkAlpnSslEngine
extends JdkSslEngine {
    private static boolean available;

    static boolean isAvailable() {
        JdkAlpnSslEngine.updateAvailability();
        return available;
    }

    private static void updateAvailability() {
        if (available) {
            return;
        }
        try {
            Class.forName("sun.security.ssl.ALPNExtension", true, null);
            available = true;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    JdkAlpnSslEngine(SSLEngine sSLEngine, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, boolean bl) {
        super(sSLEngine);
        ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator, "applicationNegotiator");
        if (bl) {
            JdkApplicationProtocolNegotiator$ProtocolSelector jdkApplicationProtocolNegotiator$ProtocolSelector = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(jdkApplicationProtocolNegotiator.protocols())), "protocolSelector");
            ALPN.put((SSLEngine)sSLEngine, (ALPN.Provider)new JdkAlpnSslEngine$1(this, jdkApplicationProtocolNegotiator$ProtocolSelector));
            return;
        }
        JdkApplicationProtocolNegotiator$ProtocolSelectionListener jdkApplicationProtocolNegotiator$ProtocolSelectionListener = ObjectUtil.checkNotNull(jdkApplicationProtocolNegotiator.protocolListenerFactory().newListener(this, jdkApplicationProtocolNegotiator.protocols()), "protocolListener");
        ALPN.put((SSLEngine)sSLEngine, (ALPN.Provider)new JdkAlpnSslEngine$2(this, jdkApplicationProtocolNegotiator, jdkApplicationProtocolNegotiator$ProtocolSelectionListener));
    }

    @Override
    public final void closeInbound() {
        ALPN.remove((SSLEngine)this.getWrappedEngine());
        super.closeInbound();
    }

    @Override
    public final void closeOutbound() {
        ALPN.remove((SSLEngine)this.getWrappedEngine());
        super.closeOutbound();
    }
}

