/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.handler.ssl.PemX509Certificate;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import org.apache.tomcat.jni.CertificateRequestedCallback;
import org.apache.tomcat.jni.SSL;

class OpenSslKeyMaterialManager {
    static final String KEY_TYPE_RSA = "RSA";
    static final String KEY_TYPE_DH_RSA = "DH_RSA";
    static final String KEY_TYPE_EC = "EC";
    static final String KEY_TYPE_EC_EC = "EC_EC";
    static final String KEY_TYPE_EC_RSA = "EC_RSA";
    private static final Map<String, String> KEY_TYPES = new HashMap<String, String>();
    private final X509KeyManager keyManager;
    private final String password;

    OpenSslKeyMaterialManager(X509KeyManager x509KeyManager, String string) {
        this.keyManager = x509KeyManager;
        this.password = string;
    }

    void setKeyMaterial(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        long l2 = referenceCountedOpenSslEngine.sslPointer();
        String[] stringArray = SSL.authenticationMethods((long)l2);
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (String string : stringArray) {
            if ((string = KEY_TYPES.get(string)) == null || (string = this.chooseServerAlias(referenceCountedOpenSslEngine, string)) == null || !hashSet.add(string)) continue;
            this.setKeyMaterial(l2, string);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CertificateRequestedCallback.KeyMaterial keyMaterial(ReferenceCountedOpenSslEngine object, String[] object2, X500Principal[] x500PrincipalArray) {
        long l2;
        long l3;
        long l4;
        long l5;
        block7: {
            object = this.chooseClientAlias((ReferenceCountedOpenSslEngine)object, (String[])object2, x500PrincipalArray);
            l5 = 0L;
            l4 = 0L;
            l3 = 0L;
            l2 = 0L;
            object2 = this.keyManager.getCertificateChain((String)object);
            if (object2 != null && ((String[])object2).length != 0) break block7;
            ReferenceCountedOpenSslContext.freeBio(0L);
            ReferenceCountedOpenSslContext.freeBio(0L);
            SSL.freePrivateKey((long)0L);
            SSL.freeX509Chain((long)0L);
            return null;
        }
        try {
            object = this.keyManager.getPrivateKey((String)object);
            l4 = ReferenceCountedOpenSslContext.toBIO((X509Certificate[])object2);
            l2 = SSL.parseX509Chain((long)l4);
            if (object != null) {
                l5 = ReferenceCountedOpenSslContext.toBIO((PrivateKey)object);
                l3 = SSL.parsePrivateKey((long)l5, (String)this.password);
            }
            object = new CertificateRequestedCallback.KeyMaterial(l2, l3);
            l3 = 0L;
            l2 = 0L;
        }
        catch (SSLException sSLException) {
            try {
                object2 = sSLException;
                throw sSLException;
                catch (Exception exception) {
                    throw new SSLException(exception);
                }
            }
            catch (Throwable throwable) {
                ReferenceCountedOpenSslContext.freeBio(l5);
                ReferenceCountedOpenSslContext.freeBio(l4);
                SSL.freePrivateKey((long)l3);
                SSL.freeX509Chain((long)l2);
                throw throwable;
            }
        }
        ReferenceCountedOpenSslContext.freeBio(l5);
        ReferenceCountedOpenSslContext.freeBio(l4);
        SSL.freePrivateKey((long)0L);
        SSL.freeX509Chain((long)0L);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setKeyMaterial(long l2, String object) {
        long l3;
        long l4;
        long l5;
        block12: {
            Object object2;
            l5 = 0L;
            l4 = 0L;
            l3 = 0L;
            try {
                object2 = this.keyManager.getCertificateChain((String)object);
                if (object2 == null || ((X509Certificate[])object2).length == 0) {
                    ReferenceCountedOpenSslContext.freeBio(0L);
                    break block12;
                }
                object = this.keyManager.getPrivateKey((String)object);
                object2 = PemX509Certificate.toPEM(ByteBufAllocator.DEFAULT, true, (X509Certificate[])object2);
                try {
                    l4 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, object2.retain());
                    l3 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, object2.retain());
                    if (object != null) {
                        l5 = ReferenceCountedOpenSslContext.toBIO((PrivateKey)object);
                    }
                    SSL.setCertificateBio((long)l2, (long)l4, (long)l5, (String)this.password);
                    SSL.setCertificateChainBio((long)l2, (long)l3, (boolean)true);
                    return;
                }
                finally {
                    object2.release();
                }
            }
            catch (SSLException x509CertificateArray) {
                object2 = x509CertificateArray;
                throw x509CertificateArray;
            }
            catch (Exception exception) {
                throw new SSLException(exception);
            }
        }
        ReferenceCountedOpenSslContext.freeBio(0L);
        ReferenceCountedOpenSslContext.freeBio(0L);
        return;
        finally {
            ReferenceCountedOpenSslContext.freeBio(l5);
            ReferenceCountedOpenSslContext.freeBio(l4);
            ReferenceCountedOpenSslContext.freeBio(l3);
        }
    }

    protected String chooseClientAlias(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String[] stringArray, X500Principal[] x500PrincipalArray) {
        return this.keyManager.chooseClientAlias(stringArray, x500PrincipalArray, null);
    }

    protected String chooseServerAlias(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String string) {
        return this.keyManager.chooseServerAlias(string, null, null);
    }

    static {
        KEY_TYPES.put(KEY_TYPE_RSA, KEY_TYPE_RSA);
        KEY_TYPES.put("DHE_RSA", KEY_TYPE_RSA);
        KEY_TYPES.put("ECDHE_RSA", KEY_TYPE_RSA);
        KEY_TYPES.put("ECDHE_ECDSA", KEY_TYPE_EC);
        KEY_TYPES.put("ECDH_RSA", KEY_TYPE_EC_RSA);
        KEY_TYPES.put("ECDH_ECDSA", KEY_TYPE_EC_EC);
        KEY_TYPES.put(KEY_TYPE_DH_RSA, KEY_TYPE_DH_RSA);
    }
}

