/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.handler.ssl.PemEncoded;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslUtils;
import com.aliyun.openservices.shade.io.netty.util.AbstractReferenceCounted;
import com.aliyun.openservices.shade.io.netty.util.IllegalReferenceCountException;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;

class PemValue
extends AbstractReferenceCounted
implements PemEncoded {
    private final ByteBuf content;
    private final boolean sensitive;

    public PemValue(ByteBuf byteBuf, boolean bl) {
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.sensitive = bl;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    @Override
    public ByteBuf content() {
        int n2 = this.refCnt();
        if (n2 <= 0) {
            throw new IllegalReferenceCountException(n2);
        }
        return this.content;
    }

    @Override
    public PemValue copy() {
        return new PemValue(this.content.copy(), this.sensitive);
    }

    @Override
    public PemValue duplicate() {
        return new PemValue(this.content.duplicate(), this.sensitive);
    }

    @Override
    public PemValue retain() {
        return (PemValue)super.retain();
    }

    @Override
    public PemValue retain(int n2) {
        return (PemValue)super.retain(n2);
    }

    @Override
    public void deallocate() {
        if (this.sensitive) {
            SslUtils.zeroout(this.content);
        }
        this.content.release();
    }
}

