/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslEngineMap;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLHandshakeException;
import javax.security.auth.x500.X500Principal;
import org.apache.tomcat.jni.CertificateRequestedCallback;

final class ReferenceCountedOpenSslClientContext$OpenSslCertificateRequestedCallback
implements CertificateRequestedCallback {
    private final OpenSslEngineMap engineMap;
    private final OpenSslKeyMaterialManager keyManagerHolder;

    ReferenceCountedOpenSslClientContext$OpenSslCertificateRequestedCallback(OpenSslEngineMap openSslEngineMap, OpenSslKeyMaterialManager openSslKeyMaterialManager) {
        this.engineMap = openSslEngineMap;
        this.keyManagerHolder = openSslKeyMaterialManager;
    }

    public final CertificateRequestedCallback.KeyMaterial requested(long l2, byte[] object, byte[][] byArray) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l2);
        try {
            X500Principal[] x500PrincipalArray = ReferenceCountedOpenSslClientContext$OpenSslCertificateRequestedCallback.supportedClientKeyTypes(object);
            object = x500PrincipalArray.toArray(new String[x500PrincipalArray.size()]);
            if (byArray == null) {
                x500PrincipalArray = null;
            } else {
                x500PrincipalArray = new X500Principal[byArray.length];
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    x500PrincipalArray[i2] = new X500Principal(byArray[i2]);
                }
            }
            return this.keyManagerHolder.keyMaterial(referenceCountedOpenSslEngine, (String[])object, x500PrincipalArray);
        }
        catch (Throwable throwable) {
            ReferenceCountedOpenSslClientContext.access$000().debug("request of key failed", throwable);
            SSLHandshakeException sSLHandshakeException = new SSLHandshakeException("General OpenSslEngine problem");
            object = sSLHandshakeException;
            sSLHandshakeException.initCause(throwable);
            referenceCountedOpenSslEngine.handshakeException = object;
            return null;
        }
    }

    private static Set<String> supportedClientKeyTypes(byte[] byArray) {
        HashSet<String> hashSet = new HashSet<String>(byArray.length);
        for (byte by : byArray) {
            String string = ReferenceCountedOpenSslClientContext$OpenSslCertificateRequestedCallback.clientKeyType(by);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private static String clientKeyType(byte by) {
        switch (by) {
            case 1: {
                return "RSA";
            }
            case 3: {
                return "DH_RSA";
            }
            case 64: {
                return "EC";
            }
            case 65: {
                return "EC_RSA";
            }
            case 66: {
                return "EC_EC";
            }
        }
        return null;
    }
}

