/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.aliyun.openservices.shade.io.netty.handler.ssl.CipherSuiteFilter;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ClientAuth;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSsl;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslEngineMap;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslExtendedKeyMaterialManager;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslSessionContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslClientContext$ExtendedTrustManagerVerifyCallback;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslClientContext$OpenSslCertificateRequestedCallback;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslClientContext$OpenSslClientSessionContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslClientContext$TrustManagerVerifyCallback;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.tomcat.jni.CertificateRequestedCallback;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.SSLContext;

public final class ReferenceCountedOpenSslClientContext
extends ReferenceCountedOpenSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslClientContext.class);
    private final OpenSslSessionContext sessionContext;

    ReferenceCountedOpenSslClientContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) {
        super(iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, 0, (Certificate[])x509CertificateArray2, ClientAuth.NONE, false, true);
        try {
            this.sessionContext = ReferenceCountedOpenSslClientContext.newSessionContext(this, this.ctx, this.engineMap, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory);
            return;
        }
        catch (Throwable throwable) {
            this.release();
            throw throwable;
        }
    }

    @Override
    final OpenSslKeyMaterialManager keyMaterialManager() {
        return null;
    }

    @Override
    public final OpenSslSessionContext sessionContext() {
        return this.sessionContext;
    }

    static OpenSslSessionContext newSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, long l2, OpenSslEngineMap openSslEngineMap, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] object, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory) {
        if (privateKey == null && object != null || privateKey != null && object == null) {
            throw new IllegalArgumentException("Either both keyCertChain and key needs to be null or none of them");
        }
        Class<ReferenceCountedOpenSslContext> clazz = ReferenceCountedOpenSslContext.class;
        synchronized (ReferenceCountedOpenSslContext.class) {
            try {
                if (!OpenSsl.useKeyManagerFactory()) {
                    if (keyManagerFactory != null) {
                        throw new IllegalArgumentException("KeyManagerFactory not supported");
                    }
                    if (object != null) {
                        ReferenceCountedOpenSslClientContext.setKeyMaterial(l2, object, privateKey, string);
                    }
                } else {
                    if (keyManagerFactory == null && object != null) {
                        keyManagerFactory = ReferenceCountedOpenSslClientContext.buildKeyManagerFactory(object, privateKey, string, keyManagerFactory);
                    }
                    if (keyManagerFactory != null) {
                        object = ReferenceCountedOpenSslClientContext.chooseX509KeyManager(keyManagerFactory.getKeyManagers());
                        object = ReferenceCountedOpenSslClientContext.useExtendedKeyManager((X509KeyManager)object) ? new OpenSslExtendedKeyMaterialManager((X509ExtendedKeyManager)object, string) : new OpenSslKeyMaterialManager((X509KeyManager)object, string);
                        SSLContext.setCertRequestedCallback((long)l2, (CertificateRequestedCallback)new ReferenceCountedOpenSslClientContext$OpenSslCertificateRequestedCallback(openSslEngineMap, (OpenSslKeyMaterialManager)object));
                    }
                }
            }
            catch (Exception exception) {
                throw new SSLException("failed to set certificate and key", exception);
            }
            SSLContext.setVerify((long)l2, (int)0, (int)10);
            try {
                if (x509CertificateArray != null) {
                    trustManagerFactory = ReferenceCountedOpenSslClientContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory);
                } else if (trustManagerFactory == null) {
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                }
                object = ReferenceCountedOpenSslClientContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
                if (ReferenceCountedOpenSslClientContext.useExtendedTrustManager((X509TrustManager)object)) {
                    SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new ReferenceCountedOpenSslClientContext$ExtendedTrustManagerVerifyCallback(openSslEngineMap, (X509ExtendedTrustManager)object));
                } else {
                    SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new ReferenceCountedOpenSslClientContext$TrustManagerVerifyCallback(openSslEngineMap, (X509TrustManager)object));
                }
            }
            catch (Exception exception) {
                throw new SSLException("unable to setup trustmanager", exception);
            }
            return new ReferenceCountedOpenSslClientContext$OpenSslClientSessionContext(referenceCountedOpenSslContext);
        }
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }
}

