/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslCertificateException;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslEngineMap;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLHandshakeException;
import org.apache.tomcat.jni.CertificateVerifier;

abstract class ReferenceCountedOpenSslContext$AbstractCertificateVerifier
implements CertificateVerifier {
    private final OpenSslEngineMap engineMap;

    ReferenceCountedOpenSslContext$AbstractCertificateVerifier(OpenSslEngineMap openSslEngineMap) {
        this.engineMap = openSslEngineMap;
    }

    public final int verify(long l2, byte[][] object, String string) {
        object = ReferenceCountedOpenSslContext.certificates(object);
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l2);
        try {
            this.verify(referenceCountedOpenSslEngine, (X509Certificate[])object, string);
            return 0;
        }
        catch (Throwable throwable) {
            ReferenceCountedOpenSslContext.access$200().debug("verification of certificate failed", throwable);
            SSLHandshakeException sSLHandshakeException = new SSLHandshakeException("General OpenSslEngine problem");
            object = sSLHandshakeException;
            sSLHandshakeException.initCause(throwable);
            referenceCountedOpenSslEngine.handshakeException = object;
            if (throwable instanceof OpenSslCertificateException) {
                return ((OpenSslCertificateException)throwable).errorCode();
            }
            if (throwable instanceof CertificateExpiredException) {
                return 10;
            }
            if (throwable instanceof CertificateNotYetValidException) {
                return 9;
            }
            if (PlatformDependent.javaVersion() >= 7 && throwable instanceof CertificateRevokedException) {
                return 23;
            }
            return 1;
        }
    }

    abstract void verify(ReferenceCountedOpenSslEngine var1, X509Certificate[] var2, String var3);
}

