/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ApplicationProtocolConfig$SelectorFailureBehavior;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ApplicationProtocolNegotiator;
import com.aliyun.openservices.shade.io.netty.handler.ssl.CipherSuiteConverter;
import com.aliyun.openservices.shade.io.netty.handler.ssl.CipherSuiteFilter;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ClientAuth;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSsl;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslEngineMap;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslSessionContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslSessionStats;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslX509Certificate;
import com.aliyun.openservices.shade.io.netty.handler.ssl.PemEncoded;
import com.aliyun.openservices.shade.io.netty.handler.ssl.PemPrivateKey;
import com.aliyun.openservices.shade.io.netty.handler.ssl.PemX509Certificate;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslContext$1;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslContext$2;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslContext$3;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslContext$4;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslContext$DefaultOpenSslEngineMap;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslUtils;
import com.aliyun.openservices.shade.io.netty.util.AbstractReferenceCounted;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCounted;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeak;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeakDetector;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeakDetectorFactory;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLContext;

public abstract class ReferenceCountedOpenSslContext
extends SslContext
implements ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslContext.class);
    private static final boolean JDK_REJECT_CLIENT_INITIATED_RENEGOTIATION = AccessController.doPrivileged(new ReferenceCountedOpenSslContext$1());
    private static final List<String> DEFAULT_CIPHERS;
    private static final Integer DH_KEY_LENGTH;
    private static final ResourceLeakDetector<ReferenceCountedOpenSslContext> leakDetector;
    protected static final int VERIFY_DEPTH = 10;
    protected volatile long ctx;
    long aprPool;
    private volatile int aprPoolDestroyed;
    private final List<String> unmodifiableCiphers;
    private final long sessionCacheSize;
    private final long sessionTimeout;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final int mode;
    private final ResourceLeak leak;
    private final AbstractReferenceCounted refCnt = new ReferenceCountedOpenSslContext$2(this);
    final Certificate[] keyCertChain;
    final ClientAuth clientAuth;
    final OpenSslEngineMap engineMap = new ReferenceCountedOpenSslContext$DefaultOpenSslEngineMap(null);
    volatile boolean rejectRemoteInitiatedRenegotiation;
    static final OpenSslApplicationProtocolNegotiator NONE_PROTOCOL_NEGOTIATOR;

    ReferenceCountedOpenSslContext(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3, int n2, Certificate[] certificateArray, ClientAuth clientAuth, boolean bl, boolean bl2) {
        this(iterable, cipherSuiteFilter, ReferenceCountedOpenSslContext.toNegotiator(applicationProtocolConfig), l2, l3, n2, certificateArray, clientAuth, bl, bl2);
    }

    ReferenceCountedOpenSslContext(Iterable<String> stringArray, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l2, long l3, int n2, Certificate[] object, ClientAuth object2, boolean bl, boolean bl2) {
        super(bl);
        OpenSsl.ensureAvailability();
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("mode most be either SSL.SSL_MODE_SERVER or SSL.SSL_MODE_CLIENT");
        }
        this.leak = bl2 ? leakDetector.open(this) : null;
        this.mode = n2;
        ClientAuth clientAuth = this.clientAuth = this.isServer() ? ObjectUtil.checkNotNull(object2, "clientAuth") : ClientAuth.NONE;
        if (n2 == 1) {
            this.rejectRemoteInitiatedRenegotiation = JDK_REJECT_CLIENT_INITIATED_RENEGOTIATION;
        }
        Certificate[] certificateArray = this.keyCertChain = object == null ? null : (Certificate[])object.clone();
        if (stringArray == null) {
            object = null;
        } else {
            object = new ArrayList();
            stringArray = stringArray.iterator();
            while (stringArray.hasNext() && (object2 = (String)stringArray.next()) != null) {
                String string = CipherSuiteConverter.toOpenSsl((String)object2);
                if (string != null) {
                    object2 = string;
                }
                object.add(object2);
            }
        }
        this.unmodifiableCiphers = Arrays.asList(ObjectUtil.checkNotNull(cipherSuiteFilter, "cipherFilter").filterCipherSuites((Iterable<String>)object, DEFAULT_CIPHERS, OpenSsl.availableCipherSuites()));
        this.apn = ObjectUtil.checkNotNull(openSslApplicationProtocolNegotiator, "apn");
        this.aprPool = Pool.create((long)0L);
        try {
            object2 = ReferenceCountedOpenSslContext.class;
            synchronized (ReferenceCountedOpenSslContext.class) {
                try {
                    this.ctx = SSLContext.make((long)this.aprPool, (int)31, (int)n2);
                }
                catch (Exception exception) {
                    throw new SSLException("failed to create an SSL_CTX", exception);
                }
                SSLContext.setOptions((long)this.ctx, (int)4095);
                SSLContext.setOptions((long)this.ctx, (int)0x1000000);
                SSLContext.setOptions((long)this.ctx, (int)0x2000000);
                SSLContext.setOptions((long)this.ctx, (int)0x400000);
                SSLContext.setOptions((long)this.ctx, (int)524288);
                SSLContext.setOptions((long)this.ctx, (int)0x100000);
                SSLContext.setOptions((long)this.ctx, (int)65536);
                SSLContext.setOptions((long)this.ctx, (int)16384);
                SSLContext.setMode((long)this.ctx, (int)(SSLContext.getMode((long)this.ctx) | 2));
                if (DH_KEY_LENGTH != null) {
                    SSLContext.setTmpDHLength((long)this.ctx, (int)DH_KEY_LENGTH);
                }
                try {
                    SSLContext.setCipherSuite((long)this.ctx, (String)CipherSuiteConverter.toOpenSsl(this.unmodifiableCiphers));
                }
                catch (SSLException sSLException) {
                    SSLException sSLException2 = sSLException;
                    throw sSLException;
                }
                catch (Exception exception) {
                    throw new SSLException("failed to set cipher suite: " + this.unmodifiableCiphers, exception);
                }
                List<String> list = openSslApplicationProtocolNegotiator.protocols();
                if (!list.isEmpty()) {
                    List<String> list2 = list;
                    stringArray = list2.toArray(new String[list2.size()]);
                    int n3 = ReferenceCountedOpenSslContext.opensslSelectorFailureBehavior(openSslApplicationProtocolNegotiator.selectorFailureBehavior());
                    switch (openSslApplicationProtocolNegotiator.protocol()) {
                        case NPN: {
                            SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray, (int)n3);
                            break;
                        }
                        case ALPN: {
                            SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray, (int)n3);
                            break;
                        }
                        case NPN_AND_ALPN: {
                            SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray, (int)n3);
                            SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray, (int)n3);
                            break;
                        }
                        default: {
                            throw new Error();
                        }
                    }
                }
                if (l2 > 0L) {
                    this.sessionCacheSize = l2;
                    SSLContext.setSessionCacheSize((long)this.ctx, (long)l2);
                } else {
                    this.sessionCacheSize = l2 = SSLContext.setSessionCacheSize((long)this.ctx, (long)20480L);
                    SSLContext.setSessionCacheSize((long)this.ctx, (long)l2);
                }
                if (l3 > 0L) {
                    this.sessionTimeout = l3;
                    SSLContext.setSessionCacheTimeout((long)this.ctx, (long)l3);
                } else {
                    this.sessionTimeout = l3 = SSLContext.setSessionCacheTimeout((long)this.ctx, (long)300L);
                    SSLContext.setSessionCacheTimeout((long)this.ctx, (long)l3);
                }
                // ** MonitorExit[var10_11 /* !! */ ] (shouldn't be in output)
            }
        }
        catch (Throwable throwable) {
            this.release();
            throw throwable;
        }
        {
            return;
        }
    }

    private static int opensslSelectorFailureBehavior(ApplicationProtocolConfig$SelectorFailureBehavior applicationProtocolConfig$SelectorFailureBehavior) {
        switch (applicationProtocolConfig$SelectorFailureBehavior) {
            case NO_ADVERTISE: {
                return 0;
            }
            case CHOOSE_MY_LAST_PROTOCOL: {
                return 1;
            }
        }
        throw new Error();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCiphers;
    }

    @Override
    public final long sessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public final long sessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    @Override
    public final boolean isClient() {
        return this.mode == 0;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n2) {
        return this.newEngine0(byteBufAllocator, string, n2);
    }

    SSLEngine newEngine0(ByteBufAllocator byteBufAllocator, String string, int n2) {
        return new ReferenceCountedOpenSslEngine(this, byteBufAllocator, string, n2, true);
    }

    abstract OpenSslKeyMaterialManager keyMaterialManager();

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator) {
        return ((SslContext)this).newEngine(byteBufAllocator, null, -1);
    }

    @Deprecated
    public final long context() {
        return this.ctx;
    }

    @Deprecated
    public final OpenSslSessionStats stats() {
        return this.sessionContext().stats();
    }

    public void setRejectRemoteInitiatedRenegotiation(boolean bl) {
        this.rejectRemoteInitiatedRenegotiation = bl;
    }

    @Deprecated
    public final void setTicketKeys(byte[] byArray) {
        this.sessionContext().setTicketKeys(byArray);
    }

    @Override
    public abstract OpenSslSessionContext sessionContext();

    public final long sslCtxPointer() {
        return this.ctx;
    }

    final void destroy() {
        Class<ReferenceCountedOpenSslContext> clazz = ReferenceCountedOpenSslContext.class;
        synchronized (ReferenceCountedOpenSslContext.class) {
            if (this.ctx != 0L) {
                SSLContext.free((long)this.ctx);
                this.ctx = 0L;
            }
            if (this.aprPool != 0L) {
                Pool.destroy((long)this.aprPool);
                this.aprPool = 0L;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static X509Certificate[] certificates(byte[][] byArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[byArray.length];
        for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
            x509CertificateArray[i2] = new OpenSslX509Certificate(byArray[i2]);
        }
        return x509CertificateArray;
    }

    protected static X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray) {
        for (TrustManager trustManager : trustManagerArray) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new IllegalStateException("no X509TrustManager found");
    }

    protected static X509KeyManager chooseX509KeyManager(KeyManager[] keyManagerArray) {
        for (KeyManager keyManager : keyManagerArray) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        throw new IllegalStateException("no X509KeyManager found");
    }

    static OpenSslApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig) {
        if (applicationProtocolConfig == null) {
            return NONE_PROTOCOL_NEGOTIATOR;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return NONE_PROTOCOL_NEGOTIATOR;
            }
            case NPN: 
            case ALPN: 
            case NPN_AND_ALPN: {
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case CHOOSE_MY_LAST_PROTOCOL: 
                    case ACCEPT: {
                        switch (applicationProtocolConfig.selectorFailureBehavior()) {
                            case NO_ADVERTISE: 
                            case CHOOSE_MY_LAST_PROTOCOL: {
                                return new OpenSslDefaultApplicationProtocolNegotiator(applicationProtocolConfig);
                            }
                        }
                        throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " behavior");
                    }
                }
                throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " behavior");
            }
        }
        throw new Error();
    }

    static boolean useExtendedTrustManager(X509TrustManager x509TrustManager) {
        return PlatformDependent.javaVersion() >= 7 && x509TrustManager instanceof X509ExtendedTrustManager;
    }

    static boolean useExtendedKeyManager(X509KeyManager x509KeyManager) {
        return PlatformDependent.javaVersion() >= 7 && x509KeyManager instanceof X509ExtendedKeyManager;
    }

    @Override
    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    @Override
    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    @Override
    public final ReferenceCounted retain(int n2) {
        this.refCnt.retain(n2);
        return this;
    }

    @Override
    public final boolean release() {
        return this.refCnt.release();
    }

    @Override
    public final boolean release(int n2) {
        return this.refCnt.release(n2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void setKeyMaterial(long l2, X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) {
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        PemEncoded pemEncoded = null;
        try {
            pemEncoded = PemX509Certificate.toPEM(ByteBufAllocator.DEFAULT, true, x509CertificateArray);
            l4 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            l5 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            if (privateKey != null) {
                l3 = ReferenceCountedOpenSslContext.toBIO(privateKey);
            }
            SSLContext.setCertificateBio((long)l2, (long)l4, (long)l3, (String)(string == null ? "" : string));
            SSLContext.setCertificateChainBio((long)l2, (long)l5, (boolean)true);
        }
        catch (SSLException sSLException) {
            try {
                SSLException sSLException2 = sSLException;
                throw sSLException;
                catch (Exception exception) {
                    throw new SSLException("failed to set certificate and key", exception);
                }
            }
            catch (Throwable throwable) {
                ReferenceCountedOpenSslContext.freeBio(l3);
                ReferenceCountedOpenSslContext.freeBio(l4);
                ReferenceCountedOpenSslContext.freeBio(l5);
                if (pemEncoded != null) {
                    pemEncoded.release();
                }
                throw throwable;
            }
        }
        ReferenceCountedOpenSslContext.freeBio(l3);
        ReferenceCountedOpenSslContext.freeBio(l4);
        ReferenceCountedOpenSslContext.freeBio(l5);
        if (pemEncoded != null) {
            pemEncoded.release();
            return;
        }
    }

    static void freeBio(long l2) {
        if (l2 != 0L) {
            SSL.freeBIO((long)l2);
        }
    }

    static long toBIO(PrivateKey object) {
        if (object == null) {
            return 0L;
        }
        ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
        object = PemPrivateKey.toPEM(byteBufAllocator, true, (PrivateKey)object);
        try {
            long l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, object.retain());
            return l2;
        }
        finally {
            object.release();
        }
    }

    static long toBIO(X509Certificate ... object) {
        if (object == null) {
            return 0L;
        }
        if (((X509Certificate[])object).length == 0) {
            throw new IllegalArgumentException("certChain can't be empty");
        }
        ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
        object = PemX509Certificate.toPEM(byteBufAllocator, true, (X509Certificate[])object);
        try {
            long l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, object.retain());
            return l2;
        }
        finally {
            object.release();
        }
    }

    static long toBIO(ByteBufAllocator object, PemEncoded pemEncoded) {
        try {
            long l2;
            ByteBuf byteBuf = pemEncoded.content();
            if (byteBuf.isDirect()) {
                long l3 = ReferenceCountedOpenSslContext.newBIO(byteBuf.slice().retain());
                return l3;
            }
            object = object.directBuffer(byteBuf.readableBytes());
            try {
                ByteBuf byteBuf2 = byteBuf;
                ((ByteBuf)object).writeBytes(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
                l2 = ReferenceCountedOpenSslContext.newBIO(((ByteBuf)object).slice().retain());
            }
            catch (Throwable throwable) {
                try {
                    if (pemEncoded.isSensitive()) {
                        SslUtils.zeroout((ByteBuf)object);
                    }
                }
                finally {
                    object.release();
                }
                throw throwable;
            }
            try {
                if (pemEncoded.isSensitive()) {
                    SslUtils.zeroout((ByteBuf)object);
                }
            }
            finally {
                object.release();
            }
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    private static long newBIO(ByteBuf byteBuf) {
        try {
            long l2 = SSL.newMemBIO();
            int n2 = byteBuf.readableBytes();
            if (SSL.writeToBIO((long)l2, (long)(OpenSsl.memoryAddress(byteBuf) + (long)byteBuf.readerIndex()), (int)n2) != n2) {
                SSL.freeBIO((long)l2);
                throw new IllegalStateException("Could not write data to memory BIO");
            }
            return l2;
        }
        finally {
            byteBuf.release();
        }
    }

    static /* synthetic */ ResourceLeak access$000(ReferenceCountedOpenSslContext referenceCountedOpenSslContext) {
        return referenceCountedOpenSslContext.leak;
    }

    static /* synthetic */ InternalLogger access$200() {
        return logger;
    }

    static {
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslContext.class);
        NONE_PROTOCOL_NEGOTIATOR = new ReferenceCountedOpenSslContext$3();
        Serializable serializable = new ArrayList();
        Collections.addAll(serializable, new String[]{"ECDHE-ECDSA-AES256-GCM-SHA384", "ECDHE-ECDSA-AES128-GCM-SHA256", "ECDHE-RSA-AES128-GCM-SHA256", "ECDHE-RSA-AES128-SHA", "ECDHE-RSA-AES256-SHA", "AES128-GCM-SHA256", "AES128-SHA", "AES256-SHA"});
        DEFAULT_CIPHERS = Collections.unmodifiableList(serializable);
        if (logger.isDebugEnabled()) {
            logger.debug("Default cipher suite (OpenSSL): " + serializable);
        }
        serializable = null;
        try {
            String string = AccessController.doPrivileged(new ReferenceCountedOpenSslContext$4());
            if (string != null) {
                try {
                    serializable = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug("ReferenceCountedOpenSslContext supports -Djdk.tls.ephemeralDHKeySize={int}, but got: " + string);
                }
            }
        }
        catch (Throwable throwable) {}
        DH_KEY_LENGTH = serializable;
    }
}

