/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.handler.ssl.ApplicationProtocolAccessor;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ApplicationProtocolConfig$SelectedListenerFailureBehavior;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslJavaxX509Certificate;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslSessionContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslX509Certificate;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$HandshakeState;
import com.aliyun.openservices.shade.io.netty.util.internal.EmptyArrays;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;
import org.apache.tomcat.jni.SSL;

final class ReferenceCountedOpenSslEngine$OpenSslSession
implements ApplicationProtocolAccessor,
SSLSession {
    private final OpenSslSessionContext sessionContext;
    private X509Certificate[] x509PeerCerts;
    private String protocol;
    private String applicationProtocol;
    private Certificate[] peerCerts;
    private String cipher;
    private byte[] id;
    private long creationTime;
    private Map<String, Object> values;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ ReferenceCountedOpenSslEngine this$0;

    ReferenceCountedOpenSslEngine$OpenSslSession(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, OpenSslSessionContext openSslSessionContext) {
        this.this$0 = referenceCountedOpenSslEngine;
        this.sessionContext = openSslSessionContext;
    }

    @Override
    public final byte[] getId() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.id == null) {
                return EmptyArrays.EMPTY_BYTES;
            }
            return (byte[])this.id.clone();
        }
    }

    @Override
    public final SSLSessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public final long getCreationTime() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.creationTime == 0L && !ReferenceCountedOpenSslEngine.access$100(this.this$0)) {
                this.creationTime = SSL.getTime((long)ReferenceCountedOpenSslEngine.access$200(this.this$0)) * 1000L;
            }
        }
        return this.creationTime;
    }

    @Override
    public final long getLastAccessedTime() {
        long l2 = ReferenceCountedOpenSslEngine.access$300(this.this$0);
        if (l2 == -1L) {
            return this.getCreationTime();
        }
        return l2;
    }

    @Override
    public final void invalidate() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (!ReferenceCountedOpenSslEngine.access$100(this.this$0)) {
                SSL.setTimeout((long)ReferenceCountedOpenSslEngine.access$200(this.this$0), (long)0L);
            }
            return;
        }
    }

    @Override
    public final boolean isValid() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (!ReferenceCountedOpenSslEngine.access$100(this.this$0)) {
                return System.currentTimeMillis() - SSL.getTimeout((long)ReferenceCountedOpenSslEngine.access$200(this.this$0)) * 1000L < SSL.getTime((long)ReferenceCountedOpenSslEngine.access$200(this.this$0)) * 1000L;
            }
        }
        return false;
    }

    @Override
    public final void putValue(String string, Object object) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (object == null) {
            throw new NullPointerException("value");
        }
        Map<String, Object> map = this.values;
        if (map == null) {
            this.values = new HashMap<String, Object>(2);
            map = this.values;
        }
        map = map.put(string, object);
        if (object instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)object).valueBound(new SSLSessionBindingEvent(this, string));
        }
        this.notifyUnbound(map, string);
    }

    @Override
    public final Object getValue(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.values == null) {
            return null;
        }
        return this.values.get(string);
    }

    @Override
    public final void removeValue(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        Map<String, Object> map = this.values;
        if (map == null) {
            return;
        }
        map = map.remove(string);
        this.notifyUnbound(map, string);
    }

    @Override
    public final String[] getValueNames() {
        Map<String, Object> map = this.values;
        if (map == null || map.isEmpty()) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        return map.keySet().toArray(new String[map.size()]);
    }

    private void notifyUnbound(Object object, String string) {
        if (object instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)object).valueUnbound(new SSLSessionBindingEvent(this, string));
        }
    }

    final void handshakeFinished() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (ReferenceCountedOpenSslEngine.access$100(this.this$0)) {
                throw new SSLException("Already closed");
            }
            this.id = SSL.getSessionId((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
            this.cipher = ReferenceCountedOpenSslEngine.access$400(this.this$0, SSL.getCipherForSSL((long)ReferenceCountedOpenSslEngine.access$200(this.this$0)));
            this.protocol = SSL.getVersion((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
            this.initPeerCerts();
            this.selectApplicationProtocol();
            ReferenceCountedOpenSslEngine.access$502(this.this$0, ReferenceCountedOpenSslEngine$HandshakeState.FINISHED);
            return;
        }
    }

    private void initPeerCerts() {
        byte[][] byArray = SSL.getPeerCertChain((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
        byte[] byArray2 = !ReferenceCountedOpenSslEngine.access$600(this.this$0) ? SSL.getPeerCertificate((long)ReferenceCountedOpenSslEngine.access$200(this.this$0)) : null;
        if (byArray == null || byArray.length == 0) {
            if (byArray2 == null || byArray2.length == 0) {
                this.peerCerts = EmptyArrays.EMPTY_CERTIFICATES;
                this.x509PeerCerts = EmptyArrays.EMPTY_JAVAX_X509_CERTIFICATES;
                return;
            }
            this.peerCerts = new Certificate[1];
            this.x509PeerCerts = new X509Certificate[1];
            this.peerCerts[0] = new OpenSslX509Certificate(byArray2);
            this.x509PeerCerts[0] = new OpenSslJavaxX509Certificate(byArray2);
            return;
        }
        if (byArray2 == null || byArray2.length == 0) {
            this.peerCerts = new Certificate[byArray.length];
            this.x509PeerCerts = new X509Certificate[byArray.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byArray2 = byArray[i2];
                this.peerCerts[i2] = new OpenSslX509Certificate(byArray2);
                this.x509PeerCerts[i2] = new OpenSslJavaxX509Certificate(byArray2);
            }
            return;
        }
        int n2 = byArray2.length + 1;
        this.peerCerts = new Certificate[n2];
        this.x509PeerCerts = new X509Certificate[n2];
        this.peerCerts[0] = new OpenSslX509Certificate(byArray2);
        this.x509PeerCerts[0] = new OpenSslJavaxX509Certificate(byArray2);
        int n3 = 0;
        n2 = 1;
        while (n3 < byArray.length) {
            byte[] byArray3 = byArray[n3];
            this.peerCerts[n2] = new OpenSslX509Certificate(byArray3);
            this.x509PeerCerts[n2] = new OpenSslJavaxX509Certificate(byArray3);
            ++n3;
            ++n2;
        }
    }

    private void selectApplicationProtocol() {
        ApplicationProtocolConfig$SelectedListenerFailureBehavior applicationProtocolConfig$SelectedListenerFailureBehavior = ReferenceCountedOpenSslEngine.access$700(this.this$0).selectedListenerFailureBehavior();
        List<String> list = ReferenceCountedOpenSslEngine.access$700(this.this$0).protocols();
        switch (ReferenceCountedOpenSslEngine.access$700(this.this$0).protocol()) {
            case NONE: {
                return;
            }
            case ALPN: {
                String string = SSL.getAlpnSelected((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
                if (string == null) break;
                this.applicationProtocol = this.selectApplicationProtocol(list, applicationProtocolConfig$SelectedListenerFailureBehavior, string);
                return;
            }
            case NPN: {
                String string = SSL.getNextProtoNegotiated((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
                if (string == null) break;
                this.applicationProtocol = this.selectApplicationProtocol(list, applicationProtocolConfig$SelectedListenerFailureBehavior, string);
                return;
            }
            case NPN_AND_ALPN: {
                String string = SSL.getAlpnSelected((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
                if (string == null) {
                    string = SSL.getNextProtoNegotiated((long)ReferenceCountedOpenSslEngine.access$200(this.this$0));
                }
                if (string == null) break;
                this.applicationProtocol = this.selectApplicationProtocol(list, applicationProtocolConfig$SelectedListenerFailureBehavior, string);
                return;
            }
            default: {
                throw new Error();
            }
        }
    }

    private String selectApplicationProtocol(List<String> list, ApplicationProtocolConfig$SelectedListenerFailureBehavior applicationProtocolConfig$SelectedListenerFailureBehavior, String string) {
        if (applicationProtocolConfig$SelectedListenerFailureBehavior == ApplicationProtocolConfig$SelectedListenerFailureBehavior.ACCEPT) {
            return string;
        }
        int n2 = list.size();
        if (!$assertionsDisabled && n2 <= 0) {
            throw new AssertionError();
        }
        if (list.contains(string)) {
            return string;
        }
        if (applicationProtocolConfig$SelectedListenerFailureBehavior == ApplicationProtocolConfig$SelectedListenerFailureBehavior.CHOOSE_MY_LAST_PROTOCOL) {
            return list.get(n2 - 1);
        }
        throw new SSLException("unknown protocol " + string);
    }

    @Override
    public final Certificate[] getPeerCertificates() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.peerCerts == null || this.peerCerts.length == 0) {
                throw new SSLPeerUnverifiedException("peer not verified");
            }
            return (Certificate[])this.peerCerts.clone();
        }
    }

    @Override
    public final Certificate[] getLocalCertificates() {
        if (ReferenceCountedOpenSslEngine.access$800(this.this$0) == null) {
            return null;
        }
        return (Certificate[])ReferenceCountedOpenSslEngine.access$800(this.this$0).clone();
    }

    @Override
    public final X509Certificate[] getPeerCertificateChain() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.x509PeerCerts == null || this.x509PeerCerts.length == 0) {
                throw new SSLPeerUnverifiedException("peer not verified");
            }
            return (X509Certificate[])this.x509PeerCerts.clone();
        }
    }

    @Override
    public final Principal getPeerPrincipal() {
        Certificate[] certificateArray = this.getPeerCertificates();
        return ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
    }

    @Override
    public final Principal getLocalPrincipal() {
        Certificate[] certificateArray = ReferenceCountedOpenSslEngine.access$800(this.this$0);
        if (certificateArray == null || certificateArray.length == 0) {
            return null;
        }
        return ((java.security.cert.X509Certificate)certificateArray[0]).getIssuerX500Principal();
    }

    @Override
    public final String getCipherSuite() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.cipher == null) {
                return "SSL_NULL_WITH_NULL_NULL";
            }
            return this.cipher;
        }
    }

    @Override
    public final String getProtocol() {
        String string = this.protocol;
        if (string == null) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
            synchronized (referenceCountedOpenSslEngine) {
                string = !ReferenceCountedOpenSslEngine.access$100(this.this$0) ? SSL.getVersion((long)ReferenceCountedOpenSslEngine.access$200(this.this$0)) : "";
            }
        }
        return string;
    }

    @Override
    public final String getApplicationProtocol() {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.this$0;
        synchronized (referenceCountedOpenSslEngine) {
            return this.applicationProtocol;
        }
    }

    @Override
    public final String getPeerHost() {
        return this.this$0.getPeerHost();
    }

    @Override
    public final int getPeerPort() {
        return this.this$0.getPeerPort();
    }

    @Override
    public final int getPacketBufferSize() {
        return 18713;
    }

    @Override
    public final int getApplicationBufferSize() {
        return 16384;
    }

    static {
        $assertionsDisabled = !ReferenceCountedOpenSslEngine.class.desiredAssertionStatus();
    }
}

