/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.handler.ssl.CipherSuiteConverter;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ClientAuth;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSsl;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslEngineMap;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$1;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$HandshakeState;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$OpenSslSession;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslParametersUtils;
import com.aliyun.openservices.shade.io.netty.util.AbstractReferenceCounted;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCounted;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeak;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeakDetector;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeakDetectorFactory;
import com.aliyun.openservices.shade.io.netty.util.internal.EmptyArrays;
import com.aliyun.openservices.shade.io.netty.util.internal.InternalThreadLocalMap;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.apache.tomcat.jni.Buffer;
import org.apache.tomcat.jni.SSL;

public class ReferenceCountedOpenSslEngine
extends SSLEngine
implements ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslEngine.class);
    private static final SSLException BEGIN_HANDSHAKE_ENGINE_CLOSED = ThrowableUtil.unknownStackTrace(new SSLException("engine closed"), ReferenceCountedOpenSslEngine.class, "beginHandshake()");
    private static final SSLException HANDSHAKE_ENGINE_CLOSED = ThrowableUtil.unknownStackTrace(new SSLException("engine closed"), ReferenceCountedOpenSslEngine.class, "handshake()");
    private static final SSLException RENEGOTIATION_UNSUPPORTED = ThrowableUtil.unknownStackTrace(new SSLException("renegotiation unsupported"), ReferenceCountedOpenSslEngine.class, "beginHandshake()");
    private static final SSLException ENCRYPTED_PACKET_OVERSIZED = ThrowableUtil.unknownStackTrace(new SSLException("encrypted packet oversized"), ReferenceCountedOpenSslEngine.class, "unwrap(...)");
    private static final Class<?> SNI_HOSTNAME_CLASS;
    private static final Method GET_SERVER_NAMES_METHOD;
    private static final Method SET_SERVER_NAMES_METHOD;
    private static final Method GET_ASCII_NAME_METHOD;
    private static final Method GET_USE_CIPHER_SUITES_ORDER_METHOD;
    private static final Method SET_USE_CIPHER_SUITES_ORDER_METHOD;
    private static final ResourceLeakDetector<ReferenceCountedOpenSslEngine> leakDetector;
    private static final int MAX_PLAINTEXT_LENGTH = 16384;
    private static final int MAX_COMPRESSED_LENGTH = 17408;
    private static final int MAX_CIPHERTEXT_LENGTH = 18432;
    static final int MAX_ENCRYPTED_PACKET_LENGTH = 18713;
    static final int MAX_ENCRYPTION_OVERHEAD_LENGTH = 2329;
    private static final AtomicIntegerFieldUpdater<ReferenceCountedOpenSslEngine> DESTROYED_UPDATER;
    private static final String INVALID_CIPHER = "SSL_NULL_WITH_NULL_NULL";
    private static final long EMPTY_ADDR;
    private static final SSLEngineResult NEED_UNWRAP_OK;
    private static final SSLEngineResult NEED_UNWRAP_CLOSED;
    private static final SSLEngineResult NEED_WRAP_OK;
    private static final SSLEngineResult NEED_WRAP_CLOSED;
    private static final SSLEngineResult CLOSED_NOT_HANDSHAKING;
    private long ssl;
    private long networkBIO;
    private boolean certificateSet;
    private ReferenceCountedOpenSslEngine$HandshakeState handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED;
    private boolean receivedShutdown;
    private volatile int destroyed;
    private final ResourceLeak leak;
    private final AbstractReferenceCounted refCnt = new ReferenceCountedOpenSslEngine$1(this);
    private volatile ClientAuth clientAuth = ClientAuth.NONE;
    private volatile long lastAccessed = -1L;
    private String endPointIdentificationAlgorithm;
    private Object algorithmConstraints;
    private List<?> sniHostNames;
    private boolean isInboundDone;
    private boolean isOutboundDone;
    private boolean engineClosed;
    private final boolean clientMode;
    private final ByteBufAllocator alloc;
    private final OpenSslEngineMap engineMap;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final boolean rejectRemoteInitiatedRenegation;
    private final ReferenceCountedOpenSslEngine$OpenSslSession session;
    private final Certificate[] localCerts;
    private final ByteBuffer[] singleSrcBuffer = new ByteBuffer[1];
    private final ByteBuffer[] singleDstBuffer = new ByteBuffer[1];
    private final OpenSslKeyMaterialManager keyMaterialManager;
    SSLHandshakeException handshakeException;

    ReferenceCountedOpenSslEngine(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, ByteBufAllocator byteBufAllocator, String string, int n2, boolean bl) {
        super(string, n2);
        OpenSsl.ensureAvailability();
        this.leak = bl ? leakDetector.open(this) : null;
        this.alloc = ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        this.apn = (OpenSslApplicationProtocolNegotiator)((SslContext)referenceCountedOpenSslContext).applicationProtocolNegotiator();
        this.ssl = SSL.newSSL((long)referenceCountedOpenSslContext.ctx, (!((SslContext)referenceCountedOpenSslContext).isClient() ? 1 : 0) != 0);
        this.session = new ReferenceCountedOpenSslEngine$OpenSslSession(this, referenceCountedOpenSslContext.sessionContext());
        this.networkBIO = SSL.makeNetworkBIO((long)this.ssl);
        this.clientMode = ((SslContext)referenceCountedOpenSslContext).isClient();
        this.engineMap = referenceCountedOpenSslContext.engineMap;
        this.rejectRemoteInitiatedRenegation = referenceCountedOpenSslContext.rejectRemoteInitiatedRenegotiation;
        this.localCerts = referenceCountedOpenSslContext.keyCertChain;
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        referenceCountedOpenSslEngine.setClientAuth(referenceCountedOpenSslEngine.clientMode ? ClientAuth.NONE : referenceCountedOpenSslContext.clientAuth);
        if (this.clientMode && string != null) {
            SSL.setTlsExtHostName((long)this.ssl, (String)string);
        }
        this.keyMaterialManager = referenceCountedOpenSslContext.keyMaterialManager();
    }

    @Override
    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    @Override
    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    @Override
    public final ReferenceCounted retain(int n2) {
        this.refCnt.retain(n2);
        return this;
    }

    @Override
    public final boolean release() {
        return this.refCnt.release();
    }

    @Override
    public final boolean release(int n2) {
        return this.refCnt.release(n2);
    }

    @Override
    public final synchronized SSLSession getHandshakeSession() {
        switch (this.handshakeState) {
            case NOT_STARTED: 
            case FINISHED: {
                return null;
            }
        }
        return this.session;
    }

    public final synchronized long sslPointer() {
        return this.ssl;
    }

    public final synchronized void shutdown() {
        if (DESTROYED_UPDATER.compareAndSet(this, 0, 1)) {
            this.engineMap.remove(this.ssl);
            SSL.freeSSL((long)this.ssl);
            SSL.freeBIO((long)this.networkBIO);
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            referenceCountedOpenSslEngine.networkBIO = 0L;
            referenceCountedOpenSslEngine.ssl = 0L;
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine2 = this;
            this.engineClosed = true;
            referenceCountedOpenSslEngine2.isOutboundDone = true;
            referenceCountedOpenSslEngine2.isInboundDone = true;
        }
        SSL.clearError();
    }

    private int writePlaintextData(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        int n4 = Math.min(n3 - n2, 16384);
        if (byteBuffer.isDirect()) {
            long l2 = Buffer.address((ByteBuffer)byteBuffer) + (long)n2;
            n3 = SSL.writeToSSL((long)this.ssl, (long)l2, (int)n4);
            if (n3 > 0) {
                byteBuffer.position(n2 + n3);
            }
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n4);
            try {
                long l3 = OpenSsl.memoryAddress(byteBuf);
                byteBuffer.limit(n2 + n4);
                byteBuf.setBytes(0, byteBuffer);
                byteBuffer.limit(n3);
                n3 = SSL.writeToSSL((long)this.ssl, (long)l3, (int)n4);
                if (n3 > 0) {
                    byteBuffer.position(n2 + n3);
                } else {
                    byteBuffer.position(n2);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n3;
    }

    private int writeEncryptedData(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.remaining();
        if (byteBuffer.isDirect()) {
            long l2 = Buffer.address((ByteBuffer)byteBuffer) + (long)n2;
            n3 = SSL.writeToBIO((long)this.networkBIO, (long)l2, (int)n3);
            if (n3 >= 0) {
                byteBuffer.position(n2 + n3);
            }
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n3);
            try {
                long l3 = OpenSsl.memoryAddress(byteBuf);
                byteBuf.setBytes(0, byteBuffer);
                n3 = SSL.writeToBIO((long)this.networkBIO, (long)l3, (int)n3);
                if (n3 >= 0) {
                    byteBuffer.position(n2 + n3);
                } else {
                    byteBuffer.position(n2);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n3;
    }

    private int readPlaintextData(ByteBuffer byteBuffer) {
        int n2;
        if (byteBuffer.isDirect()) {
            int n3;
            int n4 = byteBuffer.position();
            long l2 = Buffer.address((ByteBuffer)byteBuffer) + (long)n4;
            n2 = SSL.readFromSSL((long)this.ssl, (long)l2, (int)(n3 = byteBuffer.limit() - n4));
            if (n2 > 0) {
                byteBuffer.position(n4 + n2);
            }
        } else {
            int n5 = byteBuffer.position();
            int n6 = byteBuffer.limit();
            n2 = Math.min(18713, n6 - n5);
            ByteBuf byteBuf = this.alloc.directBuffer(n2);
            try {
                long l3 = OpenSsl.memoryAddress(byteBuf);
                n2 = SSL.readFromSSL((long)this.ssl, (long)l3, (int)n2);
                if (n2 > 0) {
                    byteBuffer.limit(n5 + n2);
                    byteBuf.getBytes(0, byteBuffer);
                    byteBuffer.limit(n6);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n2;
    }

    private int readEncryptedData(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer.isDirect() && byteBuffer.remaining() >= n2) {
            int n3 = byteBuffer.position();
            long l2 = Buffer.address((ByteBuffer)byteBuffer) + (long)n3;
            n2 = SSL.readFromBIO((long)this.networkBIO, (long)l2, (int)n2);
            if (n2 > 0) {
                byteBuffer.position(n3 + n2);
                return n2;
            }
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n2);
            try {
                long l3 = OpenSsl.memoryAddress(byteBuf);
                n2 = SSL.readFromBIO((long)this.networkBIO, (long)l3, (int)n2);
                if (n2 > 0) {
                    int n4 = byteBuffer.limit();
                    ByteBuffer byteBuffer2 = byteBuffer;
                    byteBuffer2.limit(byteBuffer2.position() + n2);
                    byteBuf.getBytes(0, byteBuffer);
                    byteBuffer.limit(n4);
                    return n2;
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n2;
    }

    private SSLEngineResult readPendingBytesFromBIO(ByteBuffer byteBuffer, int n2, int n3, SSLEngineResult.HandshakeStatus handshakeStatus) {
        int n4 = SSL.pendingWrittenBytesInBIO((long)this.networkBIO);
        if (n4 > 0) {
            int n5 = byteBuffer.remaining();
            if (n5 < n4) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus(n4) : handshakeStatus), n2, n3);
            }
            int n6 = this.readEncryptedData(byteBuffer, n4);
            if (n6 <= 0) {
                SSL.clearError();
            } else {
                n3 += n6;
                n4 -= n6;
            }
            if (this.isOutboundDone) {
                this.shutdown();
            }
            return new SSLEngineResult(this.getEngineStatus(), this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus(n4) : handshakeStatus), n2, n3);
        }
        return null;
    }

    @Override
    public final SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n2, int n3, ByteBuffer byteBuffer) {
        if (byteBufferArray == null) {
            throw new IllegalArgumentException("srcs is null");
        }
        if (byteBuffer == null) {
            throw new IllegalArgumentException("dst is null");
        }
        if (n2 >= byteBufferArray.length || n2 + n3 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset: " + n2 + ", length: " + n3 + " (expected: offset <= offset + length <= srcs.length (" + byteBufferArray.length + "))");
        }
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            SSLEngineResult sSLEngineResult;
            if (this.isDestroyed()) {
                return CLOSED_NOT_HANDSHAKING;
            }
            SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY) {
                    this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_IMPLICITLY;
                }
                if ((handshakeStatus = this.handshake()) == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    return NEED_UNWRAP_OK;
                }
                if (this.engineClosed) {
                    return NEED_UNWRAP_CLOSED;
                }
            }
            int n4 = 0;
            int n5 = 0;
            n3 = n2 + n3;
            while (n2 < n3) {
                ByteBuffer byteBuffer2 = byteBufferArray[n2];
                if (byteBuffer2 == null) {
                    throw new IllegalArgumentException("srcs[" + n2 + "] is null");
                }
                while (byteBuffer2.hasRemaining()) {
                    int n6 = this.writePlaintextData(byteBuffer2);
                    if (n6 > 0) {
                        SSLEngineResult sSLEngineResult2 = this.readPendingBytesFromBIO(byteBuffer, n5 += n6, n4, handshakeStatus);
                        if (sSLEngineResult2 == null) continue;
                        if (sSLEngineResult2.getStatus() != SSLEngineResult.Status.OK) {
                            return sSLEngineResult2;
                        }
                        n4 = sSLEngineResult2.bytesProduced();
                        continue;
                    }
                    int n7 = SSL.getError((long)this.ssl, (int)n6);
                    switch (n7) {
                        case 6: {
                            SSLEngineResult sSLEngineResult3;
                            if (!this.receivedShutdown) {
                                this.closeAll();
                            }
                            SSLEngineResult sSLEngineResult4 = (sSLEngineResult3 = this.readPendingBytesFromBIO(byteBuffer, n5, n4, handshakeStatus)) != null ? sSLEngineResult3 : CLOSED_NOT_HANDSHAKING;
                            return sSLEngineResult4;
                        }
                        case 2: {
                            SSLEngineResult sSLEngineResult5 = this.readPendingBytesFromBIO(byteBuffer, n5, n4, handshakeStatus);
                            return sSLEngineResult5 != null ? sSLEngineResult5 : new SSLEngineResult(this.getEngineStatus(), SSLEngineResult.HandshakeStatus.NEED_UNWRAP, n5, n4);
                        }
                        case 3: {
                            SSLEngineResult sSLEngineResult6 = this.readPendingBytesFromBIO(byteBuffer, n5, n4, handshakeStatus);
                            return sSLEngineResult6 != null ? sSLEngineResult6 : NEED_WRAP_CLOSED;
                        }
                    }
                    throw this.shutdownWithError("SSL_write");
                }
                ++n2;
            }
            if (n5 == 0 && (sSLEngineResult = this.readPendingBytesFromBIO(byteBuffer, 0, n4, handshakeStatus)) != null) {
                return sSLEngineResult;
            }
            return this.newResult(n5, n4, handshakeStatus);
        }
    }

    private SSLException shutdownWithError(String string) {
        String string2 = SSL.getLastError();
        return this.shutdownWithError(string, string2);
    }

    private SSLException shutdownWithError(String string, String string2) {
        if (logger.isDebugEnabled()) {
            logger.debug("{} failed: OpenSSL error: {}", (Object)string, (Object)string2);
        }
        this.shutdown();
        if (this.handshakeState == ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
            return new SSLException(string2);
        }
        return new SSLHandshakeException(string2);
    }

    public final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, int n2, int n3, ByteBuffer[] byteBufferArray2, int n4, int n5) {
        Object object;
        int n6;
        if (byteBufferArray == null) {
            throw new NullPointerException("srcs");
        }
        if (n2 >= byteBufferArray.length || n2 + n3 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset: " + n2 + ", length: " + n3 + " (expected: offset <= offset + length <= srcs.length (" + byteBufferArray.length + "))");
        }
        if (byteBufferArray2 == null) {
            throw new IllegalArgumentException("dsts is null");
        }
        if (n4 >= byteBufferArray2.length || n4 + n5 > byteBufferArray2.length) {
            throw new IndexOutOfBoundsException("offset: " + n4 + ", length: " + n5 + " (expected: offset <= offset + length <= dsts.length (" + byteBufferArray2.length + "))");
        }
        long l2 = 0L;
        n5 = n4 + n5;
        for (n6 = n4; n6 < n5; ++n6) {
            object = byteBufferArray2[n6];
            if (object == null) {
                throw new IllegalArgumentException("dsts[" + n6 + "] is null");
            }
            if (object.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            l2 += (long)object.remaining();
        }
        n6 = n2 + n3;
        long l3 = 0L;
        for (n3 = n2; n3 < n6; ++n3) {
            object = byteBufferArray[n3];
            if (object == null) {
                throw new IllegalArgumentException("srcs[" + n3 + "] is null");
            }
            l3 += (long)object.remaining();
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            int n7;
            if (this.isDestroyed()) {
                return CLOSED_NOT_HANDSHAKING;
            }
            if (l3 > 18713L) {
                this.isInboundDone = true;
                this.isOutboundDone = true;
                this.engineClosed = true;
                this.shutdown();
                throw ENCRYPTED_PACKET_OVERSIZED;
            }
            object = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY) {
                    this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_IMPLICITLY;
                }
                if ((object = this.handshake()) == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    return NEED_WRAP_OK;
                }
                if (this.engineClosed) {
                    return NEED_WRAP_CLOSED;
                }
            }
            int n8 = 0;
            if (n2 < n6) {
                do {
                    ByteBuffer byteBuffer;
                    if ((n7 = (byteBuffer = byteBufferArray[n2]).remaining()) == 0) {
                        ++n2;
                        continue;
                    }
                    int n9 = this.writeEncryptedData(byteBuffer);
                    if (n9 > 0) {
                        n8 += n9;
                        if (n9 != n7) break;
                        ++n2;
                        continue;
                    }
                    SSL.clearError();
                    break;
                } while (n2 < n6);
            }
            int n10 = 0;
            if (l2 > 0L) {
                n7 = n4;
                while (n7 < n5) {
                    ByteBuffer byteBuffer = byteBufferArray2[n7];
                    if (!byteBuffer.hasRemaining()) {
                        ++n7;
                        continue;
                    }
                    int n11 = this.readPlaintextData(byteBuffer);
                    this.rejectRemoteInitiatedRenegation();
                    if (n11 > 0) {
                        n10 += n11;
                        if (!byteBuffer.hasRemaining()) {
                            ++n7;
                            continue;
                        }
                        return this.newResult(n8, n10, (SSLEngineResult.HandshakeStatus)((Object)object));
                    }
                    n11 = SSL.getError((long)this.ssl, (int)n11);
                    switch (n11) {
                        case 6: {
                            if (!this.receivedShutdown) {
                                this.closeAll();
                            }
                        }
                        case 2: 
                        case 3: {
                            return this.newResult(n8, n10, (SSLEngineResult.HandshakeStatus)((Object)object));
                        }
                    }
                    return this.sslReadErrorResult(SSL.getLastErrorNumber(), n8, n10);
                }
            } else if (SSL.readFromSSL((long)this.ssl, (long)EMPTY_ADDR, (int)0) <= 0 && OpenSsl.isError(n7 = SSL.getLastErrorNumber())) {
                return this.sslReadErrorResult(n7, n8, 0);
            }
            if (this.pendingAppData() > 0) {
                return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.mayFinishHandshake((SSLEngineResult.HandshakeStatus)((Object)(object != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : object))), n8, n10);
            }
            if (!this.receivedShutdown && (SSL.getShutdown((long)this.ssl) & 2) == 2) {
                this.closeAll();
            }
            return this.newResult(n8, n10, (SSLEngineResult.HandshakeStatus)((Object)object));
        }
    }

    private SSLEngineResult sslReadErrorResult(int n2, int n3, int n4) {
        String string = SSL.getErrorString((long)n2);
        if (SSL.pendingWrittenBytesInBIO((long)this.networkBIO) > 0) {
            if (this.handshakeException == null && this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                this.handshakeException = new SSLHandshakeException(string);
            }
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, n3, n4);
        }
        throw this.shutdownWithError("SSL_read", string);
    }

    private int pendingAppData() {
        if (this.handshakeState == ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
            return SSL.pendingReadableBytesInSSL((long)this.ssl);
        }
        return 0;
    }

    private SSLEngineResult newResult(int n2, int n3, SSLEngineResult.HandshakeStatus handshakeStatus) {
        return new SSLEngineResult(this.getEngineStatus(), this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : handshakeStatus), n2, n3);
    }

    private void closeAll() {
        this.receivedShutdown = true;
        this.closeOutbound();
        this.closeInbound();
    }

    private void rejectRemoteInitiatedRenegation() {
        if (this.rejectRemoteInitiatedRenegation && SSL.getHandshakeCount((long)this.ssl) > 1) {
            this.shutdown();
            throw new SSLHandshakeException("remote-initiated renegotation not allowed");
        }
    }

    public final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) {
        return this.unwrap(byteBufferArray, 0, byteBufferArray.length, byteBufferArray2, 0, byteBufferArray2.length);
    }

    private ByteBuffer[] singleSrcBuffer(ByteBuffer byteBuffer) {
        this.singleSrcBuffer[0] = byteBuffer;
        return this.singleSrcBuffer;
    }

    private void resetSingleSrcBuffer() {
        this.singleSrcBuffer[0] = null;
    }

    private ByteBuffer[] singleDstBuffer(ByteBuffer byteBuffer) {
        this.singleDstBuffer[0] = byteBuffer;
        return this.singleDstBuffer;
    }

    private void resetSingleDstBuffer() {
        this.singleDstBuffer[0] = null;
    }

    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer object, ByteBuffer[] byteBufferArray, int n2, int n3) {
        try {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            object = referenceCountedOpenSslEngine.unwrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)object), 0, 1, byteBufferArray, n2, n3);
            return object;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    @Override
    public final synchronized SSLEngineResult wrap(ByteBuffer object, ByteBuffer byteBuffer) {
        try {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            object = referenceCountedOpenSslEngine.wrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)object), byteBuffer);
            return object;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer object, ByteBuffer byteBuffer) {
        try {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            object = referenceCountedOpenSslEngine.unwrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)object), this.singleDstBuffer(byteBuffer));
            return object;
        }
        finally {
            this.resetSingleSrcBuffer();
            this.resetSingleDstBuffer();
        }
    }

    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer object, ByteBuffer[] byteBufferArray) {
        try {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
            object = referenceCountedOpenSslEngine.unwrap(referenceCountedOpenSslEngine.singleSrcBuffer((ByteBuffer)object), byteBufferArray);
            return object;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    @Override
    public final Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public final synchronized void closeInbound() {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        this.engineClosed = true;
        this.shutdown();
        if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED && !this.receivedShutdown) {
            throw new SSLException("Inbound closed before receiving peer's close_notify: possible truncation attack?");
        }
    }

    @Override
    public final synchronized boolean isInboundDone() {
        return this.isInboundDone || this.engineClosed;
    }

    @Override
    public final synchronized void closeOutbound() {
        block8: {
            block6: {
                block7: {
                    if (this.isOutboundDone) {
                        return;
                    }
                    this.isOutboundDone = true;
                    this.engineClosed = true;
                    if (this.handshakeState == ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED || this.isDestroyed()) break block6;
                    int n2 = SSL.getShutdown((long)this.ssl);
                    if ((n2 & 1) == 1 || (n2 = SSL.shutdownSSL((long)this.ssl)) >= 0) break block7;
                    n2 = SSL.getError((long)this.ssl, (int)n2);
                    switch (n2) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: {
                            break block8;
                        }
                        case 1: 
                        case 5: {
                            if (logger.isDebugEnabled()) {
                                logger.debug("SSL_shutdown failed: OpenSSL error: {}", (Object)SSL.getLastError());
                            }
                            this.shutdown();
                            break block8;
                        }
                        default: {
                            SSL.clearError();
                        }
                    }
                }
                return;
            }
            this.shutdown();
        }
    }

    @Override
    public final synchronized boolean isOutboundDone() {
        return this.isOutboundDone;
    }

    @Override
    public final String[] getSupportedCipherSuites() {
        Set<String> set = OpenSsl.AVAILABLE_CIPHER_SUITES;
        return set.toArray(new String[set.size()]);
    }

    @Override
    public final String[] getEnabledCipherSuites() {
        String[] stringArray;
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) {
                return EmptyArrays.EMPTY_STRINGS;
            }
            stringArray = SSL.getCiphers((long)this.ssl);
        }
        if (stringArray == null) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = this.toJavaCipherSuite(stringArray[i2]);
                if (string == null) continue;
                stringArray[i2] = string;
            }
        }
        return stringArray;
    }

    @Override
    public final void setEnabledCipherSuites(String[] object) {
        ObjectUtil.checkNotNull(object, "cipherSuites");
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object2 : object) {
            if (object2 == null) break;
            Object object3 = CipherSuiteConverter.toOpenSsl((String)object2);
            if (object3 == null) {
                object3 = object2;
            }
            if (!OpenSsl.isCipherSuiteAvailable((String)object3)) {
                throw new IllegalArgumentException("unsupported cipher suite: " + (String)object2 + '(' + (String)object3 + ')');
            }
            stringBuilder.append((String)object3);
            stringBuilder.append(':');
        }
        if (stringBuilder.length() == 0) {
            throw new IllegalArgumentException("empty cipher suites");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.setLength(stringBuilder2.length() - 1);
        String string = stringBuilder.toString();
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (!this.isDestroyed()) {
                try {
                    SSL.setCipherSuites((long)this.ssl, (String)string);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to enable cipher suites: " + string, exception);
                }
            } else {
                throw new IllegalStateException("failed to enable cipher suites: " + string);
            }
            return;
        }
    }

    @Override
    public final String[] getSupportedProtocols() {
        Set<String> set = OpenSsl.SUPPORTED_PROTOCOLS_SET;
        return set.toArray(new String[set.size()]);
    }

    @Override
    public final String[] getEnabledProtocols() {
        int n2;
        ArrayList<String> arrayList = InternalThreadLocalMap.get().arrayList();
        arrayList.add("SSLv2Hello");
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) {
                return arrayList.toArray(new String[1]);
            }
            n2 = SSL.getOptions((long)this.ssl);
        }
        if ((n2 & 0x4000000) == 0) {
            arrayList.add("TLSv1");
        }
        if ((n2 & 0x10000000) == 0) {
            arrayList.add("TLSv1.1");
        }
        if ((n2 & 0x8000000) == 0) {
            arrayList.add("TLSv1.2");
        }
        if ((n2 & 0x1000000) == 0) {
            arrayList.add("SSLv2");
        }
        if ((n2 & 0x2000000) == 0) {
            arrayList.add("SSLv3");
        }
        ArrayList<String> arrayList2 = arrayList;
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    @Override
    public final void setEnabledProtocols(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Object object = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = object[i2];
            if (!OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(string)) {
                throw new IllegalArgumentException("Protocol " + string + " is not supported.");
            }
            if (string.equals("SSLv2")) {
                bl = true;
                continue;
            }
            if (string.equals("SSLv3")) {
                bl2 = true;
                continue;
            }
            if (string.equals("TLSv1")) {
                bl3 = true;
                continue;
            }
            if (string.equals("TLSv1.1")) {
                bl4 = true;
                continue;
            }
            if (!string.equals("TLSv1.2")) continue;
            bl5 = true;
        }
        object = this;
        synchronized (object) {
            if (!this.isDestroyed()) {
                SSL.setOptions((long)this.ssl, (int)4095);
                SSL.clearOptions((long)this.ssl, (int)0x1F000000);
                n2 = 0;
                if (!bl) {
                    n2 = 0x1000000;
                }
                if (!bl2) {
                    n2 |= 0x2000000;
                }
                if (!bl3) {
                    n2 |= 0x4000000;
                }
                if (!bl4) {
                    n2 |= 0x10000000;
                }
                if (!bl5) {
                    n2 |= 0x8000000;
                }
            } else {
                throw new IllegalStateException("failed to enable protocols: " + Arrays.asList(stringArray));
            }
            SSL.setOptions((long)this.ssl, (int)n2);
            return;
        }
    }

    @Override
    public final SSLSession getSession() {
        return this.session;
    }

    @Override
    public final synchronized void beginHandshake() {
        switch (this.handshakeState) {
            case STARTED_IMPLICITLY: {
                this.checkEngineClosed(BEGIN_HANDSHAKE_ENGINE_CLOSED);
                this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY;
                return;
            }
            case STARTED_EXPLICITLY: {
                return;
            }
            case FINISHED: {
                if (this.clientMode) {
                    throw RENEGOTIATION_UNSUPPORTED;
                }
                if (SSL.renegotiate((long)this.ssl) != 1 || SSL.doHandshake((long)this.ssl) != 1) {
                    throw this.shutdownWithError("renegotiation failed");
                }
                SSL.setState((long)this.ssl, (int)8192);
                this.lastAccessed = System.currentTimeMillis();
            }
            case NOT_STARTED: {
                this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY;
                this.handshake();
                return;
            }
        }
        throw new Error();
    }

    private void checkEngineClosed(SSLException sSLException) {
        if (this.engineClosed || this.isDestroyed()) {
            throw sSLException;
        }
    }

    private static SSLEngineResult.HandshakeStatus pendingStatus(int n2) {
        if (n2 > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
    }

    private SSLEngineResult.HandshakeStatus handshake() {
        int n2;
        if (this.handshakeState == ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
            return SSLEngineResult.HandshakeStatus.FINISHED;
        }
        this.checkEngineClosed(HANDSHAKE_ENGINE_CLOSED);
        SSLHandshakeException sSLHandshakeException = this.handshakeException;
        if (sSLHandshakeException != null) {
            if (SSL.pendingWrittenBytesInBIO((long)this.networkBIO) > 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            this.handshakeException = null;
            this.shutdown();
            throw sSLHandshakeException;
        }
        this.engineMap.add(this);
        if (this.lastAccessed == -1L) {
            this.lastAccessed = System.currentTimeMillis();
        }
        if (!this.certificateSet && this.keyMaterialManager != null) {
            this.certificateSet = true;
            this.keyMaterialManager.setKeyMaterial(this);
        }
        if ((n2 = SSL.doHandshake((long)this.ssl)) <= 0) {
            if (this.handshakeException != null) {
                SSLHandshakeException sSLHandshakeException2 = this.handshakeException;
                this.handshakeException = null;
                this.shutdown();
                throw sSLHandshakeException2;
            }
            n2 = SSL.getError((long)this.ssl, (int)n2);
            switch (n2) {
                case 2: 
                case 3: {
                    return ReferenceCountedOpenSslEngine.pendingStatus(SSL.pendingWrittenBytesInBIO((long)this.networkBIO));
                }
            }
            throw this.shutdownWithError("SSL_do_handshake");
        }
        this.session.handshakeFinished();
        this.engineMap.remove(this.ssl);
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private SSLEngineResult.Status getEngineStatus() {
        if (this.engineClosed) {
            return SSLEngineResult.Status.CLOSED;
        }
        return SSLEngineResult.Status.OK;
    }

    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus) {
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
            return this.handshake();
        }
        return handshakeStatus;
    }

    @Override
    public final synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.needPendingStatus()) {
            return ReferenceCountedOpenSslEngine.pendingStatus(SSL.pendingWrittenBytesInBIO((long)this.networkBIO));
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private SSLEngineResult.HandshakeStatus getHandshakeStatus(int n2) {
        if (this.needPendingStatus()) {
            return ReferenceCountedOpenSslEngine.pendingStatus(n2);
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private boolean needPendingStatus() {
        return this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED && !this.isDestroyed() && (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED || this.engineClosed);
    }

    private String toJavaCipherSuite(String string) {
        if (string == null) {
            return null;
        }
        String string2 = ReferenceCountedOpenSslEngine.toJavaCipherSuitePrefix(SSL.getVersion((long)this.ssl));
        return CipherSuiteConverter.toJava(string, string2);
    }

    private static String toJavaCipherSuitePrefix(String string) {
        int n2 = string == null || string.length() == 0 ? 0 : (int)string.charAt(0);
        switch (n2) {
            case 84: {
                return "TLS";
            }
            case 83: {
                return "SSL";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public final void setUseClientMode(boolean bl) {
        if (bl != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getUseClientMode() {
        return this.clientMode;
    }

    @Override
    public final void setNeedClientAuth(boolean bl) {
        this.setClientAuth(bl ? ClientAuth.REQUIRE : ClientAuth.NONE);
    }

    @Override
    public final boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuth.REQUIRE;
    }

    @Override
    public final void setWantClientAuth(boolean bl) {
        this.setClientAuth(bl ? ClientAuth.OPTIONAL : ClientAuth.NONE);
    }

    @Override
    public final boolean getWantClientAuth() {
        return this.clientAuth == ClientAuth.OPTIONAL;
    }

    private void setClientAuth(ClientAuth clientAuth) {
        if (this.clientMode) {
            return;
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.clientAuth == clientAuth) {
                return;
            }
            switch (clientAuth) {
                case NONE: {
                    SSL.setVerify((long)this.ssl, (int)0, (int)10);
                    break;
                }
                case REQUIRE: {
                    SSL.setVerify((long)this.ssl, (int)2, (int)10);
                    break;
                }
                case OPTIONAL: {
                    SSL.setVerify((long)this.ssl, (int)1, (int)10);
                    break;
                }
                default: {
                    throw new Error(clientAuth.toString());
                }
            }
            this.clientAuth = clientAuth;
            return;
        }
    }

    @Override
    public final void setEnableSessionCreation(boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getEnableSessionCreation() {
        return false;
    }

    @Override
    public final synchronized SSLParameters getSSLParameters() {
        SSLParameters sSLParameters = super.getSSLParameters();
        int n2 = PlatformDependent.javaVersion();
        if (n2 >= 7) {
            sSLParameters.setEndpointIdentificationAlgorithm(this.endPointIdentificationAlgorithm);
            SslParametersUtils.setAlgorithmConstraints(sSLParameters, this.algorithmConstraints);
            if (n2 >= 8) {
                if (SET_SERVER_NAMES_METHOD != null && this.sniHostNames != null) {
                    try {
                        SET_SERVER_NAMES_METHOD.invoke((Object)sSLParameters, this.sniHostNames);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new Error(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new Error(invocationTargetException);
                    }
                }
                if (SET_USE_CIPHER_SUITES_ORDER_METHOD != null && !this.isDestroyed()) {
                    try {
                        SET_USE_CIPHER_SUITES_ORDER_METHOD.invoke((Object)sSLParameters, (SSL.getOptions((long)this.ssl) & 0x400000) != 0);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new Error(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new Error(invocationTargetException);
                    }
                }
            }
        }
        return sSLParameters;
    }

    @Override
    public final synchronized void setSSLParameters(SSLParameters sSLParameters) {
        super.setSSLParameters(sSLParameters);
        int n2 = PlatformDependent.javaVersion();
        if (n2 >= 7) {
            this.endPointIdentificationAlgorithm = sSLParameters.getEndpointIdentificationAlgorithm();
            this.algorithmConstraints = sSLParameters.getAlgorithmConstraints();
            if (n2 >= 8) {
                if (SNI_HOSTNAME_CLASS != null && this.clientMode && !this.isDestroyed()) {
                    assert (GET_SERVER_NAMES_METHOD != null);
                    assert (GET_ASCII_NAME_METHOD != null);
                    try {
                        List list = (List)GET_SERVER_NAMES_METHOD.invoke((Object)sSLParameters, new Object[0]);
                        if (list != null) {
                            for (Object e2 : list) {
                                if (SNI_HOSTNAME_CLASS.isInstance(e2)) {
                                    SSL.setTlsExtHostName((long)this.ssl, (String)((String)GET_ASCII_NAME_METHOD.invoke(e2, new Object[0])));
                                    continue;
                                }
                                throw new IllegalArgumentException("Only " + SNI_HOSTNAME_CLASS.getName() + " instances are supported, but found: " + e2);
                            }
                        }
                        this.sniHostNames = list;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new Error(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new Error(invocationTargetException);
                    }
                }
                if (GET_USE_CIPHER_SUITES_ORDER_METHOD != null && !this.isDestroyed()) {
                    try {
                        if (!((Boolean)GET_USE_CIPHER_SUITES_ORDER_METHOD.invoke((Object)sSLParameters, new Object[0])).booleanValue()) {
                            SSL.clearOptions((long)this.ssl, (int)0x400000);
                            return;
                        }
                        SSL.setOptions((long)this.ssl, (int)0x400000);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new Error(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new Error(invocationTargetException);
                    }
                }
            }
        }
    }

    private boolean isDestroyed() {
        return this.destroyed != 0;
    }

    static /* synthetic */ ResourceLeak access$000(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.leak;
    }

    static /* synthetic */ boolean access$100(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.isDestroyed();
    }

    static /* synthetic */ long access$200(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.ssl;
    }

    static /* synthetic */ long access$300(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.lastAccessed;
    }

    static /* synthetic */ String access$400(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String string) {
        return referenceCountedOpenSslEngine.toJavaCipherSuite(string);
    }

    static /* synthetic */ ReferenceCountedOpenSslEngine$HandshakeState access$502(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, ReferenceCountedOpenSslEngine$HandshakeState referenceCountedOpenSslEngine$HandshakeState) {
        referenceCountedOpenSslEngine.handshakeState = referenceCountedOpenSslEngine$HandshakeState;
        return referenceCountedOpenSslEngine.handshakeState;
    }

    static /* synthetic */ boolean access$600(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.clientMode;
    }

    static /* synthetic */ OpenSslApplicationProtocolNegotiator access$700(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.apn;
    }

    static /* synthetic */ Certificate[] access$800(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.localCerts;
    }

    static {
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslEngine.class);
        AtomicIntegerFieldUpdater<ReferenceCountedOpenSslEngine> atomicIntegerFieldUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(ReferenceCountedOpenSslEngine.class, "destroyed");
        if (atomicIntegerFieldUpdater == null) {
            atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(ReferenceCountedOpenSslEngine.class, "destroyed");
        }
        DESTROYED_UPDATER = atomicIntegerFieldUpdater;
        atomicIntegerFieldUpdater = null;
        Method method = null;
        Class<?> clazz = null;
        Method method2 = null;
        Object object = null;
        Method method3 = null;
        if (PlatformDependent.javaVersion() >= 8) {
            try {
                atomicIntegerFieldUpdater = SSLParameters.class.getDeclaredMethod("getUseCipherSuitesOrder", new Class[0]);
                object = new SSLParameters();
                Boolean cfr_ignored_0 = (Boolean)((Method)((Object)atomicIntegerFieldUpdater)).invoke(object, new Object[0]);
                method = SSLParameters.class.getDeclaredMethod("setUseCipherSuitesOrder", Boolean.TYPE);
                method.invoke(object, Boolean.TRUE);
            }
            catch (Throwable throwable) {
                atomicIntegerFieldUpdater = null;
                method = null;
            }
            try {
                clazz = Class.forName("javax.net.ssl.SNIHostName", false, PlatformDependent.getClassLoader(ReferenceCountedOpenSslEngine.class));
                object = clazz.getConstructor(String.class).newInstance("netty.io");
                method2 = clazz.getDeclaredMethod("getAsciiName", new Class[0]);
                String cfr_ignored_1 = (String)method2.invoke(object, new Object[0]);
                object = SSLParameters.class.getDeclaredMethod("getServerNames", new Class[0]);
                method3 = SSLParameters.class.getDeclaredMethod("setServerNames", List.class);
                SSLParameters sSLParameters = new SSLParameters();
                List cfr_ignored_2 = (List)((Method)object).invoke((Object)sSLParameters, new Object[0]);
                method3.invoke((Object)sSLParameters, Collections.emptyList());
            }
            catch (Throwable throwable) {
                clazz = null;
                method2 = null;
                object = null;
                method3 = null;
            }
        }
        GET_USE_CIPHER_SUITES_ORDER_METHOD = atomicIntegerFieldUpdater;
        SET_USE_CIPHER_SUITES_ORDER_METHOD = method;
        SNI_HOSTNAME_CLASS = clazz;
        GET_ASCII_NAME_METHOD = method2;
        GET_SERVER_NAMES_METHOD = object;
        SET_SERVER_NAMES_METHOD = method3;
        EMPTY_ADDR = Buffer.address((ByteBuffer)Unpooled.EMPTY_BUFFER.nioBuffer());
        NEED_UNWRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        NEED_UNWRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
        NEED_WRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        NEED_WRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
        CLOSED_NOT_HANDSHAKING = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
    }
}

