/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.ssl.NotSslRecordException;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SniHandler$Selection;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslUtils;
import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;
import com.aliyun.openservices.shade.io.netty.util.DomainNameMapping;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.IDN;
import java.util.List;
import java.util.Locale;

public class SniHandler
extends ByteToMessageDecoder {
    private static final int MAX_SSL_RECORDS = 4;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SniHandler.class);
    private static final SniHandler$Selection EMPTY_SELECTION = new SniHandler$Selection(null, null);
    private final DomainNameMapping<SslContext> mapping;
    private boolean handshakeFailed;
    private volatile SniHandler$Selection selection = EMPTY_SELECTION;

    public SniHandler(DomainNameMapping<? extends SslContext> domainNameMapping) {
        if (domainNameMapping == null) {
            throw new NullPointerException("mapping");
        }
        this.mapping = domainNameMapping;
    }

    public String hostname() {
        return this.selection.hostname;
    }

    public SslContext sslContext() {
        return this.selection.context;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void decode(ChannelHandlerContext var1_1, ByteBuf var2_2, List<Object> var3_3) {
        if (!this.handshakeFailed) {
            block21: {
                var3_4 = var2_2.writerIndex();
                try {
                    block9: for (var4_8 = 0; var4_8 < 4; ++var4_8) {
                        var5_10 = var2_2.readerIndex();
                        var6_11 = var3_4 - var5_10;
                        if (var6_11 < 5) {
                            return;
                        }
                        var7_12 = var2_2.getUnsignedByte(var5_10);
                        switch (var7_12) {
                            case 20: 
                            case 21: {
                                var6_11 = SslUtils.getEncryptedPacketLength(var2_2, var5_10);
                                if (var6_11 == -1) {
                                    this.handshakeFailed = true;
                                    var3_5 = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump(var2_2));
                                    v0 = var2_2;
                                    v0.skipBytes(v0.readableBytes());
                                    var1_1.fireExceptionCaught(var3_5);
                                    SslUtils.notifyHandshakeFailure(var1_1, var3_5);
                                    return;
                                }
                                if (var3_4 - var5_10 - 5 < var6_11) {
                                    return;
                                }
                                var2_2.skipBytes(var6_11);
                                continue block9;
                            }
                            case 22: {
                                v1 = var2_2.getUnsignedByte(var5_10 + 1);
                                var3_4 = v1;
                                if (v1 == 3) {
                                    var3_4 = var2_2.getUnsignedShort(var5_10 + 3) + 5;
                                    if (var6_11 < var3_4) {
                                        return;
                                    }
                                    var4_8 = var5_10 + 43;
                                    if ((var3_4 = var5_10 + var3_4) - var4_8 < 6) break block21;
                                    var5_10 = var2_2.getUnsignedByte(var4_8);
                                    var4_8 += var5_10 + 1;
                                    var5_10 = var2_2.getUnsignedShort(var4_8);
                                    var4_8 += var5_10 + 2;
                                    var5_10 = var2_2.getUnsignedByte(var4_8);
                                    var4_8 += var5_10 + 1;
                                    var5_10 = var2_2.getUnsignedShort(var4_8);
                                    ** if ((var5_10 = (var4_8 += 2) + var5_10) > var3_4) goto lbl65
                                    while (var5_10 - var4_8 >= 4) {
                                        var3_4 = var2_2.getUnsignedShort(var4_8);
                                        var4_8 += 2;
                                        if (var5_10 - (var4_8 += 2) < (var6_11 = var2_2.getUnsignedShort(var4_8))) break block21;
                                        if (var3_4 == 0) {
                                            if (var5_10 - (var4_8 += 2) >= 3) {
                                                var3_4 = var2_2.getUnsignedByte(var4_8);
                                                ++var4_8;
                                                if (var3_4 == 0 && var5_10 - (var4_8 += 2) >= (var3_4 = var2_2.getUnsignedShort(var4_8))) {
                                                    var3_6 = var2_2.toString(var4_8, var3_4, CharsetUtil.UTF_8);
                                                    try {
                                                        this.select(var1_1, IDN.toASCII(var3_6, 1).toLowerCase(Locale.US));
                                                        return;
                                                    }
                                                    catch (Throwable var3_7) {
                                                        var1_1.fireExceptionCaught(var3_7);
                                                        return;
                                                    }
                                                }
                                            }
                                            break block21;
                                        }
                                        var4_8 += var6_11;
lbl-1000:
                                        // 2 sources

                                        {
                                        }
                                    }
lbl65:
                                    // 2 sources

                                    break block21;
                                }
                            }
                            default: {
                                break block21;
                            }
                        }
                    }
                }
                catch (Throwable var4_9) {
                    if (!SniHandler.logger.isDebugEnabled()) break block21;
                    SniHandler.logger.debug("Unexpected client hello packet: " + ByteBufUtil.hexDump(var2_2), var4_9);
                }
            }
            this.select(var1_1, null);
        }
    }

    private void select(ChannelHandlerContext channelHandlerContext, String string) {
        SslHandler sslHandler = null;
        SslContext sslContext = this.mapping.map(string);
        this.selection = new SniHandler$Selection(sslContext, string);
        try {
            sslHandler = this.selection.context.newHandler(channelHandlerContext.alloc());
            channelHandlerContext.pipeline().replace(this, SslHandler.class.getName(), (ChannelHandler)sslHandler);
            return;
        }
        catch (Throwable throwable) {
            this.selection = EMPTY_SELECTION;
            if (sslHandler != null) {
                ReferenceCountUtil.safeRelease(sslHandler.engine());
            }
            channelHandlerContext.fireExceptionCaught(throwable);
            return;
        }
    }
}

