/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufInputStream;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ApplicationProtocolConfig$Protocol;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ApplicationProtocolConfig$SelectedListenerFailureBehavior;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ApplicationProtocolConfig$SelectorFailureBehavior;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ApplicationProtocolNegotiator;
import com.aliyun.openservices.shade.io.netty.handler.ssl.CipherSuiteFilter;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ClientAuth;
import com.aliyun.openservices.shade.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import com.aliyun.openservices.shade.io.netty.handler.ssl.JdkSslClientContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.JdkSslServerContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSsl;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslClientContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslServerContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.PemReader;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslServerContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslProvider;
import com.aliyun.openservices.shade.io.netty.util.internal.EmptyArrays;
import java.io.File;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManagerFactory;

public abstract class SslContext {
    static final CertificateFactory X509_CERT_FACTORY;
    private final boolean startTls;

    public static SslProvider defaultServerProvider() {
        return SslContext.defaultProvider();
    }

    public static SslProvider defaultClientProvider() {
        return SslContext.defaultProvider();
    }

    private static SslProvider defaultProvider() {
        if (OpenSsl.isAvailable()) {
            return SslProvider.OPENSSL;
        }
        return SslProvider.JDK;
    }

    @Deprecated
    public static SslContext newServerContext(File file, File file2) {
        return SslContext.newServerContext(file, file2, null);
    }

    @Deprecated
    public static SslContext newServerContext(File file, File file2, String string) {
        return SslContext.newServerContext(null, file, file2, string);
    }

    @Deprecated
    public static SslContext newServerContext(File file, File file2, String string, Iterable<String> iterable, Iterable<String> iterable2, long l2, long l3) {
        return SslContext.newServerContext(null, file, file2, string, iterable, iterable2, l2, l3);
    }

    @Deprecated
    public static SslContext newServerContext(File file, File file2, String string, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) {
        return SslContext.newServerContext(null, file, file2, string, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3);
    }

    @Deprecated
    public static SslContext newServerContext(SslProvider sslProvider, File file, File file2) {
        return SslContext.newServerContext(sslProvider, file, file2, null);
    }

    @Deprecated
    public static SslContext newServerContext(SslProvider sslProvider, File file, File file2, String string) {
        return SslContext.newServerContext(sslProvider, file, file2, string, null, IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
    }

    @Deprecated
    public static SslContext newServerContext(SslProvider sslProvider, File file, File file2, String string, Iterable<String> iterable, Iterable<String> iterable2, long l2, long l3) {
        return SslContext.newServerContext(sslProvider, file, file2, string, iterable, IdentityCipherSuiteFilter.INSTANCE, SslContext.toApplicationProtocolConfig(iterable2), l2, l3);
    }

    @Deprecated
    public static SslContext newServerContext(SslProvider sslProvider, File file, File file2, String string, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, Iterable<String> iterable2, long l2, long l3) {
        return SslContext.newServerContext(sslProvider, null, trustManagerFactory, file, file2, string, null, iterable, IdentityCipherSuiteFilter.INSTANCE, SslContext.toApplicationProtocolConfig(iterable2), l2, l3);
    }

    @Deprecated
    public static SslContext newServerContext(SslProvider sslProvider, File file, File file2, String string, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) {
        return SslContext.newServerContext(sslProvider, null, null, file, file2, string, null, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3);
    }

    @Deprecated
    public static SslContext newServerContext(SslProvider object, File file, TrustManagerFactory trustManagerFactory, File file2, File file3, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) {
        try {
            return SslContext.newServerContextInternal(object, SslContext.toX509Certificates(file), trustManagerFactory, SslContext.toX509Certificates(file2), SslContext.toPrivateKey(file3, string), string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, ClientAuth.NONE, false);
        }
        catch (Exception exception) {
            object = exception;
            if (exception instanceof SSLException) {
                throw (SSLException)object;
            }
            throw new SSLException("failed to initialize the server-side SSL context", (Throwable)object);
        }
    }

    static SslContext newServerContextInternal(SslProvider sslProvider, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3, ClientAuth clientAuth, boolean bl) {
        if (sslProvider == null) {
            sslProvider = SslContext.defaultServerProvider();
        }
        switch (sslProvider) {
            case JDK: {
                return new JdkSslServerContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, clientAuth, bl);
            }
            case OPENSSL: {
                return new OpenSslServerContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, clientAuth, bl);
            }
            case OPENSSL_REFCNT: {
                return new ReferenceCountedOpenSslServerContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3, clientAuth, bl);
            }
        }
        throw new Error(sslProvider.toString());
    }

    @Deprecated
    public static SslContext newClientContext() {
        return SslContext.newClientContext(null, null, null);
    }

    @Deprecated
    public static SslContext newClientContext(File file) {
        return SslContext.newClientContext(null, file);
    }

    @Deprecated
    public static SslContext newClientContext(TrustManagerFactory trustManagerFactory) {
        return SslContext.newClientContext(null, null, trustManagerFactory);
    }

    @Deprecated
    public static SslContext newClientContext(File file, TrustManagerFactory trustManagerFactory) {
        return SslContext.newClientContext(null, file, trustManagerFactory);
    }

    @Deprecated
    public static SslContext newClientContext(File file, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, Iterable<String> iterable2, long l2, long l3) {
        return SslContext.newClientContext(null, file, trustManagerFactory, iterable, iterable2, l2, l3);
    }

    @Deprecated
    public static SslContext newClientContext(File file, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) {
        return SslContext.newClientContext(null, file, trustManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3);
    }

    @Deprecated
    public static SslContext newClientContext(SslProvider sslProvider) {
        return SslContext.newClientContext(sslProvider, null, null);
    }

    @Deprecated
    public static SslContext newClientContext(SslProvider sslProvider, File file) {
        return SslContext.newClientContext(sslProvider, file, null);
    }

    @Deprecated
    public static SslContext newClientContext(SslProvider sslProvider, TrustManagerFactory trustManagerFactory) {
        return SslContext.newClientContext(sslProvider, null, trustManagerFactory);
    }

    @Deprecated
    public static SslContext newClientContext(SslProvider sslProvider, File file, TrustManagerFactory trustManagerFactory) {
        return SslContext.newClientContext(sslProvider, file, trustManagerFactory, null, IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
    }

    @Deprecated
    public static SslContext newClientContext(SslProvider sslProvider, File file, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, Iterable<String> iterable2, long l2, long l3) {
        return SslContext.newClientContext(sslProvider, file, trustManagerFactory, null, null, null, null, iterable, IdentityCipherSuiteFilter.INSTANCE, SslContext.toApplicationProtocolConfig(iterable2), l2, l3);
    }

    @Deprecated
    public static SslContext newClientContext(SslProvider sslProvider, File file, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) {
        return SslContext.newClientContext(sslProvider, file, trustManagerFactory, null, null, null, null, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3);
    }

    @Deprecated
    public static SslContext newClientContext(SslProvider object, File file, TrustManagerFactory trustManagerFactory, File file2, File file3, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) {
        try {
            return SslContext.newClientContextInternal(object, SslContext.toX509Certificates(file), trustManagerFactory, SslContext.toX509Certificates(file2), SslContext.toPrivateKey(file3, string), string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3);
        }
        catch (Exception exception) {
            object = exception;
            if (exception instanceof SSLException) {
                throw (SSLException)object;
            }
            throw new SSLException("failed to initialize the client-side SSL context", (Throwable)object);
        }
    }

    static SslContext newClientContextInternal(SslProvider sslProvider, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3) {
        if (sslProvider == null) {
            sslProvider = SslContext.defaultClientProvider();
        }
        switch (sslProvider) {
            case JDK: {
                return new JdkSslClientContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3);
            }
            case OPENSSL: {
                return new OpenSslClientContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3);
            }
            case OPENSSL_REFCNT: {
                return new ReferenceCountedOpenSslClientContext(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, applicationProtocolConfig, l2, l3);
            }
        }
        throw new Error(sslProvider.toString());
    }

    static ApplicationProtocolConfig toApplicationProtocolConfig(Iterable<String> object) {
        object = object == null ? ApplicationProtocolConfig.DISABLED : new ApplicationProtocolConfig(ApplicationProtocolConfig$Protocol.NPN_AND_ALPN, ApplicationProtocolConfig$SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL, ApplicationProtocolConfig$SelectedListenerFailureBehavior.ACCEPT, (Iterable<String>)object);
        return object;
    }

    protected SslContext() {
        this(false);
    }

    protected SslContext(boolean bl) {
        this.startTls = bl;
    }

    public final boolean isServer() {
        return !this.isClient();
    }

    public abstract boolean isClient();

    public abstract List<String> cipherSuites();

    public abstract long sessionCacheSize();

    public abstract long sessionTimeout();

    @Deprecated
    public final List<String> nextProtocols() {
        return this.applicationProtocolNegotiator().protocols();
    }

    public abstract ApplicationProtocolNegotiator applicationProtocolNegotiator();

    public abstract SSLEngine newEngine(ByteBufAllocator var1);

    public abstract SSLEngine newEngine(ByteBufAllocator var1, String var2, int var3);

    public abstract SSLSessionContext sessionContext();

    public final SslHandler newHandler(ByteBufAllocator byteBufAllocator) {
        return new SslHandler(this.newEngine(byteBufAllocator), this.startTls);
    }

    public final SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n2) {
        return new SslHandler(this.newEngine(byteBufAllocator, string, n2), this.startTls);
    }

    protected static PKCS8EncodedKeySpec generateKeySpec(char[] object, byte[] object2) {
        if (object == null) {
            return new PKCS8EncodedKeySpec((byte[])object2);
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo((byte[])object2);
        object2 = encryptedPrivateKeyInfo;
        Object object3 = SecretKeyFactory.getInstance(encryptedPrivateKeyInfo.getAlgName());
        object = new PBEKeySpec((char[])object);
        object = ((SecretKeyFactory)object3).generateSecret((KeySpec)object);
        object3 = Cipher.getInstance(((EncryptedPrivateKeyInfo)object2).getAlgName());
        ((Cipher)object3).init(2, (Key)object, ((EncryptedPrivateKeyInfo)object2).getAlgParameters());
        return ((EncryptedPrivateKeyInfo)object2).getKeySpec((Cipher)object3);
    }

    static KeyStore buildKeyStore(X509Certificate[] x509CertificateArray, PrivateKey privateKey, char[] cArray) {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        keyStore.setKeyEntry("key", privateKey, cArray, x509CertificateArray);
        return keyStore;
    }

    static PrivateKey toPrivateKey(File file, String string) {
        if (file == null) {
            return null;
        }
        return SslContext.getPrivateKeyFromByteBuffer(PemReader.readPrivateKey(file), string);
    }

    static PrivateKey toPrivateKey(InputStream inputStream, String string) {
        if (inputStream == null) {
            return null;
        }
        return SslContext.getPrivateKeyFromByteBuffer(PemReader.readPrivateKey(inputStream), string);
    }

    private static PrivateKey getPrivateKeyFromByteBuffer(ByteBuf object, String string) {
        byte[] byArray = new byte[((ByteBuf)object).readableBytes()];
        ((ByteBuf)object).readBytes(byArray).release();
        object = SslContext.generateKeySpec(string == null ? null : string.toCharArray(), byArray);
        try {
            return KeyFactory.getInstance("RSA").generatePrivate((KeySpec)object);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            try {
                return KeyFactory.getInstance("DSA").generatePrivate((KeySpec)object);
            }
            catch (InvalidKeySpecException invalidKeySpecException2) {
                try {
                    return KeyFactory.getInstance("EC").generatePrivate((KeySpec)object);
                }
                catch (InvalidKeySpecException invalidKeySpecException3) {
                    throw new InvalidKeySpecException("Neither RSA, DSA nor EC worked", invalidKeySpecException3);
                }
            }
        }
    }

    @Deprecated
    protected static TrustManagerFactory buildTrustManagerFactory(File x509CertificateArray, TrustManagerFactory trustManagerFactory) {
        x509CertificateArray = SslContext.toX509Certificates((File)x509CertificateArray);
        return SslContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory);
    }

    static X509Certificate[] toX509Certificates(File file) {
        if (file == null) {
            return null;
        }
        return SslContext.getCertificatesFromBuffers(PemReader.readCertificates(file));
    }

    static X509Certificate[] toX509Certificates(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        return SslContext.getCertificatesFromBuffers(PemReader.readCertificates(inputStream));
    }

    private static X509Certificate[] getCertificatesFromBuffers(ByteBuf[] byteBufArray) {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate[] x509CertificateArray = new X509Certificate[byteBufArray.length];
        try {
            for (int i2 = 0; i2 < byteBufArray.length; ++i2) {
                x509CertificateArray[i2] = (X509Certificate)certificateFactory.generateCertificate(new ByteBufInputStream(byteBufArray[i2]));
            }
        }
        finally {
            ByteBuf[] byteBufArray2 = byteBufArray;
            int n2 = byteBufArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                ByteBuf byteBuf = byteBufArray2[i3];
                byteBuf.release();
            }
        }
        return x509CertificateArray;
    }

    static TrustManagerFactory buildTrustManagerFactory(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory) {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        int n2 = 1;
        for (X509Certificate x509Certificate : x509CertificateArray) {
            String string = Integer.toString(n2);
            keyStore.setCertificateEntry(string, x509Certificate);
            ++n2;
        }
        if (trustManagerFactory == null) {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        trustManagerFactory.init(keyStore);
        return trustManagerFactory;
    }

    static PrivateKey toPrivateKeyInternal(File file, String string) {
        try {
            return SslContext.toPrivateKey(file, string);
        }
        catch (Exception exception) {
            throw new SSLException(exception);
        }
    }

    static X509Certificate[] toX509CertificatesInternal(File file) {
        try {
            return SslContext.toX509Certificates(file);
        }
        catch (CertificateException certificateException) {
            throw new SSLException(certificateException);
        }
    }

    static KeyManagerFactory buildKeyManagerFactory(X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory) {
        String string2 = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (string2 == null) {
            string2 = "SunX509";
        }
        return SslContext.buildKeyManagerFactory(x509CertificateArray, string2, privateKey, string, keyManagerFactory);
    }

    static KeyManagerFactory buildKeyManagerFactory(X509Certificate[] object, String string, PrivateKey privateKey, String object2, KeyManagerFactory keyManagerFactory) {
        object2 = object2 == null ? EmptyArrays.EMPTY_CHARS : ((String)object2).toCharArray();
        object = SslContext.buildKeyStore(object, privateKey, (char[])object2);
        if (keyManagerFactory == null) {
            keyManagerFactory = KeyManagerFactory.getInstance(string);
        }
        keyManagerFactory.init((KeyStore)object, (char[])object2);
        return keyManagerFactory;
    }

    static KeyManagerFactory buildDefaultKeyManagerFactory() {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(null, null);
        return keyManagerFactory;
    }

    static {
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
            return;
        }
        catch (CertificateException certificateException) {
            throw new IllegalStateException("unable to instance X.509 CertificateFactory", certificateException);
        }
    }
}

