/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromiseNotifier;
import com.aliyun.openservices.shade.io.netty.channel.PendingWriteQueue;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.UnsupportedMessageTypeException;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ApplicationProtocolAccessor;
import com.aliyun.openservices.shade.io.netty.handler.ssl.NotSslRecordException;
import com.aliyun.openservices.shade.io.netty.handler.ssl.OpenSslEngine;
import com.aliyun.openservices.shade.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler$1;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler$2;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler$3;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler$4;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler$5;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler$6;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler$7;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler$8;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandler$LazyChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslUtils;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCounted;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Future;
import com.aliyun.openservices.shade.io.netty.util.concurrent.ImmediateExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Promise;
import com.aliyun.openservices.shade.io.netty.util.concurrent.ScheduledFuture;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SslHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp|Udt)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static final SSLException SSLENGINE_CLOSED = ThrowableUtil.unknownStackTrace(new SSLException("SSLEngine closed already"), SslHandler.class, "wrap(...)");
    private static final SSLException HANDSHAKE_TIMED_OUT = ThrowableUtil.unknownStackTrace(new SSLException("handshake timed out"), SslHandler.class, "handshake(...)");
    private static final ClosedChannelException CHANNEL_CLOSED = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), SslHandler.class, "channelInactive(...)");
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final int maxPacketBufferSize;
    private final Executor delegatedTaskExecutor;
    private final ByteBuffer[] singleBuffer = new ByteBuffer[1];
    private final boolean wantsDirectBuffer;
    private final boolean wantsLargeOutboundNetworkBuffer;
    private final boolean startTls;
    private boolean sentFirstMessage;
    private boolean flushedBeforeHandshake;
    private boolean readDuringHandshake;
    private PendingWriteQueue pendingUnencryptedWrites;
    private Promise<Channel> handshakePromise = new SslHandler$LazyChannelPromise(this, null);
    private final SslHandler$LazyChannelPromise sslCloseFuture = new SslHandler$LazyChannelPromise(this, null);
    private boolean needsFlush;
    private boolean outboundClosed;
    private int packetLength;
    private boolean firedChannelRead;
    private volatile long handshakeTimeoutMillis = 10000L;
    private volatile long closeNotifyTimeoutMillis = 3000L;

    public SslHandler(SSLEngine sSLEngine) {
        this(sSLEngine, false);
    }

    public SslHandler(SSLEngine sSLEngine, boolean bl) {
        this(sSLEngine, bl, ImmediateExecutor.INSTANCE);
    }

    @Deprecated
    public SslHandler(SSLEngine sSLEngine, Executor executor) {
        this(sSLEngine, false, executor);
    }

    @Deprecated
    public SslHandler(SSLEngine sSLEngine, boolean bl, Executor executor) {
        boolean bl2;
        if (sSLEngine == null) {
            throw new NullPointerException("engine");
        }
        if (executor == null) {
            throw new NullPointerException("delegatedTaskExecutor");
        }
        this.engine = sSLEngine;
        this.delegatedTaskExecutor = executor;
        this.startTls = bl;
        this.maxPacketBufferSize = sSLEngine.getSession().getPacketBufferSize();
        this.wantsDirectBuffer = bl2 = sSLEngine instanceof OpenSslEngine;
        this.wantsLargeOutboundNetworkBuffer = !bl2;
        this.setCumulator(bl2 ? COMPOSITE_CUMULATOR : MERGE_CUMULATOR);
    }

    public long getHandshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public void setHandshakeTimeout(long l2, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        this.setHandshakeTimeoutMillis(timeUnit.toMillis(l2));
    }

    public void setHandshakeTimeoutMillis(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("handshakeTimeoutMillis: " + l2 + " (expected: >= 0)");
        }
        this.handshakeTimeoutMillis = l2;
    }

    public long getCloseNotifyTimeoutMillis() {
        return this.closeNotifyTimeoutMillis;
    }

    public void setCloseNotifyTimeout(long l2, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        this.setCloseNotifyTimeoutMillis(timeUnit.toMillis(l2));
    }

    public void setCloseNotifyTimeoutMillis(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("closeNotifyTimeoutMillis: " + l2 + " (expected: >= 0)");
        }
        this.closeNotifyTimeoutMillis = l2;
    }

    public SSLEngine engine() {
        return this.engine;
    }

    public String applicationProtocol() {
        SSLSession sSLSession = this.engine().getSession();
        if (!(sSLSession instanceof ApplicationProtocolAccessor)) {
            return null;
        }
        return ((ApplicationProtocolAccessor)((Object)sSLSession)).getApplicationProtocol();
    }

    public Future<Channel> handshakeFuture() {
        return this.handshakePromise;
    }

    public ChannelFuture close() {
        SslHandler sslHandler = this;
        return sslHandler.close(sslHandler.ctx.newPromise());
    }

    public ChannelFuture close(ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        channelHandlerContext.executor().execute(new SslHandler$1(this, channelHandlerContext, channelPromise));
        return channelPromise;
    }

    public Future<Channel> sslCloseFuture() {
        return this.sslCloseFuture;
    }

    @Override
    public void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        if (!this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.removeAndFailAll(new ChannelException("Pending write on removal of SslHandler"));
        }
        if (this.engine instanceof ReferenceCountedOpenSslEngine) {
            ((ReferenceCountedOpenSslEngine)this.engine).release();
        }
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channelHandlerContext.bind(socketAddress, channelPromise);
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channelHandlerContext.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        channelHandlerContext.deregister(channelPromise);
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.closeOutboundAndChannel(channelHandlerContext, channelPromise, true);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.closeOutboundAndChannel(channelHandlerContext, channelPromise, false);
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        if (!this.handshakePromise.isDone()) {
            this.readDuringHandshake = true;
        }
        channelHandlerContext.read();
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (!(object instanceof ByteBuf)) {
            channelPromise.setFailure(new UnsupportedMessageTypeException(object, ByteBuf.class));
            return;
        }
        this.pendingUnencryptedWrites.add(object, channelPromise);
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        if (this.startTls && !this.sentFirstMessage) {
            this.sentFirstMessage = true;
            this.pendingUnencryptedWrites.removeAndWriteAll();
            channelHandlerContext.flush();
            return;
        }
        if (this.pendingUnencryptedWrites.isEmpty()) {
            this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, channelHandlerContext.newPromise());
        }
        if (!this.handshakePromise.isDone()) {
            this.flushedBeforeHandshake = true;
        }
        try {
            this.wrap(channelHandlerContext, false);
            return;
        }
        catch (Throwable throwable) {
            this.pendingUnencryptedWrites.removeAndFailAll(throwable);
            PlatformDependent.throwException(throwable);
            return;
        }
        finally {
            channelHandlerContext.flush();
        }
    }

    private void wrap(ChannelHandlerContext channelHandlerContext, boolean bl) {
        ChannelPromise channelPromise;
        ByteBuf byteBuf;
        block15: {
            SSLEngineResult sSLEngineResult;
            byteBuf = null;
            channelPromise = null;
            ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
            block13: while (true) {
                Object object;
                block16: {
                    if (channelHandlerContext.isRemoved() || (object = this.pendingUnencryptedWrites.current()) == null) break block15;
                    object = (ByteBuf)object;
                    if (byteBuf == null) {
                        byteBuf = this.allocateOutNetBuf(channelHandlerContext, ((ByteBuf)object).readableBytes());
                    }
                    if ((sSLEngineResult = this.wrap(byteBufAllocator, this.engine, (ByteBuf)object, byteBuf)).getStatus() != SSLEngineResult.Status.CLOSED) break block16;
                    this.pendingUnencryptedWrites.removeAndFailAll(SSLENGINE_CLOSED);
                    this.finishWrap(channelHandlerContext, byteBuf, channelPromise, bl, false);
                    return;
                }
                channelPromise = !((ByteBuf)object).isReadable() ? this.pendingUnencryptedWrites.remove() : null;
                switch (sSLEngineResult.getHandshakeStatus()) {
                    case NEED_TASK: {
                        this.runDelegatedTasks();
                        continue block13;
                    }
                    case FINISHED: {
                        this.setHandshakeSuccess();
                    }
                    case NOT_HANDSHAKING: {
                        this.setHandshakeSuccessIfStillHandshaking();
                    }
                    case NEED_WRAP: {
                        this.finishWrap(channelHandlerContext, byteBuf, channelPromise, bl, false);
                        channelPromise = null;
                        byteBuf = null;
                        continue block13;
                    }
                    case NEED_UNWRAP: {
                        this.finishWrap(channelHandlerContext, byteBuf, channelPromise, bl, true);
                        return;
                    }
                }
                break;
            }
            try {
                throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)sSLEngineResult.getHandshakeStatus()));
            }
            catch (SSLException sSLException) {
                try {
                    this.setHandshakeFailure(channelHandlerContext, sSLException);
                    throw sSLException;
                }
                catch (Throwable throwable) {
                    this.finishWrap(channelHandlerContext, byteBuf, channelPromise, bl, false);
                    throw throwable;
                }
            }
        }
        this.finishWrap(channelHandlerContext, byteBuf, channelPromise, bl, false);
        return;
    }

    private void finishWrap(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ChannelPromise channelPromise, boolean bl, boolean bl2) {
        if (byteBuf == null) {
            byteBuf = Unpooled.EMPTY_BUFFER;
        } else if (!byteBuf.isReadable()) {
            byteBuf.release();
            byteBuf = Unpooled.EMPTY_BUFFER;
        }
        if (channelPromise != null) {
            channelHandlerContext.write(byteBuf, channelPromise);
        } else {
            channelHandlerContext.write(byteBuf);
        }
        if (bl) {
            this.needsFlush = true;
        }
        if (bl2) {
            this.readIfNeeded(channelHandlerContext);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void wrapNonAppData(ChannelHandlerContext channelHandlerContext, boolean bl) {
        ReferenceCounted referenceCounted = null;
        ByteBufAllocator byteBufAllocator = channelHandlerContext.alloc();
        try {
            while (!channelHandlerContext.isRemoved()) {
                SSLEngineResult sSLEngineResult;
                if (referenceCounted == null) {
                    referenceCounted = this.allocateOutNetBuf(channelHandlerContext, 0);
                }
                if ((sSLEngineResult = this.wrap(byteBufAllocator, this.engine, Unpooled.EMPTY_BUFFER, (ByteBuf)referenceCounted)).bytesProduced() > 0) {
                    channelHandlerContext.write(referenceCounted);
                    if (bl) {
                        this.needsFlush = true;
                    }
                    referenceCounted = null;
                }
                switch (sSLEngineResult.getHandshakeStatus()) {
                    case FINISHED: {
                        this.setHandshakeSuccess();
                        break;
                    }
                    case NEED_TASK: {
                        this.runDelegatedTasks();
                        break;
                    }
                    case NEED_UNWRAP: {
                        if (bl) break;
                        this.unwrapNonAppData(channelHandlerContext);
                        break;
                    }
                    case NEED_WRAP: {
                        break;
                    }
                    case NOT_HANDSHAKING: {
                        this.setHandshakeSuccessIfStillHandshaking();
                        if (bl) break;
                        this.unwrapNonAppData(channelHandlerContext);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)sSLEngineResult.getHandshakeStatus()));
                    }
                }
                if (sSLEngineResult.bytesProduced() != 0 && (sSLEngineResult.bytesConsumed() != 0 || sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)) continue;
            }
            if (referenceCounted == null) return;
        }
        catch (SSLException sSLException) {
            try {
                this.setHandshakeFailure(channelHandlerContext, sSLException);
                this.flushIfNeeded(channelHandlerContext);
                throw sSLException;
            }
            catch (Throwable throwable) {
                if (referenceCounted == null) throw throwable;
                referenceCounted.release();
                throw throwable;
            }
        }
        referenceCounted.release();
        return;
    }

    private SSLEngineResult wrap(ByteBufAllocator object, SSLEngine sSLEngine, ByteBuf byteBuf, ByteBuf byteBuf2) {
        ReferenceCounted referenceCounted = null;
        try {
            Object object2;
            int n2 = byteBuf.readerIndex();
            int n3 = byteBuf.readableBytes();
            if (byteBuf.isDirect() || !this.wantsDirectBuffer) {
                if (!(byteBuf instanceof CompositeByteBuf) && byteBuf.nioBufferCount() == 1) {
                    object = this.singleBuffer;
                    this.singleBuffer[0] = byteBuf.internalNioBuffer(n2, n3);
                } else {
                    object = byteBuf.nioBuffers();
                }
            } else {
                referenceCounted = object.directBuffer(n3);
                ((ByteBuf)referenceCounted).writeBytes(byteBuf, n2, n3);
                object = this.singleBuffer;
                this.singleBuffer[0] = ((ByteBuf)referenceCounted).internalNioBuffer(0, n3);
            }
            block6: while (true) {
                ByteBuf byteBuf3 = byteBuf2;
                object2 = byteBuf3.nioBuffer(byteBuf3.writerIndex(), byteBuf2.writableBytes());
                object2 = sSLEngine.wrap((ByteBuffer[])object, (ByteBuffer)object2);
                byteBuf.skipBytes(((SSLEngineResult)object2).bytesConsumed());
                ByteBuf byteBuf4 = byteBuf2;
                byteBuf4.writerIndex(byteBuf4.writerIndex() + ((SSLEngineResult)object2).bytesProduced());
                switch (((SSLEngineResult)object2).getStatus()) {
                    case BUFFER_OVERFLOW: {
                        byteBuf2.ensureWritable(this.maxPacketBufferSize);
                        continue block6;
                    }
                }
                break;
            }
            object = object2;
            return object;
        }
        finally {
            this.singleBuffer[0] = null;
            if (referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.setHandshakeFailure(channelHandlerContext, CHANNEL_CLOSED, !this.outboundClosed);
        super.channelInactive(channelHandlerContext);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (this.ignoreException(throwable)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} Swallowing a harmless 'connection reset by peer / broken pipe' error that occurred while writing close_notify in response to the peer's close_notify", (Object)channelHandlerContext.channel(), (Object)throwable);
            }
            if (channelHandlerContext.channel().isActive()) {
                channelHandlerContext.close();
                return;
            }
        } else {
            channelHandlerContext.fireExceptionCaught(throwable);
        }
    }

    private boolean ignoreException(Throwable stackTraceElementArray) {
        if (!(stackTraceElementArray instanceof SSLException) && stackTraceElementArray instanceof IOException && this.sslCloseFuture.isDone()) {
            String string = String.valueOf(stackTraceElementArray.getMessage()).toLowerCase();
            if (IGNORABLE_ERROR_MESSAGE.matcher(string).matches()) {
                return true;
            }
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray.getStackTrace();
            stackTraceElementArray = stackTraceElementArray2;
            stackTraceElementArray = stackTraceElementArray2;
            int n2 = stackTraceElementArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class<?> clazz = stackTraceElementArray[i2];
                String string2 = ((StackTraceElement)((Object)clazz)).getClassName();
                clazz = ((StackTraceElement)((Object)clazz)).getMethodName();
                if (string2.startsWith("com.aliyun.openservices.shade.io.netty.") || !"read".equals(clazz)) continue;
                if (IGNORABLE_CLASS_IN_STACK.matcher(string2).matches()) {
                    return true;
                }
                try {
                    clazz = PlatformDependent.getClassLoader(this.getClass()).loadClass(string2);
                    if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                        return true;
                    }
                    if (PlatformDependent.javaVersion() >= 7 && "com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) {
                        return true;
                    }
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        return false;
    }

    public static boolean isEncrypted(ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < 5) {
            throw new IllegalArgumentException("buffer must have at least 5 readable bytes");
        }
        ByteBuf byteBuf2 = byteBuf;
        return SslUtils.getEncryptedPacketLength(byteBuf2, byteBuf2.readerIndex()) != -1;
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        int n2;
        int n3 = byteBuf.readerIndex();
        int n4 = byteBuf.writerIndex();
        int n5 = n3;
        int n6 = 0;
        if (this.packetLength > 0) {
            if (n4 - n3 < this.packetLength) {
                return;
            }
            n5 = n3 + this.packetLength;
            n6 = this.packetLength;
            this.packetLength = 0;
        }
        boolean bl = false;
        while (n6 < 18713 && (n2 = n4 - n5) >= 5) {
            int n7 = SslUtils.getEncryptedPacketLength(byteBuf, n5);
            if (n7 == -1) {
                bl = true;
                break;
            }
            assert (n7 > 0);
            if (n7 > n2) {
                this.packetLength = n7;
                break;
            }
            n2 = n6 + n7;
            if (n2 > 18713) break;
            n5 += n7;
            n6 = n2;
        }
        if (n6 > 0) {
            byteBuf.skipBytes(n6);
            boolean bl2 = this.firedChannelRead = this.unwrap(channelHandlerContext, byteBuf, n3, n6) || this.firedChannelRead;
        }
        if (bl) {
            NotSslRecordException notSslRecordException = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump(byteBuf));
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.skipBytes(byteBuf2.readableBytes());
            this.setHandshakeFailure(channelHandlerContext, notSslRecordException);
            channelHandlerContext.fireExceptionCaught(notSslRecordException);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.discardSomeReadBytes();
        this.flushIfNeeded(channelHandlerContext);
        this.readIfNeeded(channelHandlerContext);
        this.firedChannelRead = false;
        channelHandlerContext.fireChannelReadComplete();
    }

    private void readIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (!(channelHandlerContext.channel().config().isAutoRead() || this.firedChannelRead && this.handshakePromise.isDone())) {
            channelHandlerContext.read();
        }
    }

    private void flushIfNeeded(ChannelHandlerContext channelHandlerContext) {
        if (this.needsFlush) {
            this.needsFlush = false;
            channelHandlerContext.flush();
        }
    }

    private void unwrapNonAppData(ChannelHandlerContext channelHandlerContext) {
        this.unwrap(channelHandlerContext, Unpooled.EMPTY_BUFFER, 0, 0);
    }

    private boolean unwrap(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n2, int n3) {
        boolean bl;
        block24: {
            ByteBuf byteBuf2;
            block23: {
                bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                byteBuf2 = this.allocate(channelHandlerContext, n3);
                try {
                    block15: while (!channelHandlerContext.isRemoved()) {
                        SslHandler sslHandler = this;
                        SSLEngineResult sSLEngineResult = sslHandler.unwrap(sslHandler.engine, byteBuf, n2, n3, byteBuf2);
                        SSLEngineResult.Status status = sSLEngineResult.getStatus();
                        SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult.getHandshakeStatus();
                        int n4 = sSLEngineResult.bytesProduced();
                        int n5 = sSLEngineResult.bytesConsumed();
                        n2 += n5;
                        n3 -= n5;
                        switch (status) {
                            case BUFFER_OVERFLOW: {
                                n5 = byteBuf2.readableBytes();
                                int n6 = this.engine.getSession().getApplicationBufferSize() - n5;
                                if (n5 > 0) {
                                    bl = true;
                                    channelHandlerContext.fireChannelRead(byteBuf2);
                                } else {
                                    byteBuf2.release();
                                }
                                byteBuf2 = this.allocate(channelHandlerContext, n6);
                                continue block15;
                            }
                            case CLOSED: {
                                bl3 = true;
                            }
                        }
                        switch (handshakeStatus) {
                            case NEED_UNWRAP: {
                                break;
                            }
                            case NEED_WRAP: {
                                this.wrapNonAppData(channelHandlerContext, true);
                                break;
                            }
                            case NEED_TASK: {
                                this.runDelegatedTasks();
                                break;
                            }
                            case FINISHED: {
                                this.setHandshakeSuccess();
                                bl2 = true;
                                break;
                            }
                            case NOT_HANDSHAKING: {
                                if (this.setHandshakeSuccessIfStillHandshaking()) {
                                    bl2 = true;
                                    continue block15;
                                }
                                if (!this.flushedBeforeHandshake) break;
                                this.flushedBeforeHandshake = false;
                                bl2 = true;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("unknown handshake status: " + (Object)((Object)handshakeStatus));
                            }
                        }
                        if (status != SSLEngineResult.Status.BUFFER_UNDERFLOW && (n5 != 0 || n4 != 0)) continue;
                        if (handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                        this.readIfNeeded(channelHandlerContext);
                        break;
                    }
                    if (bl2) {
                        this.wrap(channelHandlerContext, true);
                    }
                    if (bl3) {
                        this.sslCloseFuture.trySuccess(channelHandlerContext.channel());
                    }
                    if (!byteBuf2.isReadable()) break block23;
                    bl = true;
                    channelHandlerContext.fireChannelRead(byteBuf2);
                }
                catch (SSLException sSLException) {
                    try {
                        this.setHandshakeFailure(channelHandlerContext, sSLException);
                        throw sSLException;
                    }
                    catch (Throwable throwable) {
                        if (byteBuf2.isReadable()) {
                            channelHandlerContext.fireChannelRead(byteBuf2);
                        } else {
                            byteBuf2.release();
                        }
                        throw throwable;
                    }
                }
                break block24;
            }
            byteBuf2.release();
        }
        return bl;
    }

    private SSLEngineResult unwrap(SSLEngine object, ByteBuf byteBuf, int n2, int n3, ByteBuf byteBuf2) {
        int n4 = byteBuf.nioBufferCount();
        int n5 = byteBuf2.writerIndex();
        if (object instanceof OpenSslEngine && n4 > 1) {
            object = (OpenSslEngine)object;
            try {
                this.singleBuffer[0] = SslHandler.toByteBuffer(byteBuf2, n5, byteBuf2.writableBytes());
                object = ((ReferenceCountedOpenSslEngine)object).unwrap(byteBuf.nioBuffers(n2, n3), this.singleBuffer);
                byteBuf2.writerIndex(n5 + ((SSLEngineResult)object).bytesProduced());
            }
            finally {
                this.singleBuffer[0] = null;
            }
        } else {
            object = ((SSLEngine)object).unwrap(SslHandler.toByteBuffer(byteBuf, n2, n3), SslHandler.toByteBuffer(byteBuf2, n5, byteBuf2.writableBytes()));
        }
        byteBuf2.writerIndex(n5 + ((SSLEngineResult)object).bytesProduced());
        return object;
    }

    private static ByteBuffer toByteBuffer(ByteBuf byteBuf, int n2, int n3) {
        if (byteBuf.nioBufferCount() == 1) {
            return byteBuf.internalNioBuffer(n2, n3);
        }
        return byteBuf.nioBuffer(n2, n3);
    }

    private void runDelegatedTasks() {
        if (this.delegatedTaskExecutor == ImmediateExecutor.INSTANCE) {
            Runnable runnable;
            while ((runnable = this.engine.getDelegatedTask()) != null) {
                runnable.run();
            }
        } else {
            Object object;
            ArrayList<Runnable> arrayList = new ArrayList<Runnable>(2);
            while ((object = this.engine.getDelegatedTask()) != null) {
                arrayList.add((Runnable)object);
            }
            if (arrayList.isEmpty()) {
                return;
            }
            object = new CountDownLatch(1);
            this.delegatedTaskExecutor.execute(new SslHandler$2(this, arrayList, (CountDownLatch)object));
            boolean bl = false;
            while (((CountDownLatch)object).getCount() != 0L) {
                try {
                    ((CountDownLatch)object).await();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean setHandshakeSuccessIfStillHandshaking() {
        if (!this.handshakePromise.isDone()) {
            this.setHandshakeSuccess();
            return true;
        }
        return false;
    }

    private void setHandshakeSuccess() {
        this.handshakePromise.trySuccess(this.ctx.channel());
        if (logger.isDebugEnabled()) {
            logger.debug("{} HANDSHAKEN: {}", (Object)this.ctx.channel(), (Object)this.engine.getSession().getCipherSuite());
        }
        this.ctx.fireUserEventTriggered(SslHandshakeCompletionEvent.SUCCESS);
        if (this.readDuringHandshake && !this.ctx.channel().config().isAutoRead()) {
            this.readDuringHandshake = false;
            this.ctx.read();
        }
    }

    private void setHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        this.setHandshakeFailure(channelHandlerContext, throwable, true);
    }

    private void setHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl) {
        block3: {
            this.engine.closeOutbound();
            if (bl) {
                try {
                    this.engine.closeInbound();
                }
                catch (SSLException sSLException) {
                    SSLException sSLException2 = sSLException;
                    String string = sSLException.getMessage();
                    if (string != null && string.contains("possible truncation attack")) break block3;
                    logger.debug("{} SSLEngine.closeInbound() raised an exception.", (Object)channelHandlerContext.channel(), (Object)sSLException2);
                }
            }
        }
        this.notifyHandshakeFailure(throwable);
        this.pendingUnencryptedWrites.removeAndFailAll(throwable);
    }

    private void notifyHandshakeFailure(Throwable throwable) {
        if (this.handshakePromise.tryFailure(throwable)) {
            SslUtils.notifyHandshakeFailure(this.ctx, throwable);
        }
    }

    private void closeOutboundAndChannel(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise, boolean bl) {
        if (!channelHandlerContext.channel().isActive()) {
            if (bl) {
                channelHandlerContext.disconnect(channelPromise);
                return;
            }
            channelHandlerContext.close(channelPromise);
            return;
        }
        this.outboundClosed = true;
        this.engine.closeOutbound();
        ChannelPromise channelPromise2 = channelHandlerContext.newPromise();
        try {
            this.flush(channelHandlerContext, channelPromise2);
            return;
        }
        finally {
            this.safeClose(channelHandlerContext, channelPromise2, channelPromise);
        }
    }

    private void flush(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        this.pendingUnencryptedWrites.add(Unpooled.EMPTY_BUFFER, channelPromise);
        this.flush(channelHandlerContext);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        this.pendingUnencryptedWrites = new PendingWriteQueue(channelHandlerContext);
        if (channelHandlerContext.channel().isActive() && this.engine.getUseClientMode()) {
            this.handshake(null);
        }
    }

    public Future<Channel> renegotiate() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException();
        }
        return this.renegotiate(channelHandlerContext.executor().newPromise());
    }

    public Future<Channel> renegotiate(Promise<Channel> promise) {
        if (promise == null) {
            throw new NullPointerException("promise");
        }
        Object object = this.ctx;
        if (object == null) {
            throw new IllegalStateException();
        }
        if (!(object = object.executor()).inEventLoop()) {
            object.execute(new SslHandler$3(this, promise));
            return promise;
        }
        this.handshake(promise);
        return promise;
    }

    private void handshake(Promise<Channel> promise) {
        Future<Object> future;
        if (promise != null) {
            future = this.handshakePromise;
            if (!future.isDone()) {
                future.addListener(new SslHandler$4(this, promise));
                return;
            }
            this.handshakePromise = promise;
        } else {
            if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                return;
            }
            promise = this.handshakePromise;
            assert (!promise.isDone());
        }
        future = this.ctx;
        try {
            this.engine.beginHandshake();
            this.wrapNonAppData((ChannelHandlerContext)((Object)future), false);
            future.flush();
        }
        catch (Exception exception) {
            this.notifyHandshakeFailure(exception);
        }
        long l2 = this.handshakeTimeoutMillis;
        if (l2 <= 0L || promise.isDone()) {
            return;
        }
        future = future.executor().schedule(new SslHandler$5(this, promise), l2, TimeUnit.MILLISECONDS);
        promise.addListener(new SslHandler$6(this, (java.util.concurrent.ScheduledFuture)((Object)future)));
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        if (!this.startTls && this.engine.getUseClientMode()) {
            this.handshake(null);
        }
        channelHandlerContext.fireChannelActive();
    }

    private void safeClose(ChannelHandlerContext channelHandlerContext, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        if (!channelHandlerContext.channel().isActive()) {
            channelHandlerContext.close(channelPromise);
            return;
        }
        ScheduledFuture<?> scheduledFuture = !channelFuture.isDone() ? (this.closeNotifyTimeoutMillis > 0L ? channelHandlerContext.executor().schedule(new SslHandler$7(this, channelHandlerContext, channelPromise), this.closeNotifyTimeoutMillis, TimeUnit.MILLISECONDS) : null) : null;
        channelFuture.addListener(new SslHandler$8(this, scheduledFuture, channelHandlerContext, channelPromise));
    }

    private static void addCloseListener(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        channelFuture.addListener(new ChannelPromiseNotifier(false, channelPromise));
    }

    private ByteBuf allocate(ChannelHandlerContext object, int n2) {
        object = object.alloc();
        if (this.wantsDirectBuffer) {
            return object.directBuffer(n2);
        }
        return object.buffer(n2);
    }

    private ByteBuf allocateOutNetBuf(ChannelHandlerContext channelHandlerContext, int n2) {
        if (this.wantsLargeOutboundNetworkBuffer) {
            return this.allocate(channelHandlerContext, this.maxPacketBufferSize);
        }
        return this.allocate(channelHandlerContext, Math.min(n2 + 2329, this.maxPacketBufferSize));
    }

    static /* synthetic */ boolean access$102(SslHandler sslHandler, boolean bl) {
        sslHandler.outboundClosed = bl;
        return sslHandler.outboundClosed;
    }

    static /* synthetic */ SSLEngine access$200(SslHandler sslHandler) {
        return sslHandler.engine;
    }

    static /* synthetic */ void access$300(SslHandler sslHandler, ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        sslHandler.flush(channelHandlerContext, channelPromise);
    }

    static /* synthetic */ InternalLogger access$400() {
        return logger;
    }

    static /* synthetic */ ChannelHandlerContext access$500(SslHandler sslHandler) {
        return sslHandler.ctx;
    }

    static /* synthetic */ void access$600(SslHandler sslHandler, Promise promise) {
        sslHandler.handshake(promise);
    }

    static /* synthetic */ SSLException access$700() {
        return HANDSHAKE_TIMED_OUT;
    }

    static /* synthetic */ void access$800(SslHandler sslHandler, Throwable throwable) {
        sslHandler.notifyHandshakeFailure(throwable);
    }

    static /* synthetic */ void access$900(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        SslHandler.addCloseListener(channelFuture, channelPromise);
    }
}

