/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.ReadOnlyByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.base64.Base64;
import com.aliyun.openservices.shade.io.netty.handler.codec.base64.Base64Dialect;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslHandshakeCompletionEvent;

final class SslUtils {
    public static final int SSL_CONTENT_TYPE_CHANGE_CIPHER_SPEC = 20;
    public static final int SSL_CONTENT_TYPE_ALERT = 21;
    public static final int SSL_CONTENT_TYPE_HANDSHAKE = 22;
    public static final int SSL_CONTENT_TYPE_APPLICATION_DATA = 23;
    public static final int SSL_RECORD_HEADER_LENGTH = 5;

    static int getEncryptedPacketLength(ByteBuf byteBuf, int n2) {
        int n3;
        boolean bl;
        int n4 = 0;
        switch (byteBuf.getUnsignedByte(n2)) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl && ((n3 = byteBuf.getUnsignedByte(n2 + 1)) != 3 || (n4 = byteBuf.getUnsignedShort(n2 + 3) + 5) <= 5)) {
            bl = false;
        }
        if (!bl) {
            n3 = (byteBuf.getUnsignedByte(n2) & 0x80) != 0 ? 2 : 3;
            short s2 = byteBuf.getUnsignedByte(n2 + n3 + 1);
            n4 = s2;
            if (s2 == 2 || n4 == 3) {
                n4 = n3 == 2 ? (byteBuf.getShort(n2) & Short.MAX_VALUE) + 2 : (byteBuf.getShort(n2) & 0x3FFF) + 3;
                if (n4 <= n3) {
                    return -1;
                }
            } else {
                return -1;
            }
        }
        return n4;
    }

    static void notifyHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        channelHandlerContext.flush();
        channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(throwable));
        channelHandlerContext.close();
    }

    static void zeroout(ByteBuf byteBuf) {
        if (!(byteBuf instanceof ReadOnlyByteBuf)) {
            byteBuf.setZero(0, byteBuf.capacity());
        }
    }

    static void zerooutAndRelease(ByteBuf byteBuf) {
        SslUtils.zeroout(byteBuf);
        byteBuf.release();
    }

    static ByteBuf toBase64(ByteBufAllocator object, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        object = Base64.encode(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes(), true, Base64Dialect.STANDARD, (ByteBufAllocator)object);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.readerIndex(byteBuf3.writerIndex());
        return object;
    }

    private SslUtils() {
    }
}

