/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl.util;

import com.aliyun.openservices.shade.io.netty.handler.ssl.util.SelfSignedCertificate;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

final class BouncyCastleSelfSignedCertGenerator {
    private static final Provider PROVIDER = new BouncyCastleProvider();

    static String[] generate(String string, KeyPair keyPair, SecureRandom serializable, Date date, Date date2) {
        PrivateKey privateKey = keyPair.getPrivate();
        X500Name x500Name = new X500Name("CN=" + string);
        serializable = new JcaX509v3CertificateBuilder(x500Name, new BigInteger(64, (Random)serializable), date, date2, x500Name, keyPair.getPublic());
        date = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(privateKey);
        serializable = serializable.build((ContentSigner)date);
        serializable = new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate((X509CertificateHolder)serializable);
        ((Certificate)serializable).verify(keyPair.getPublic());
        return SelfSignedCertificate.newSelfSignedCertificate(string, privateKey, (X509Certificate)serializable);
    }

    private BouncyCastleSelfSignedCertGenerator() {
    }
}

