/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl.util;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.handler.ssl.util.FingerprintTrustManagerFactory$1;
import com.aliyun.openservices.shade.io.netty.handler.ssl.util.FingerprintTrustManagerFactory$2;
import com.aliyun.openservices.shade.io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import com.aliyun.openservices.shade.io.netty.util.concurrent.FastThreadLocal;
import com.aliyun.openservices.shade.io.netty.util.internal.InternalThreadLocalMap;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;

public final class FingerprintTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Pattern FINGERPRINT_PATTERN = Pattern.compile("^[0-9a-fA-F:]+$");
    private static final Pattern FINGERPRINT_STRIP_PATTERN = Pattern.compile(":");
    private static final int SHA1_BYTE_LEN = 20;
    private static final int SHA1_HEX_LEN = 40;
    private static final FastThreadLocal<MessageDigest> tlmd = new FingerprintTrustManagerFactory$1();
    private final TrustManager tm = new FingerprintTrustManagerFactory$2(this);
    private final byte[][] fingerprints;

    public FingerprintTrustManagerFactory(Iterable<String> iterable) {
        this(FingerprintTrustManagerFactory.toFingerprintArray(iterable));
    }

    public FingerprintTrustManagerFactory(String ... stringArray) {
        this(FingerprintTrustManagerFactory.toFingerprintArray(Arrays.asList(stringArray)));
    }

    public FingerprintTrustManagerFactory(byte[] ... byArray) {
        if (byArray == null) {
            throw new NullPointerException("fingerprints");
        }
        ArrayList<Object> arrayList = InternalThreadLocalMap.get().arrayList();
        for (byte[] byArray2 : byArray) {
            if (byArray2 == null) break;
            if (byArray2.length != 20) {
                throw new IllegalArgumentException("malformed fingerprint: " + ByteBufUtil.hexDump(Unpooled.wrappedBuffer(byArray2)) + " (expected: SHA1)");
            }
            arrayList.add(byArray2.clone());
        }
        ArrayList<Object> arrayList2 = arrayList;
        this.fingerprints = (byte[][])arrayList2.toArray((T[])new byte[arrayList2.size()][]);
    }

    private static byte[][] toFingerprintArray(Iterable<String> object) {
        String string;
        if (object == null) {
            throw new NullPointerException("fingerprints");
        }
        ArrayList<byte[]> arrayList = InternalThreadLocalMap.get().arrayList();
        object = object.iterator();
        while (object.hasNext() && (string = (String)object.next()) != null) {
            if (!FINGERPRINT_PATTERN.matcher(string).matches()) {
                throw new IllegalArgumentException("malformed fingerprint: " + string);
            }
            if ((string = FINGERPRINT_STRIP_PATTERN.matcher(string).replaceAll("")).length() != 40) {
                throw new IllegalArgumentException("malformed fingerprint: " + string + " (expected: SHA1)");
            }
            byte[] byArray = new byte[20];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                int n2;
                int n3 = n2 = i2 << 1;
                byArray[i2] = (byte)Integer.parseInt(string.substring(n3, n3 + 2), 16);
            }
            arrayList.add(byArray);
        }
        ArrayList<byte[]> arrayList2 = arrayList;
        return (byte[][])arrayList2.toArray((T[])new byte[arrayList2.size()][]);
    }

    @Override
    protected final void engineInit(KeyStore keyStore) {
    }

    @Override
    protected final void engineInit(ManagerFactoryParameters managerFactoryParameters) {
    }

    @Override
    protected final TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.tm};
    }

    static /* synthetic */ byte[][] access$000(FingerprintTrustManagerFactory fingerprintTrustManagerFactory) {
        return fingerprintTrustManagerFactory.fingerprints;
    }

    static /* synthetic */ FastThreadLocal access$100() {
        return tlmd;
    }
}

