/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl.util;

import com.aliyun.openservices.shade.io.netty.handler.ssl.util.SelfSignedCertificate;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Random;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

final class OpenJdkSelfSignedCertGenerator {
    static String[] generate(String string, KeyPair keyPair, SecureRandom serializable, Date date, Date date2) {
        PrivateKey privateKey = keyPair.getPrivate();
        X509CertInfo x509CertInfo = new X509CertInfo();
        X500Name x500Name = new X500Name("CN=" + string);
        x509CertInfo.set("version", new CertificateVersion(2));
        x509CertInfo.set("serialNumber", new CertificateSerialNumber(new BigInteger(64, (Random)serializable)));
        try {
            x509CertInfo.set("subject", new CertificateSubjectName(x500Name));
        }
        catch (CertificateException certificateException) {
            x509CertInfo.set("subject", x500Name);
        }
        try {
            x509CertInfo.set("issuer", new CertificateIssuerName(x500Name));
        }
        catch (CertificateException certificateException) {
            x509CertInfo.set("issuer", x500Name);
        }
        x509CertInfo.set("validity", new CertificateValidity(date, date2));
        x509CertInfo.set("key", new CertificateX509Key(keyPair.getPublic()));
        x509CertInfo.set("algorithmID", new CertificateAlgorithmId(new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid)));
        serializable = new X509CertImpl(x509CertInfo);
        serializable.sign(privateKey, "SHA1withRSA");
        x509CertInfo.set("algorithmID.algorithm", serializable.get("x509.algorithm"));
        serializable = new X509CertImpl(x509CertInfo);
        serializable.sign(privateKey, "SHA1withRSA");
        ((X509CertImpl)serializable).verify(keyPair.getPublic());
        return SelfSignedCertificate.newSelfSignedCertificate(string, privateKey, (X509Certificate)serializable);
    }

    private OpenJdkSelfSignedCertGenerator() {
    }
}

