/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.ssl.util;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.handler.codec.base64.Base64;
import com.aliyun.openservices.shade.io.netty.handler.ssl.util.BouncyCastleSelfSignedCertGenerator;
import com.aliyun.openservices.shade.io.netty.handler.ssl.util.OpenJdkSelfSignedCertGenerator;
import com.aliyun.openservices.shade.io.netty.handler.ssl.util.ThreadLocalInsecureRandom;
import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.SystemPropertyUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;

public final class SelfSignedCertificate {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SelfSignedCertificate.class);
    private static final Date DEFAULT_NOT_BEFORE = new Date(SystemPropertyUtil.getLong("com.aliyun.openservices.shade.io.netty.selfSignedCertificate.defaultNotBefore", System.currentTimeMillis() - 31536000000L));
    private static final Date DEFAULT_NOT_AFTER = new Date(SystemPropertyUtil.getLong("com.aliyun.openservices.shade.io.netty.selfSignedCertificate.defaultNotAfter", 253402300799000L));
    private final File certificate;
    private final File privateKey;
    private final X509Certificate cert;
    private final PrivateKey key;

    public SelfSignedCertificate() {
        this(DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER);
    }

    public SelfSignedCertificate(Date date, Date date2) {
        this("example.com", date, date2);
    }

    public SelfSignedCertificate(String string) {
        this(string, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER);
    }

    public SelfSignedCertificate(String string, Date date, Date date2) {
        this(string, ThreadLocalInsecureRandom.current(), 1024, date, date2);
    }

    public SelfSignedCertificate(String string, SecureRandom secureRandom, int n2) {
        this(string, secureRandom, n2, DEFAULT_NOT_BEFORE, DEFAULT_NOT_AFTER);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SelfSignedCertificate(String string, SecureRandom secureRandom, int n2, Date date, Date date2) {
        KeyPair keyPair;
        Object object;
        try {
            object = KeyPairGenerator.getInstance("RSA");
            ((KeyPairGenerator)object).initialize(n2, secureRandom);
            keyPair = ((KeyPairGenerator)object).generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error(noSuchAlgorithmException);
        }
        try {
            object = OpenJdkSelfSignedCertGenerator.generate(string, keyPair, secureRandom, date, date2);
        }
        catch (Throwable throwable) {
            logger.debug("Failed to generate a self-signed X.509 certificate using sun.security.x509:", throwable);
            try {
                object = BouncyCastleSelfSignedCertGenerator.generate(string, keyPair, secureRandom, date, date2);
            }
            catch (Throwable throwable2) {
                logger.debug("Failed to generate a self-signed X.509 certificate using Bouncy Castle:", throwable2);
                throw new CertificateException("No provider succeeded to generate a self-signed certificate. See debug log for the root cause.");
            }
        }
        this.certificate = new File(object[0]);
        this.privateKey = new File(object[1]);
        this.key = keyPair.getPrivate();
        object = null;
        try {
            object = new FileInputStream(this.certificate);
            this.cert = (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate((InputStream)object);
        }
        catch (Exception exception) {
            try {
                throw new CertificateEncodingException(exception);
            }
            catch (Throwable throwable) {
                if (object == null) throw throwable;
                try {
                    ((FileInputStream)object).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    logger.warn("Failed to close a file: " + this.certificate, iOException);
                }
                throw throwable;
            }
        }
        try {
            ((FileInputStream)object).close();
            return;
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a file: " + this.certificate, iOException);
            return;
        }
    }

    public final File certificate() {
        return this.certificate;
    }

    public final File privateKey() {
        return this.privateKey;
    }

    public final X509Certificate cert() {
        return this.cert;
    }

    public final PrivateKey key() {
        return this.key;
    }

    public final void delete() {
        SelfSignedCertificate.safeDelete(this.certificate);
        SelfSignedCertificate.safeDelete(this.privateKey);
    }

    static String[] newSelfSignedCertificate(String object, PrivateKey object2, X509Certificate object3) {
        String string;
        Object object4;
        object2 = Unpooled.wrappedBuffer(object2.getEncoded());
        try {
            object4 = Base64.encode((ByteBuf)object2, true);
            try {
                string = "-----BEGIN PRIVATE KEY-----\n" + ((ByteBuf)object4).toString(CharsetUtil.US_ASCII) + "\n-----END PRIVATE KEY-----\n";
            }
            finally {
                object4.release();
            }
        }
        finally {
            object2.release();
        }
        File file = File.createTempFile("keyutil_" + (String)object + '_', ".key");
        file.deleteOnExit();
        object4 = new FileOutputStream(file);
        try {
            ((OutputStream)object4).write(string.getBytes(CharsetUtil.US_ASCII));
            ((OutputStream)object4).close();
            object4 = null;
        }
        catch (Throwable throwable) {
            SelfSignedCertificate.safeClose(file, (OutputStream)object4);
            SelfSignedCertificate.safeDelete(file);
            throw throwable;
        }
        object2 = Unpooled.wrappedBuffer(((Certificate)object3).getEncoded());
        try {
            object4 = Base64.encode((ByteBuf)object2, true);
            try {
                object3 = "-----BEGIN CERTIFICATE-----\n" + ((ByteBuf)object4).toString(CharsetUtil.US_ASCII) + "\n-----END CERTIFICATE-----\n";
            }
            finally {
                object4.release();
            }
        }
        finally {
            object2.release();
        }
        object = File.createTempFile("keyutil_" + (String)object + '_', ".crt");
        ((File)object).deleteOnExit();
        object4 = new FileOutputStream((File)object);
        try {
            ((OutputStream)object4).write(((String)object3).getBytes(CharsetUtil.US_ASCII));
            ((OutputStream)object4).close();
            object4 = null;
        }
        catch (Throwable throwable) {
            SelfSignedCertificate.safeClose((File)object, (OutputStream)object4);
            SelfSignedCertificate.safeDelete((File)object);
            SelfSignedCertificate.safeDelete(file);
            throw throwable;
        }
        return new String[]{((File)object).getPath(), file.getPath()};
    }

    private static void safeDelete(File file) {
        if (!file.delete()) {
            logger.warn("Failed to delete a file: " + file);
        }
    }

    private static void safeClose(File file, OutputStream outputStream) {
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a file: " + file, iOException);
            return;
        }
    }
}

