/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.stream;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.stream.ChunkedInput;
import java.io.File;
import java.io.FileInputStream;
import java.nio.channels.FileChannel;

public class ChunkedNioFile
implements ChunkedInput<ByteBuf> {
    private final FileChannel in;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private long offset;

    public ChunkedNioFile(File file) {
        this(new FileInputStream(file).getChannel());
    }

    public ChunkedNioFile(File file, int n2) {
        this(new FileInputStream(file).getChannel(), n2);
    }

    public ChunkedNioFile(FileChannel fileChannel) {
        this(fileChannel, 8192);
    }

    public ChunkedNioFile(FileChannel fileChannel, int n2) {
        this(fileChannel, 0L, fileChannel.size(), n2);
    }

    public ChunkedNioFile(FileChannel fileChannel, long l2, long l3, int n2) {
        if (fileChannel == null) {
            throw new NullPointerException("in");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("offset: " + l2 + " (expected: 0 or greater)");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("length: " + l3 + " (expected: 0 or greater)");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("chunkSize: " + n2 + " (expected: a positive integer)");
        }
        if (l2 != 0L) {
            fileChannel.position(l2);
        }
        this.in = fileChannel;
        this.chunkSize = n2;
        ChunkedNioFile chunkedNioFile = this;
        chunkedNioFile.offset = chunkedNioFile.startOffset = l2;
        this.endOffset = l2 + l3;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public long currentOffset() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() {
        return this.offset >= this.endOffset || !this.in.isOpen();
    }

    @Override
    public void close() {
        this.in.close();
    }

    @Override
    public ByteBuf readChunk(ChannelHandlerContext object) {
        long l2 = this.offset;
        if (l2 >= this.endOffset) {
            return null;
        }
        int n2 = (int)Math.min((long)this.chunkSize, this.endOffset - l2);
        object = object.alloc().buffer(n2);
        boolean bl = true;
        try {
            int n3;
            int n4 = 0;
            while ((n3 = ((ByteBuf)object).writeBytes(this.in, n2 - n4)) >= 0 && (n4 += n3) != n2) {
            }
            this.offset += (long)n4;
            bl = false;
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable) {
            if (bl) {
                object.release();
            }
            throw throwable;
        }
    }
}

