/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.stream;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.stream.ChunkedInput;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ChunkedNioStream
implements ChunkedInput<ByteBuf> {
    private final ReadableByteChannel in;
    private final int chunkSize;
    private long offset;
    private final ByteBuffer byteBuffer;

    public ChunkedNioStream(ReadableByteChannel readableByteChannel) {
        this(readableByteChannel, 8192);
    }

    public ChunkedNioStream(ReadableByteChannel readableByteChannel, int n2) {
        if (readableByteChannel == null) {
            throw new NullPointerException("in");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("chunkSize: " + n2 + " (expected: a positive integer)");
        }
        this.in = readableByteChannel;
        this.offset = 0L;
        this.chunkSize = n2;
        this.byteBuffer = ByteBuffer.allocate(n2);
    }

    public long transferredBytes() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() {
        if (this.byteBuffer.position() > 0) {
            return false;
        }
        if (this.in.isOpen()) {
            int n2 = this.in.read(this.byteBuffer);
            if (n2 < 0) {
                return true;
            }
            this.offset += (long)n2;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.in.close();
    }

    @Override
    public ByteBuf readChunk(ChannelHandlerContext object) {
        int n2;
        if (this.isEndOfInput()) {
            return null;
        }
        int n3 = this.byteBuffer.position();
        while ((n2 = this.in.read(this.byteBuffer)) >= 0) {
            this.offset += (long)n2;
            if ((n3 += n2) != this.chunkSize) continue;
        }
        this.byteBuffer.flip();
        n2 = 1;
        object = object.alloc().buffer(this.byteBuffer.remaining());
        try {
            ((ByteBuf)object).writeBytes(this.byteBuffer);
            this.byteBuffer.clear();
            n2 = 0;
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable) {
            if (n2 != 0) {
                object.release();
            }
            throw throwable;
        }
    }
}

