/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.stream;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.stream.ChunkedInput;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class ChunkedStream
implements ChunkedInput<ByteBuf> {
    static final int DEFAULT_CHUNK_SIZE = 8192;
    private final PushbackInputStream in;
    private final int chunkSize;
    private long offset;
    private boolean closed;

    public ChunkedStream(InputStream inputStream) {
        this(inputStream, 8192);
    }

    public ChunkedStream(InputStream inputStream, int n2) {
        if (inputStream == null) {
            throw new NullPointerException("in");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("chunkSize: " + n2 + " (expected: a positive integer)");
        }
        this.in = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        this.chunkSize = n2;
    }

    public long transferredBytes() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() {
        if (this.closed) {
            return true;
        }
        int n2 = this.in.read();
        if (n2 < 0) {
            return true;
        }
        this.in.unread(n2);
        return false;
    }

    @Override
    public void close() {
        this.closed = true;
        this.in.close();
    }

    @Override
    public ByteBuf readChunk(ChannelHandlerContext object) {
        if (this.isEndOfInput()) {
            return null;
        }
        int n2 = this.in.available();
        n2 = n2 <= 0 ? this.chunkSize : Math.min(this.chunkSize, this.in.available());
        boolean bl = true;
        object = object.alloc().buffer(n2);
        try {
            this.offset += (long)((ByteBuf)object).writeBytes(this.in, n2);
            bl = false;
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable) {
            if (bl) {
                object.release();
            }
            throw throwable;
        }
    }
}

