/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.stream;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufHolder;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelDuplexHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.stream.ChunkedInput;
import com.aliyun.openservices.shade.io.netty.handler.stream.ChunkedWriteHandler$1;
import com.aliyun.openservices.shade.io.netty.handler.stream.ChunkedWriteHandler$2;
import com.aliyun.openservices.shade.io.netty.handler.stream.ChunkedWriteHandler$3;
import com.aliyun.openservices.shade.io.netty.handler.stream.ChunkedWriteHandler$4;
import com.aliyun.openservices.shade.io.netty.handler.stream.ChunkedWriteHandler$PendingWrite;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

public class ChunkedWriteHandler
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChunkedWriteHandler.class);
    private final Queue<ChunkedWriteHandler$PendingWrite> queue = new ArrayDeque<ChunkedWriteHandler$PendingWrite>();
    private volatile ChannelHandlerContext ctx;
    private ChunkedWriteHandler$PendingWrite currentWrite;

    public ChunkedWriteHandler() {
    }

    @Deprecated
    public ChunkedWriteHandler(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxPendingWrites: " + n2 + " (expected: > 0)");
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    public void resumeTransfer() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            return;
        }
        if (channelHandlerContext.executor().inEventLoop()) {
            try {
                this.doFlush(channelHandlerContext);
                return;
            }
            catch (Exception exception) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Unexpected exception while sending chunks.", exception);
                }
                return;
            }
        }
        channelHandlerContext.executor().execute(new ChunkedWriteHandler$1(this, channelHandlerContext));
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        this.queue.add(new ChunkedWriteHandler$PendingWrite(object, channelPromise));
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        if (!this.doFlush(channelHandlerContext)) {
            channelHandlerContext.flush();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.doFlush(channelHandlerContext);
        channelHandlerContext.fireChannelInactive();
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isWritable()) {
            this.doFlush(channelHandlerContext);
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    private void discard(Throwable throwable) {
        while (true) {
            ChunkedWriteHandler$PendingWrite chunkedWriteHandler$PendingWrite = this.currentWrite;
            if (this.currentWrite == null) {
                chunkedWriteHandler$PendingWrite = this.queue.poll();
            } else {
                this.currentWrite = null;
            }
            if (chunkedWriteHandler$PendingWrite == null) break;
            Object object = chunkedWriteHandler$PendingWrite.msg;
            if (object instanceof ChunkedInput) {
                object = (ChunkedInput)object;
                try {
                    if (!object.isEndOfInput()) {
                        if (throwable == null) {
                            throwable = new ClosedChannelException();
                        }
                        chunkedWriteHandler$PendingWrite.fail(throwable);
                    } else {
                        chunkedWriteHandler$PendingWrite.success();
                    }
                    ChunkedWriteHandler.closeInput(object);
                }
                catch (Exception exception) {
                    chunkedWriteHandler$PendingWrite.fail(exception);
                    logger.warn(ChunkedInput.class.getSimpleName() + ".isEndOfInput() failed", exception);
                    ChunkedWriteHandler.closeInput(object);
                }
                continue;
            }
            if (throwable == null) {
                throwable = new ClosedChannelException();
            }
            chunkedWriteHandler$PendingWrite.fail(throwable);
        }
    }

    private boolean doFlush(ChannelHandlerContext channelHandlerContext) {
        Channel channel = channelHandlerContext.channel();
        if (!channel.isActive()) {
            this.discard(null);
            return false;
        }
        boolean bl = false;
        while (channel.isWritable()) {
            if (this.currentWrite == null) {
                this.currentWrite = this.queue.poll();
            }
            if (this.currentWrite == null) break;
            ChunkedWriteHandler$PendingWrite chunkedWriteHandler$PendingWrite = this.currentWrite;
            Object object = chunkedWriteHandler$PendingWrite.msg;
            if (object instanceof ChunkedInput) {
                int n2;
                boolean bl2;
                ChunkedInput chunkedInput = (ChunkedInput)object;
                ByteBuf byteBuf = null;
                try {
                    byteBuf = (ByteBuf)chunkedInput.readChunk(channelHandlerContext);
                    bl2 = chunkedInput.isEndOfInput();
                    n2 = byteBuf == null ? (!bl2 ? 1 : 0) : 0;
                }
                catch (Throwable throwable) {
                    this.currentWrite = null;
                    if (byteBuf != null) {
                        ReferenceCountUtil.release(byteBuf);
                    }
                    chunkedWriteHandler$PendingWrite.fail(throwable);
                    ChunkedWriteHandler.closeInput(chunkedInput);
                    break;
                }
                if (n2 != 0) break;
                if (byteBuf == null) {
                    byteBuf = Unpooled.EMPTY_BUFFER;
                }
                n2 = ChunkedWriteHandler.amount(byteBuf);
                ChannelFuture channelFuture = channelHandlerContext.write(byteBuf);
                if (bl2) {
                    this.currentWrite = null;
                    channelFuture.addListener(new ChunkedWriteHandler$2(this, chunkedWriteHandler$PendingWrite, n2, chunkedInput));
                } else if (channel.isWritable()) {
                    channelFuture.addListener(new ChunkedWriteHandler$3(this, object, chunkedWriteHandler$PendingWrite, n2));
                } else {
                    channelFuture.addListener(new ChunkedWriteHandler$4(this, object, chunkedWriteHandler$PendingWrite, n2, channel));
                }
            } else {
                channelHandlerContext.write(object, chunkedWriteHandler$PendingWrite.promise);
                this.currentWrite = null;
            }
            channelHandlerContext.flush();
            bl = true;
            if (channel.isActive()) continue;
            this.discard(new ClosedChannelException());
            break;
        }
        return bl;
    }

    static void closeInput(ChunkedInput<?> chunkedInput) {
        try {
            chunkedInput.close();
            return;
        }
        catch (Throwable throwable) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to close a chunked input.", throwable);
            }
            return;
        }
    }

    private static int amount(Object object) {
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).readableBytes();
        }
        if (object instanceof ByteBufHolder) {
            return ((ByteBufHolder)object).content().readableBytes();
        }
        return 1;
    }

    static /* synthetic */ boolean access$000(ChunkedWriteHandler chunkedWriteHandler, ChannelHandlerContext channelHandlerContext) {
        return chunkedWriteHandler.doFlush(channelHandlerContext);
    }

    static /* synthetic */ InternalLogger access$100() {
        return logger;
    }
}

