/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.timeout;

import com.aliyun.openservices.shade.io.netty.channel.ChannelDuplexHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.timeout.IdleState;
import com.aliyun.openservices.shade.io.netty.handler.timeout.IdleStateEvent;
import com.aliyun.openservices.shade.io.netty.handler.timeout.IdleStateHandler$1;
import com.aliyun.openservices.shade.io.netty.handler.timeout.IdleStateHandler$AllIdleTimeoutTask;
import com.aliyun.openservices.shade.io.netty.handler.timeout.IdleStateHandler$ReaderIdleTimeoutTask;
import com.aliyun.openservices.shade.io.netty.handler.timeout.IdleStateHandler$WriterIdleTimeoutTask;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class IdleStateHandler
extends ChannelDuplexHandler {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final ChannelFutureListener writeListener = new IdleStateHandler$1(this);
    private final long readerIdleTimeNanos;
    private final long writerIdleTimeNanos;
    private final long allIdleTimeNanos;
    private ScheduledFuture<?> readerIdleTimeout;
    private long lastReadTime;
    private boolean firstReaderIdleEvent = true;
    private ScheduledFuture<?> writerIdleTimeout;
    private long lastWriteTime;
    private boolean firstWriterIdleEvent = true;
    private ScheduledFuture<?> allIdleTimeout;
    private boolean firstAllIdleEvent = true;
    private byte state;
    private boolean reading;

    public IdleStateHandler(int n2, int n3, int n4) {
        this(n2, n3, n4, TimeUnit.SECONDS);
    }

    public IdleStateHandler(long l2, long l3, long l4, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        this.readerIdleTimeNanos = l2 <= 0L ? 0L : Math.max(timeUnit.toNanos(l2), MIN_TIMEOUT_NANOS);
        this.writerIdleTimeNanos = l3 <= 0L ? 0L : Math.max(timeUnit.toNanos(l3), MIN_TIMEOUT_NANOS);
        if (l4 <= 0L) {
            this.allIdleTimeNanos = 0L;
            return;
        }
        this.allIdleTimeNanos = Math.max(timeUnit.toNanos(l4), MIN_TIMEOUT_NANOS);
    }

    public long getReaderIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.readerIdleTimeNanos);
    }

    public long getWriterIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.writerIdleTimeNanos);
    }

    public long getAllIdleTimeInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.allIdleTimeNanos);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isActive() && channelHandlerContext.channel().isRegistered()) {
            this.initialize(channelHandlerContext);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.destroy();
    }

    @Override
    public void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isActive()) {
            this.initialize(channelHandlerContext);
        }
        super.channelRegistered(channelHandlerContext);
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        this.initialize(channelHandlerContext);
        super.channelActive(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.destroy();
        super.channelInactive(channelHandlerContext);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            this.reading = true;
            IdleStateHandler idleStateHandler = this;
            idleStateHandler.firstAllIdleEvent = true;
            idleStateHandler.firstReaderIdleEvent = true;
        }
        channelHandlerContext.fireChannelRead(object);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if ((this.readerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) && this.reading) {
            this.lastReadTime = System.nanoTime();
            this.reading = false;
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (this.writerIdleTimeNanos > 0L || this.allIdleTimeNanos > 0L) {
            channelPromise.addListener(this.writeListener);
        }
        channelHandlerContext.write(object, channelPromise);
    }

    private void initialize(ChannelHandlerContext channelHandlerContext) {
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        this.state = 1;
        EventExecutor eventExecutor = channelHandlerContext.executor();
        IdleStateHandler idleStateHandler = this;
        idleStateHandler.lastReadTime = idleStateHandler.lastWriteTime = System.nanoTime();
        if (this.readerIdleTimeNanos > 0L) {
            this.readerIdleTimeout = eventExecutor.schedule(new IdleStateHandler$ReaderIdleTimeoutTask(this, channelHandlerContext), this.readerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.writerIdleTimeNanos > 0L) {
            this.writerIdleTimeout = eventExecutor.schedule(new IdleStateHandler$WriterIdleTimeoutTask(this, channelHandlerContext), this.writerIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
        if (this.allIdleTimeNanos > 0L) {
            this.allIdleTimeout = eventExecutor.schedule(new IdleStateHandler$AllIdleTimeoutTask(this, channelHandlerContext), this.allIdleTimeNanos, TimeUnit.NANOSECONDS);
        }
    }

    private void destroy() {
        this.state = (byte)2;
        if (this.readerIdleTimeout != null) {
            this.readerIdleTimeout.cancel(false);
            this.readerIdleTimeout = null;
        }
        if (this.writerIdleTimeout != null) {
            this.writerIdleTimeout.cancel(false);
            this.writerIdleTimeout = null;
        }
        if (this.allIdleTimeout != null) {
            this.allIdleTimeout.cancel(false);
            this.allIdleTimeout = null;
        }
    }

    protected void channelIdle(ChannelHandlerContext channelHandlerContext, IdleStateEvent idleStateEvent) {
        channelHandlerContext.fireUserEventTriggered(idleStateEvent);
    }

    protected IdleStateEvent newIdleStateEvent(IdleState idleState, boolean bl) {
        switch (idleState) {
            case ALL_IDLE: {
                if (bl) {
                    return IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT;
                }
                return IdleStateEvent.ALL_IDLE_STATE_EVENT;
            }
            case READER_IDLE: {
                if (bl) {
                    return IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT;
                }
                return IdleStateEvent.READER_IDLE_STATE_EVENT;
            }
            case WRITER_IDLE: {
                if (bl) {
                    return IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT;
                }
                return IdleStateEvent.WRITER_IDLE_STATE_EVENT;
            }
        }
        throw new Error();
    }

    static /* synthetic */ long access$002(IdleStateHandler idleStateHandler, long l2) {
        idleStateHandler.lastWriteTime = l2;
        return idleStateHandler.lastWriteTime;
    }

    static /* synthetic */ boolean access$102(IdleStateHandler idleStateHandler, boolean bl) {
        idleStateHandler.firstWriterIdleEvent = bl;
        return idleStateHandler.firstWriterIdleEvent;
    }

    static /* synthetic */ boolean access$202(IdleStateHandler idleStateHandler, boolean bl) {
        idleStateHandler.firstAllIdleEvent = bl;
        return idleStateHandler.firstAllIdleEvent;
    }

    static /* synthetic */ long access$300(IdleStateHandler idleStateHandler) {
        return idleStateHandler.readerIdleTimeNanos;
    }

    static /* synthetic */ boolean access$400(IdleStateHandler idleStateHandler) {
        return idleStateHandler.reading;
    }

    static /* synthetic */ long access$500(IdleStateHandler idleStateHandler) {
        return idleStateHandler.lastReadTime;
    }

    static /* synthetic */ ScheduledFuture access$602(IdleStateHandler idleStateHandler, ScheduledFuture scheduledFuture) {
        idleStateHandler.readerIdleTimeout = scheduledFuture;
        return idleStateHandler.readerIdleTimeout;
    }

    static /* synthetic */ boolean access$700(IdleStateHandler idleStateHandler) {
        return idleStateHandler.firstReaderIdleEvent;
    }

    static /* synthetic */ boolean access$702(IdleStateHandler idleStateHandler, boolean bl) {
        idleStateHandler.firstReaderIdleEvent = bl;
        return idleStateHandler.firstReaderIdleEvent;
    }

    static /* synthetic */ long access$000(IdleStateHandler idleStateHandler) {
        return idleStateHandler.lastWriteTime;
    }

    static /* synthetic */ long access$800(IdleStateHandler idleStateHandler) {
        return idleStateHandler.writerIdleTimeNanos;
    }

    static /* synthetic */ ScheduledFuture access$902(IdleStateHandler idleStateHandler, ScheduledFuture scheduledFuture) {
        idleStateHandler.writerIdleTimeout = scheduledFuture;
        return idleStateHandler.writerIdleTimeout;
    }

    static /* synthetic */ boolean access$100(IdleStateHandler idleStateHandler) {
        return idleStateHandler.firstWriterIdleEvent;
    }

    static /* synthetic */ long access$1000(IdleStateHandler idleStateHandler) {
        return idleStateHandler.allIdleTimeNanos;
    }

    static /* synthetic */ ScheduledFuture access$1102(IdleStateHandler idleStateHandler, ScheduledFuture scheduledFuture) {
        idleStateHandler.allIdleTimeout = scheduledFuture;
        return idleStateHandler.allIdleTimeout;
    }

    static /* synthetic */ boolean access$200(IdleStateHandler idleStateHandler) {
        return idleStateHandler.firstAllIdleEvent;
    }
}

