/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.timeout;

import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.timeout.WriteTimeoutException;
import com.aliyun.openservices.shade.io.netty.handler.timeout.WriteTimeoutHandler$WriteTimeoutTask;
import java.util.concurrent.TimeUnit;

public class WriteTimeoutHandler
extends ChannelOutboundHandlerAdapter {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final long timeoutNanos;
    private WriteTimeoutHandler$WriteTimeoutTask lastTask;
    private boolean closed;

    public WriteTimeoutHandler(int n2) {
        this(n2, TimeUnit.SECONDS);
    }

    public WriteTimeoutHandler(long l2, TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        if (l2 <= 0L) {
            this.timeoutNanos = 0L;
            return;
        }
        this.timeoutNanos = Math.max(timeUnit.toNanos(l2), MIN_TIMEOUT_NANOS);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        this.scheduleTimeout(channelHandlerContext, channelPromise);
        channelHandlerContext.write(object, channelPromise);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext object) {
        object = this.lastTask;
        this.lastTask = null;
        while (object != null) {
            ((WriteTimeoutHandler$WriteTimeoutTask)object).scheduledFuture.cancel(false);
            WriteTimeoutHandler$WriteTimeoutTask writeTimeoutHandler$WriteTimeoutTask = ((WriteTimeoutHandler$WriteTimeoutTask)object).prev;
            ((WriteTimeoutHandler$WriteTimeoutTask)object).prev = null;
            ((WriteTimeoutHandler$WriteTimeoutTask)object).next = null;
            object = writeTimeoutHandler$WriteTimeoutTask;
        }
    }

    private void scheduleTimeout(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        WriteTimeoutHandler$WriteTimeoutTask writeTimeoutHandler$WriteTimeoutTask = new WriteTimeoutHandler$WriteTimeoutTask(this, channelHandlerContext, channelPromise);
        new WriteTimeoutHandler$WriteTimeoutTask(this, channelHandlerContext, channelPromise).scheduledFuture = channelHandlerContext.executor().schedule(writeTimeoutHandler$WriteTimeoutTask, this.timeoutNanos, TimeUnit.NANOSECONDS);
        if (!writeTimeoutHandler$WriteTimeoutTask.scheduledFuture.isDone()) {
            this.addWriteTimeoutTask(writeTimeoutHandler$WriteTimeoutTask);
            channelPromise.addListener(writeTimeoutHandler$WriteTimeoutTask);
        }
    }

    private void addWriteTimeoutTask(WriteTimeoutHandler$WriteTimeoutTask writeTimeoutHandler$WriteTimeoutTask) {
        if (this.lastTask == null) {
            this.lastTask = writeTimeoutHandler$WriteTimeoutTask;
            return;
        }
        this.lastTask.next = writeTimeoutHandler$WriteTimeoutTask;
        writeTimeoutHandler$WriteTimeoutTask.prev = this.lastTask;
        this.lastTask = writeTimeoutHandler$WriteTimeoutTask;
    }

    private void removeWriteTimeoutTask(WriteTimeoutHandler$WriteTimeoutTask writeTimeoutHandler$WriteTimeoutTask) {
        if (writeTimeoutHandler$WriteTimeoutTask == this.lastTask) {
            assert (writeTimeoutHandler$WriteTimeoutTask.next == null);
            this.lastTask = this.lastTask.prev;
            if (this.lastTask != null) {
                this.lastTask.next = null;
            }
        } else {
            if (writeTimeoutHandler$WriteTimeoutTask.prev == null && writeTimeoutHandler$WriteTimeoutTask.next == null) {
                return;
            }
            if (writeTimeoutHandler$WriteTimeoutTask.prev == null) {
                writeTimeoutHandler$WriteTimeoutTask.next.prev = null;
            } else {
                writeTimeoutHandler$WriteTimeoutTask.prev.next = writeTimeoutHandler$WriteTimeoutTask.next;
                writeTimeoutHandler$WriteTimeoutTask.next.prev = writeTimeoutHandler$WriteTimeoutTask.prev;
            }
        }
        writeTimeoutHandler$WriteTimeoutTask.prev = null;
        writeTimeoutHandler$WriteTimeoutTask.next = null;
    }

    protected void writeTimedOut(ChannelHandlerContext channelHandlerContext) {
        if (!this.closed) {
            channelHandlerContext.fireExceptionCaught(WriteTimeoutException.INSTANCE);
            channelHandlerContext.close();
            this.closed = true;
        }
    }

    static /* synthetic */ void access$000(WriteTimeoutHandler writeTimeoutHandler, WriteTimeoutHandler$WriteTimeoutTask writeTimeoutHandler$WriteTimeoutTask) {
        writeTimeoutHandler.removeWriteTimeoutTask(writeTimeoutHandler$WriteTimeoutTask);
    }
}

