/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.traffic;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.traffic.AbstractTrafficShapingHandler;
import com.aliyun.openservices.shade.io.netty.handler.traffic.ChannelTrafficShapingHandler$1;
import com.aliyun.openservices.shade.io.netty.handler.traffic.ChannelTrafficShapingHandler$ToSend;
import com.aliyun.openservices.shade.io.netty.handler.traffic.TrafficCounter;
import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;

public class ChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private final ArrayDeque<ChannelTrafficShapingHandler$ToSend> messagesQueue = new ArrayDeque();
    private long queueSize;

    public ChannelTrafficShapingHandler(long l2, long l3, long l4, long l5) {
        super(l2, l3, l4, l5);
    }

    public ChannelTrafficShapingHandler(long l2, long l3, long l4) {
        super(l2, l3, l4);
    }

    public ChannelTrafficShapingHandler(long l2, long l3) {
        super(l2, l3);
    }

    public ChannelTrafficShapingHandler(long l2) {
        super(l2);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        TrafficCounter trafficCounter = new TrafficCounter(this, channelHandlerContext.executor(), "ChannelTC" + channelHandlerContext.channel().hashCode(), this.checkInterval);
        this.setTrafficCounter(trafficCounter);
        trafficCounter.start();
        super.handlerAdded(channelHandlerContext);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.trafficCounter.stop();
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            if (channelHandlerContext.channel().isActive()) {
                for (ChannelTrafficShapingHandler$ToSend channelTrafficShapingHandler$ToSend : this.messagesQueue) {
                    long l2 = this.calculateSize(channelTrafficShapingHandler$ToSend.toSend);
                    this.trafficCounter.bytesRealWriteFlowControl(l2);
                    this.queueSize -= l2;
                    channelHandlerContext.write(channelTrafficShapingHandler$ToSend.toSend, channelTrafficShapingHandler$ToSend.promise);
                }
            } else {
                for (ChannelTrafficShapingHandler$ToSend channelTrafficShapingHandler$ToSend : this.messagesQueue) {
                    if (!(channelTrafficShapingHandler$ToSend.toSend instanceof ByteBuf)) continue;
                    ((ByteBuf)channelTrafficShapingHandler$ToSend.toSend).release();
                }
            }
            this.messagesQueue.clear();
        }
        this.releaseWriteSuspended(channelHandlerContext);
        this.releaseReadSuspended(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    void submitWrite(ChannelHandlerContext channelHandlerContext, Object object, long l2, long l3, long l4, ChannelPromise channelPromise) {
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            if (l3 == 0L && this.messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(l2);
                channelHandlerContext.write(object, channelPromise);
                return;
            }
            object = new ChannelTrafficShapingHandler$ToSend(l3 + l4, object, channelPromise, null);
            this.messagesQueue.addLast((ChannelTrafficShapingHandler$ToSend)object);
            this.queueSize += l2;
            this.checkWriteSuspend(channelHandlerContext, l3, this.queueSize);
        }
        long l5 = ((ChannelTrafficShapingHandler$ToSend)object).relativeTimeAction;
        channelHandlerContext.executor().schedule(new ChannelTrafficShapingHandler$1(this, channelHandlerContext, l5), l3, TimeUnit.MILLISECONDS);
    }

    private void sendAllValid(ChannelHandlerContext channelHandlerContext, long l2) {
        ChannelTrafficShapingHandler channelTrafficShapingHandler = this;
        synchronized (channelTrafficShapingHandler) {
            ChannelTrafficShapingHandler$ToSend channelTrafficShapingHandler$ToSend = this.messagesQueue.pollFirst();
            while (channelTrafficShapingHandler$ToSend != null) {
                if (channelTrafficShapingHandler$ToSend.relativeTimeAction <= l2) {
                    long l3 = this.calculateSize(channelTrafficShapingHandler$ToSend.toSend);
                    this.trafficCounter.bytesRealWriteFlowControl(l3);
                    this.queueSize -= l3;
                } else {
                    this.messagesQueue.addFirst(channelTrafficShapingHandler$ToSend);
                    break;
                }
                channelHandlerContext.write(channelTrafficShapingHandler$ToSend.toSend, channelTrafficShapingHandler$ToSend.promise);
                channelTrafficShapingHandler$ToSend = this.messagesQueue.pollFirst();
            }
            if (this.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(channelHandlerContext);
            }
        }
        channelHandlerContext.flush();
    }

    public long queueSize() {
        return this.queueSize;
    }

    static /* synthetic */ void access$100(ChannelTrafficShapingHandler channelTrafficShapingHandler, ChannelHandlerContext channelHandlerContext, long l2) {
        channelTrafficShapingHandler.sendAllValid(channelHandlerContext, l2);
    }
}

