/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.traffic;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandler$Sharable;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.traffic.AbstractTrafficShapingHandler;
import com.aliyun.openservices.shade.io.netty.handler.traffic.AbstractTrafficShapingHandler$ReopenReadTimerTask;
import com.aliyun.openservices.shade.io.netty.handler.traffic.GlobalChannelTrafficCounter;
import com.aliyun.openservices.shade.io.netty.handler.traffic.GlobalChannelTrafficShapingHandler$1;
import com.aliyun.openservices.shade.io.netty.handler.traffic.GlobalChannelTrafficShapingHandler$2;
import com.aliyun.openservices.shade.io.netty.handler.traffic.GlobalChannelTrafficShapingHandler$PerChannel;
import com.aliyun.openservices.shade.io.netty.handler.traffic.GlobalChannelTrafficShapingHandler$ToSend;
import com.aliyun.openservices.shade.io.netty.handler.traffic.TrafficCounter;
import com.aliyun.openservices.shade.io.netty.util.Attribute;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

@ChannelHandler$Sharable
public class GlobalChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(GlobalChannelTrafficShapingHandler.class);
    final ConcurrentMap<Integer, GlobalChannelTrafficShapingHandler$PerChannel> channelQueues = PlatformDependent.newConcurrentHashMap();
    private final AtomicLong queuesSize = new AtomicLong();
    private final AtomicLong cumulativeWrittenBytes = new AtomicLong();
    private final AtomicLong cumulativeReadBytes = new AtomicLong();
    volatile long maxGlobalWriteSize = 0x19000000L;
    private volatile long writeChannelLimit;
    private volatile long readChannelLimit;
    private static final float DEFAULT_DEVIATION = 0.1f;
    private static final float MAX_DEVIATION = 0.4f;
    private static final float DEFAULT_SLOWDOWN = 0.4f;
    private static final float DEFAULT_ACCELERATION = -0.1f;
    private volatile float maxDeviation;
    private volatile float accelerationFactor;
    private volatile float slowDownFactor;
    private volatile boolean readDeviationActive;
    private volatile boolean writeDeviationActive;

    void createGlobalTrafficCounter(ScheduledExecutorService object) {
        this.setMaxDeviation(0.1f, 0.4f, -0.1f);
        if (object == null) {
            throw new IllegalArgumentException("Executor must not be null");
        }
        object = new GlobalChannelTrafficCounter(this, (ScheduledExecutorService)object, "GlobalChannelTC", this.checkInterval);
        this.setTrafficCounter((TrafficCounter)object);
        ((TrafficCounter)object).start();
    }

    @Override
    protected int userDefinedWritabilityIndex() {
        return 3;
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l3, long l4, long l5, long l6, long l7) {
        super(l2, l3, l6, l7);
        this.createGlobalTrafficCounter(scheduledExecutorService);
        this.writeChannelLimit = l4;
        this.readChannelLimit = l5;
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l3, long l4, long l5, long l6) {
        super(l2, l3, l6);
        this.writeChannelLimit = l4;
        this.readChannelLimit = l5;
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2, long l3, long l4, long l5) {
        super(l2, l3);
        this.writeChannelLimit = l4;
        this.readChannelLimit = l5;
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService, long l2) {
        super(l2);
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public GlobalChannelTrafficShapingHandler(ScheduledExecutorService scheduledExecutorService) {
        this.createGlobalTrafficCounter(scheduledExecutorService);
    }

    public float maxDeviation() {
        return this.maxDeviation;
    }

    public float accelerationFactor() {
        return this.accelerationFactor;
    }

    public float slowDownFactor() {
        return this.slowDownFactor;
    }

    public void setMaxDeviation(float f2, float f3, float f4) {
        if (f2 > 0.4f) {
            throw new IllegalArgumentException("maxDeviation must be <= 0.4");
        }
        if (f3 < 0.0f) {
            throw new IllegalArgumentException("slowDownFactor must be >= 0");
        }
        if (f4 > 0.0f) {
            throw new IllegalArgumentException("accelerationFactor must be <= 0");
        }
        this.maxDeviation = f2;
        this.accelerationFactor = f4 + 1.0f;
        this.slowDownFactor = f3 + 1.0f;
    }

    private void computeDeviationCumulativeBytes() {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = Long.MAX_VALUE;
        long l5 = Long.MAX_VALUE;
        for (GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel : this.channelQueues.values()) {
            long l6 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.cumulativeWrittenBytes();
            if (l2 < l6) {
                l2 = l6;
            }
            if (l4 > l6) {
                l4 = l6;
            }
            if (l3 < (l6 = globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.cumulativeReadBytes())) {
                l3 = l6;
            }
            if (l5 <= l6) continue;
            l5 = l6;
        }
        boolean bl = this.channelQueues.size() > 1;
        this.readDeviationActive = bl && l5 < l3 / 2L;
        this.writeDeviationActive = bl && l4 < l2 / 2L;
        this.cumulativeWrittenBytes.set(l2);
        this.cumulativeReadBytes.set(l3);
    }

    @Override
    protected void doAccounting(TrafficCounter trafficCounter) {
        this.computeDeviationCumulativeBytes();
        super.doAccounting(trafficCounter);
    }

    private long computeBalancedWait(float f2, float f3, long l2) {
        float f4;
        if (f3 == 0.0f) {
            return l2;
        }
        f2 /= f3;
        if (f4 > this.maxDeviation) {
            if (f2 < 1.0f - this.maxDeviation) {
                return l2;
            }
            f2 = this.slowDownFactor;
            if (l2 < 10L) {
                l2 = 10L;
            }
        } else {
            f2 = this.accelerationFactor;
        }
        return (long)((float)l2 * f2);
    }

    public long getMaxGlobalWriteSize() {
        return this.maxGlobalWriteSize;
    }

    public void setMaxGlobalWriteSize(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("maxGlobalWriteSize must be positive");
        }
        this.maxGlobalWriteSize = l2;
    }

    public long queuesSize() {
        return this.queuesSize.get();
    }

    public void configureChannel(long l2, long l3) {
        this.writeChannelLimit = l2;
        this.readChannelLimit = l3;
        long l4 = TrafficCounter.milliSecondFromNano();
        for (GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel : this.channelQueues.values()) {
            globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.resetAccounting(l4);
        }
    }

    public long getWriteChannelLimit() {
        return this.writeChannelLimit;
    }

    public void setWriteChannelLimit(long l2) {
        this.writeChannelLimit = l2;
        long l3 = TrafficCounter.milliSecondFromNano();
        for (GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel : this.channelQueues.values()) {
            globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.resetAccounting(l3);
        }
    }

    public long getReadChannelLimit() {
        return this.readChannelLimit;
    }

    public void setReadChannelLimit(long l2) {
        this.readChannelLimit = l2;
        long l3 = TrafficCounter.milliSecondFromNano();
        for (GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel : this.channelQueues.values()) {
            globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.resetAccounting(l3);
        }
    }

    public final void release() {
        this.trafficCounter.stop();
    }

    private GlobalChannelTrafficShapingHandler$PerChannel getOrSetPerChannel(ChannelHandlerContext channelHandlerContext) {
        Comparable<Channel> comparable = channelHandlerContext.channel();
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(comparable = Integer.valueOf(comparable.hashCode()));
        if (globalChannelTrafficShapingHandler$PerChannel == null) {
            globalChannelTrafficShapingHandler$PerChannel = new GlobalChannelTrafficShapingHandler$PerChannel();
            new GlobalChannelTrafficShapingHandler$PerChannel().messagesQueue = new ArrayDeque();
            globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter = new TrafficCounter(this, null, "ChannelTC" + channelHandlerContext.channel().hashCode(), this.checkInterval);
            globalChannelTrafficShapingHandler$PerChannel.queueSize = 0L;
            globalChannelTrafficShapingHandler$PerChannel.lastWriteTimestamp = globalChannelTrafficShapingHandler$PerChannel.lastReadTimestamp = TrafficCounter.milliSecondFromNano();
            this.channelQueues.put((Integer)comparable, globalChannelTrafficShapingHandler$PerChannel);
        }
        return globalChannelTrafficShapingHandler$PerChannel;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.getOrSetPerChannel(channelHandlerContext);
        this.trafficCounter.resetCumulativeTime();
        super.handlerAdded(channelHandlerContext);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.trafficCounter.resetCumulativeTime();
        Iterator<GlobalChannelTrafficShapingHandler$ToSend> iterator = channelHandlerContext.channel();
        Object object = iterator.hashCode();
        object = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.remove(object);
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                if (iterator.isActive()) {
                    for (GlobalChannelTrafficShapingHandler$ToSend globalChannelTrafficShapingHandler$ToSend : ((GlobalChannelTrafficShapingHandler$PerChannel)object).messagesQueue) {
                        long l2 = this.calculateSize(globalChannelTrafficShapingHandler$ToSend.toSend);
                        this.trafficCounter.bytesRealWriteFlowControl(l2);
                        ((GlobalChannelTrafficShapingHandler$PerChannel)object).channelTrafficCounter.bytesRealWriteFlowControl(l2);
                        ((GlobalChannelTrafficShapingHandler$PerChannel)object).queueSize -= l2;
                        this.queuesSize.addAndGet(-l2);
                        channelHandlerContext.write(globalChannelTrafficShapingHandler$ToSend.toSend, globalChannelTrafficShapingHandler$ToSend.promise);
                    }
                } else {
                    this.queuesSize.addAndGet(-((GlobalChannelTrafficShapingHandler$PerChannel)object).queueSize);
                    for (GlobalChannelTrafficShapingHandler$ToSend globalChannelTrafficShapingHandler$ToSend : ((GlobalChannelTrafficShapingHandler$PerChannel)object).messagesQueue) {
                        if (!(globalChannelTrafficShapingHandler$ToSend.toSend instanceof ByteBuf)) continue;
                        ((ByteBuf)globalChannelTrafficShapingHandler$ToSend.toSend).release();
                    }
                }
                ((GlobalChannelTrafficShapingHandler$PerChannel)object).messagesQueue.clear();
            }
        }
        this.releaseWriteSuspended(channelHandlerContext);
        this.releaseReadSuspended(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        long l2 = this.calculateSize(object);
        long l3 = TrafficCounter.milliSecondFromNano();
        if (l2 > 0L) {
            long l4 = this.trafficCounter.readTimeToWait(l2, this.getReadLimit(), this.maxTime, l3);
            Object object2 = channelHandlerContext.channel().hashCode();
            object2 = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(object2);
            long l5 = 0L;
            if (object2 != null) {
                l5 = ((GlobalChannelTrafficShapingHandler$PerChannel)object2).channelTrafficCounter.readTimeToWait(l2, this.readChannelLimit, this.maxTime, l3);
                if (this.readDeviationActive) {
                    long l6 = ((GlobalChannelTrafficShapingHandler$PerChannel)object2).channelTrafficCounter.cumulativeReadBytes();
                    long l7 = this.cumulativeReadBytes.get();
                    if (l6 <= 0L) {
                        l6 = 0L;
                    }
                    if (l7 < l6) {
                        l7 = l6;
                    }
                    l5 = this.computeBalancedWait(l6, l7, l5);
                }
            }
            if (l5 < l4) {
                l5 = l4;
            }
            if ((l5 = this.checkWaitReadTime(channelHandlerContext, l5, l3)) >= 10L) {
                ChannelConfig channelConfig = channelHandlerContext.channel().config();
                if (logger.isDebugEnabled()) {
                    logger.debug("Read Suspend: " + l5 + ':' + channelConfig.isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext));
                }
                if (channelConfig.isAutoRead() && GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext)) {
                    channelConfig.setAutoRead(false);
                    channelHandlerContext.attr(READ_SUSPENDED).set(Boolean.TRUE);
                    Attribute<Runnable> attribute = channelHandlerContext.attr(REOPEN_TASK);
                    Runnable runnable = (Runnable)attribute.get();
                    if (runnable == null) {
                        runnable = new AbstractTrafficShapingHandler$ReopenReadTimerTask(channelHandlerContext);
                        attribute.set(runnable);
                    }
                    channelHandlerContext.executor().schedule(runnable, l5, TimeUnit.MILLISECONDS);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Suspend final status => " + channelConfig.isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext) + " will reopened at: " + l5);
                    }
                }
            }
        }
        this.informReadOperation(channelHandlerContext, l3);
        channelHandlerContext.fireChannelRead(object);
    }

    @Override
    protected long checkWaitReadTime(ChannelHandlerContext object, long l2, long l3) {
        object = object.channel().hashCode();
        if ((object = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(object)) != null && l2 > this.maxTime && l3 + l2 - ((GlobalChannelTrafficShapingHandler$PerChannel)object).lastReadTimestamp > this.maxTime) {
            l2 = this.maxTime;
        }
        return l2;
    }

    @Override
    protected void informReadOperation(ChannelHandlerContext object, long l2) {
        object = object.channel().hashCode();
        if ((object = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(object)) != null) {
            ((GlobalChannelTrafficShapingHandler$PerChannel)object).lastReadTimestamp = l2;
        }
    }

    protected long maximumCumulativeWrittenBytes() {
        return this.cumulativeWrittenBytes.get();
    }

    protected long maximumCumulativeReadBytes() {
        return this.cumulativeReadBytes.get();
    }

    public Collection<TrafficCounter> channelTrafficCounters() {
        return new GlobalChannelTrafficShapingHandler$1(this);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        long l2 = this.calculateSize(object);
        long l3 = TrafficCounter.milliSecondFromNano();
        if (l2 > 0L) {
            long l4 = this.trafficCounter.writeTimeToWait(l2, this.getWriteLimit(), this.maxTime, l3);
            Object object2 = channelHandlerContext.channel().hashCode();
            object2 = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(object2);
            long l5 = 0L;
            if (object2 != null) {
                l5 = ((GlobalChannelTrafficShapingHandler$PerChannel)object2).channelTrafficCounter.writeTimeToWait(l2, this.writeChannelLimit, this.maxTime, l3);
                if (this.writeDeviationActive) {
                    long l6 = ((GlobalChannelTrafficShapingHandler$PerChannel)object2).channelTrafficCounter.cumulativeWrittenBytes();
                    long l7 = this.cumulativeWrittenBytes.get();
                    if (l6 <= 0L) {
                        l6 = 0L;
                    }
                    if (l7 < l6) {
                        l7 = l6;
                    }
                    l5 = this.computeBalancedWait(l6, l7, l5);
                }
            }
            if (l5 < l4) {
                l5 = l4;
            }
            if (l5 >= 10L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Write suspend: " + l5 + ':' + channelHandlerContext.channel().config().isAutoRead() + ':' + GlobalChannelTrafficShapingHandler.isHandlerActive(channelHandlerContext));
                }
                this.submitWrite(channelHandlerContext, object, l2, l5, l3, channelPromise);
                return;
            }
        }
        this.submitWrite(channelHandlerContext, object, l2, 0L, l3, channelPromise);
    }

    @Override
    protected void submitWrite(ChannelHandlerContext channelHandlerContext, Object object, long l2, long l3, long l4, ChannelPromise channelPromise) {
        Object object2 = channelHandlerContext.channel();
        object2 = object2.hashCode();
        if ((object2 = (GlobalChannelTrafficShapingHandler$PerChannel)this.channelQueues.get(object2)) == null) {
            object2 = this.getOrSetPerChannel(channelHandlerContext);
        }
        long l5 = l3;
        boolean bl = false;
        Object object3 = object2;
        synchronized (object3) {
            if (l3 == 0L && ((GlobalChannelTrafficShapingHandler$PerChannel)object2).messagesQueue.isEmpty()) {
                this.trafficCounter.bytesRealWriteFlowControl(l2);
                ((GlobalChannelTrafficShapingHandler$PerChannel)object2).channelTrafficCounter.bytesRealWriteFlowControl(l2);
                channelHandlerContext.write(object, channelPromise);
                ((GlobalChannelTrafficShapingHandler$PerChannel)object2).lastWriteTimestamp = l4;
                return;
            }
            if (l3 > this.maxTime && l4 + l3 - ((GlobalChannelTrafficShapingHandler$PerChannel)object2).lastWriteTimestamp > this.maxTime) {
                l5 = this.maxTime;
            }
            object = new GlobalChannelTrafficShapingHandler$ToSend(l5 + l4, object, l2, channelPromise, null);
            ((GlobalChannelTrafficShapingHandler$PerChannel)object2).messagesQueue.addLast((GlobalChannelTrafficShapingHandler$ToSend)object);
            ((GlobalChannelTrafficShapingHandler$PerChannel)object2).queueSize += l2;
            this.queuesSize.addAndGet(l2);
            this.checkWriteSuspend(channelHandlerContext, l5, ((GlobalChannelTrafficShapingHandler$PerChannel)object2).queueSize);
            if (this.queuesSize.get() > this.maxGlobalWriteSize) {
                bl = true;
            }
        }
        if (bl) {
            this.setUserDefinedWritability(channelHandlerContext, false);
        }
        long l6 = ((GlobalChannelTrafficShapingHandler$ToSend)object).relativeTimeAction;
        object = object2;
        channelHandlerContext.executor().schedule(new GlobalChannelTrafficShapingHandler$2(this, channelHandlerContext, (GlobalChannelTrafficShapingHandler$PerChannel)object, l6), l5, TimeUnit.MILLISECONDS);
    }

    private void sendAllValid(ChannelHandlerContext channelHandlerContext, GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel, long l2) {
        GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel2 = globalChannelTrafficShapingHandler$PerChannel;
        synchronized (globalChannelTrafficShapingHandler$PerChannel2) {
            GlobalChannelTrafficShapingHandler$ToSend globalChannelTrafficShapingHandler$ToSend = globalChannelTrafficShapingHandler$PerChannel.messagesQueue.pollFirst();
            while (globalChannelTrafficShapingHandler$ToSend != null) {
                long l3;
                if (globalChannelTrafficShapingHandler$ToSend.relativeTimeAction <= l2) {
                    l3 = globalChannelTrafficShapingHandler$ToSend.size;
                    this.trafficCounter.bytesRealWriteFlowControl(l3);
                    globalChannelTrafficShapingHandler$PerChannel.channelTrafficCounter.bytesRealWriteFlowControl(l3);
                    globalChannelTrafficShapingHandler$PerChannel.queueSize -= l3;
                } else {
                    globalChannelTrafficShapingHandler$PerChannel.messagesQueue.addFirst(globalChannelTrafficShapingHandler$ToSend);
                    break;
                }
                this.queuesSize.addAndGet(-l3);
                channelHandlerContext.write(globalChannelTrafficShapingHandler$ToSend.toSend, globalChannelTrafficShapingHandler$ToSend.promise);
                globalChannelTrafficShapingHandler$PerChannel.lastWriteTimestamp = l2;
                globalChannelTrafficShapingHandler$ToSend = globalChannelTrafficShapingHandler$PerChannel.messagesQueue.pollFirst();
            }
            if (globalChannelTrafficShapingHandler$PerChannel.messagesQueue.isEmpty()) {
                this.releaseWriteSuspended(channelHandlerContext);
            }
        }
        channelHandlerContext.flush();
    }

    @Override
    public String toString() {
        return new StringBuilder(340).append(super.toString()).append(" Write Channel Limit: ").append(this.writeChannelLimit).append(" Read Channel Limit: ").append(this.readChannelLimit).toString();
    }

    static /* synthetic */ void access$100(GlobalChannelTrafficShapingHandler globalChannelTrafficShapingHandler, ChannelHandlerContext channelHandlerContext, GlobalChannelTrafficShapingHandler$PerChannel globalChannelTrafficShapingHandler$PerChannel, long l2) {
        globalChannelTrafficShapingHandler.sendAllValid(channelHandlerContext, globalChannelTrafficShapingHandler$PerChannel, l2);
    }
}

