/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.traffic;

import com.aliyun.openservices.shade.io.netty.handler.traffic.AbstractTrafficShapingHandler;
import com.aliyun.openservices.shade.io.netty.handler.traffic.TrafficCounter$TrafficMonitoringTask;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TrafficCounter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(TrafficCounter.class);
    private final AtomicLong currentWrittenBytes = new AtomicLong();
    private final AtomicLong currentReadBytes = new AtomicLong();
    private long writingTime;
    private long readingTime;
    private final AtomicLong cumulativeWrittenBytes = new AtomicLong();
    private final AtomicLong cumulativeReadBytes = new AtomicLong();
    private long lastCumulativeTime;
    private long lastWriteThroughput;
    private long lastReadThroughput;
    final AtomicLong lastTime = new AtomicLong();
    private volatile long lastWrittenBytes;
    private volatile long lastReadBytes;
    private volatile long lastWritingTime;
    private volatile long lastReadingTime;
    private final AtomicLong realWrittenBytes = new AtomicLong();
    private long realWriteThroughput;
    final AtomicLong checkInterval = new AtomicLong(1000L);
    final String name;
    final AbstractTrafficShapingHandler trafficShapingHandler;
    final ScheduledExecutorService executor;
    Runnable monitor;
    volatile ScheduledFuture<?> scheduledFuture;
    volatile boolean monitorActive;

    public static long milliSecondFromNano() {
        return System.nanoTime() / 1000000L;
    }

    public synchronized void start() {
        if (this.monitorActive) {
            return;
        }
        this.lastTime.set(TrafficCounter.milliSecondFromNano());
        long l2 = this.checkInterval.get();
        if (l2 > 0L && this.executor != null) {
            this.monitorActive = true;
            this.monitor = new TrafficCounter$TrafficMonitoringTask(this, null);
            this.scheduledFuture = this.executor.schedule(this.monitor, l2, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stop() {
        if (!this.monitorActive) {
            return;
        }
        this.monitorActive = false;
        this.resetAccounting(TrafficCounter.milliSecondFromNano());
        if (this.trafficShapingHandler != null) {
            this.trafficShapingHandler.doAccounting(this);
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    synchronized void resetAccounting(long l2) {
        long l3 = l2 - this.lastTime.getAndSet(l2);
        if (l3 == 0L) {
            return;
        }
        if (logger.isDebugEnabled() && l3 > this.checkInterval() << 1) {
            logger.debug("Acct schedule not ok: " + l3 + " > 2*" + this.checkInterval() + " from " + this.name);
        }
        this.lastReadBytes = this.currentReadBytes.getAndSet(0L);
        this.lastWrittenBytes = this.currentWrittenBytes.getAndSet(0L);
        this.lastReadThroughput = this.lastReadBytes * 1000L / l3;
        this.lastWriteThroughput = this.lastWrittenBytes * 1000L / l3;
        this.realWriteThroughput = this.realWrittenBytes.getAndSet(0L) * 1000L / l3;
        this.lastWritingTime = Math.max(this.lastWritingTime, this.writingTime);
        this.lastReadingTime = Math.max(this.lastReadingTime, this.readingTime);
    }

    public TrafficCounter(ScheduledExecutorService scheduledExecutorService, String string, long l2) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.trafficShapingHandler = null;
        this.executor = scheduledExecutorService;
        this.name = string;
        this.init(l2);
    }

    public TrafficCounter(AbstractTrafficShapingHandler abstractTrafficShapingHandler, ScheduledExecutorService scheduledExecutorService, String string, long l2) {
        if (abstractTrafficShapingHandler == null) {
            throw new IllegalArgumentException("trafficShapingHandler");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.trafficShapingHandler = abstractTrafficShapingHandler;
        this.executor = scheduledExecutorService;
        this.name = string;
        this.init(l2);
    }

    private void init(long l2) {
        this.lastCumulativeTime = System.currentTimeMillis();
        this.readingTime = this.writingTime = TrafficCounter.milliSecondFromNano();
        this.lastWritingTime = this.writingTime;
        this.lastReadingTime = this.writingTime;
        this.configure(l2);
    }

    public void configure(long l2) {
        long l3 = l2 / 10L * 10L;
        if (this.checkInterval.getAndSet(l3) != l3) {
            if (l3 <= 0L) {
                this.stop();
                this.lastTime.set(TrafficCounter.milliSecondFromNano());
                return;
            }
            this.start();
        }
    }

    void bytesRecvFlowControl(long l2) {
        this.currentReadBytes.addAndGet(l2);
        this.cumulativeReadBytes.addAndGet(l2);
    }

    void bytesWriteFlowControl(long l2) {
        this.currentWrittenBytes.addAndGet(l2);
        this.cumulativeWrittenBytes.addAndGet(l2);
    }

    void bytesRealWriteFlowControl(long l2) {
        this.realWrittenBytes.addAndGet(l2);
    }

    public long checkInterval() {
        return this.checkInterval.get();
    }

    public long lastReadThroughput() {
        return this.lastReadThroughput;
    }

    public long lastWriteThroughput() {
        return this.lastWriteThroughput;
    }

    public long lastReadBytes() {
        return this.lastReadBytes;
    }

    public long lastWrittenBytes() {
        return this.lastWrittenBytes;
    }

    public long currentReadBytes() {
        return this.currentReadBytes.get();
    }

    public long currentWrittenBytes() {
        return this.currentWrittenBytes.get();
    }

    public long lastTime() {
        return this.lastTime.get();
    }

    public long cumulativeWrittenBytes() {
        return this.cumulativeWrittenBytes.get();
    }

    public long cumulativeReadBytes() {
        return this.cumulativeReadBytes.get();
    }

    public long lastCumulativeTime() {
        return this.lastCumulativeTime;
    }

    public AtomicLong getRealWrittenBytes() {
        return this.realWrittenBytes;
    }

    public long getRealWriteThroughput() {
        return this.realWriteThroughput;
    }

    public void resetCumulativeTime() {
        this.lastCumulativeTime = System.currentTimeMillis();
        this.cumulativeReadBytes.set(0L);
        this.cumulativeWrittenBytes.set(0L);
    }

    public String name() {
        return this.name;
    }

    @Deprecated
    public long readTimeToWait(long l2, long l3, long l4) {
        return this.readTimeToWait(l2, l3, l4, TrafficCounter.milliSecondFromNano());
    }

    public long readTimeToWait(long l2, long l3, long l4, long l5) {
        this.bytesRecvFlowControl(l2);
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        long l6 = this.lastTime.get();
        long l7 = this.currentReadBytes.get();
        long l8 = this.readingTime;
        long l9 = this.lastReadBytes;
        long l10 = l5 - l6;
        long l11 = Math.max(this.lastReadingTime - l6, 0L);
        if (l10 > 10L) {
            long l12 = l7 * 1000L / l3 - l10 + l11;
            if (l12 > 10L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Time: " + l12 + ':' + l7 + ':' + l10 + ':' + l11);
                }
                if (l12 > l4 && l5 + l12 - l8 > l4) {
                    l12 = l4;
                }
                this.readingTime = Math.max(l8, l5 + l12);
                return l12;
            }
            this.readingTime = Math.max(l8, l5);
            return 0L;
        }
        long l13 = l7 + l9;
        long l14 = l10 + this.checkInterval.get();
        long l15 = l13 * 1000L / l3 - l14 + l11;
        if (l15 > 10L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Time: " + l15 + ':' + l13 + ':' + l14 + ':' + l11);
            }
            if (l15 > l4 && l5 + l15 - l8 > l4) {
                l15 = l4;
            }
            this.readingTime = Math.max(l8, l5 + l15);
            return l15;
        }
        this.readingTime = Math.max(l8, l5);
        return 0L;
    }

    @Deprecated
    public long writeTimeToWait(long l2, long l3, long l4) {
        return this.writeTimeToWait(l2, l3, l4, TrafficCounter.milliSecondFromNano());
    }

    public long writeTimeToWait(long l2, long l3, long l4, long l5) {
        this.bytesWriteFlowControl(l2);
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        long l6 = this.lastTime.get();
        long l7 = this.currentWrittenBytes.get();
        long l8 = this.lastWrittenBytes;
        long l9 = this.writingTime;
        long l10 = Math.max(this.lastWritingTime - l6, 0L);
        long l11 = l5 - l6;
        if (l11 > 10L) {
            long l12 = l7 * 1000L / l3 - l11 + l10;
            if (l12 > 10L) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Time: " + l12 + ':' + l7 + ':' + l11 + ':' + l10);
                }
                if (l12 > l4 && l5 + l12 - l9 > l4) {
                    l12 = l4;
                }
                this.writingTime = Math.max(l9, l5 + l12);
                return l12;
            }
            this.writingTime = Math.max(l9, l5);
            return 0L;
        }
        long l13 = l7 + l8;
        long l14 = l11 + this.checkInterval.get();
        long l15 = l13 * 1000L / l3 - l14 + l10;
        if (l15 > 10L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Time: " + l15 + ':' + l13 + ':' + l14 + ':' + l10);
            }
            if (l15 > l4 && l5 + l15 - l9 > l4) {
                l15 = l4;
            }
            this.writingTime = Math.max(l9, l5 + l15);
            return l15;
        }
        this.writingTime = Math.max(l9, l5);
        return 0L;
    }

    public String toString() {
        return new StringBuilder(165).append("Monitor ").append(this.name).append(" Current Speed Read: ").append(this.lastReadThroughput >> 10).append(" KB/s, Asked Write: ").append(this.lastWriteThroughput >> 10).append(" KB/s, Real Write: ").append(this.realWriteThroughput >> 10).append(" KB/s, Current Read: ").append(this.currentReadBytes.get() >> 10).append(" KB, Current asked Write: ").append(this.currentWrittenBytes.get() >> 10).append(" KB, Current real Write: ").append(this.realWrittenBytes.get() >> 10).append(" KB").toString();
    }
}

