/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util;

import com.aliyun.openservices.shade.io.netty.util.Mapping;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.net.IDN;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class DomainNameMapping<V>
implements Mapping<String, V> {
    final V defaultValue;
    private final Map<String, V> map;
    private final Map<String, V> unmodifiableMap;

    @Deprecated
    public DomainNameMapping(V v2) {
        this(4, v2);
    }

    @Deprecated
    public DomainNameMapping(int n2, V v2) {
        this(new LinkedHashMap(n2), v2);
    }

    DomainNameMapping(Map<String, V> map, V v2) {
        this.defaultValue = ObjectUtil.checkNotNull(v2, "defaultValue");
        this.map = map;
        this.unmodifiableMap = map != null ? Collections.unmodifiableMap(map) : null;
    }

    @Deprecated
    public DomainNameMapping<V> add(String string, V v2) {
        this.map.put(DomainNameMapping.normalizeHostname(ObjectUtil.checkNotNull(string, "hostname")), ObjectUtil.checkNotNull(v2, "output"));
        return this;
    }

    static boolean matches(String string, String string2) {
        block2: {
            block4: {
                block3: {
                    if (!string.startsWith("*.")) break block2;
                    if (string.regionMatches(2, string2, 0, string2.length())) break block3;
                    String string3 = string;
                    if (!StringUtil.commonSuffixOfLength(string2, string3, string3.length() - 1)) break block4;
                }
                return true;
            }
            return false;
        }
        return string.equals(string2);
    }

    static String normalizeHostname(String string) {
        if (DomainNameMapping.needsNormalization(string)) {
            string = IDN.toASCII(string, 1);
        }
        return string.toLowerCase(Locale.US);
    }

    private static boolean needsNormalization(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= '\u007f') continue;
            return true;
        }
        return false;
    }

    @Override
    public V map(String string) {
        if (string != null) {
            string = DomainNameMapping.normalizeHostname(string);
            for (Map.Entry<String, V> entry : this.map.entrySet()) {
                if (!DomainNameMapping.matches(entry.getKey(), string)) continue;
                return entry.getValue();
            }
        }
        return this.defaultValue;
    }

    public Map<String, V> asMap() {
        return this.unmodifiableMap;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + "(default: " + this.defaultValue + ", map: " + this.map + ')';
    }
}

