/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util;

import com.aliyun.openservices.shade.io.netty.util.HashedWheelTimer$HashedWheelBucket;
import com.aliyun.openservices.shade.io.netty.util.HashedWheelTimer$HashedWheelTimeout;
import com.aliyun.openservices.shade.io.netty.util.HashedWheelTimer$Worker;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeak;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeakDetector;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeakDetectorFactory;
import com.aliyun.openservices.shade.io.netty.util.Timeout;
import com.aliyun.openservices.shade.io.netty.util.Timer;
import com.aliyun.openservices.shade.io.netty.util.TimerTask;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class HashedWheelTimer
implements Timer {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(HashedWheelTimer.class);
    private static final ResourceLeakDetector<HashedWheelTimer> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(HashedWheelTimer.class, 1, (long)Runtime.getRuntime().availableProcessors() << 2);
    private static final AtomicIntegerFieldUpdater<HashedWheelTimer> WORKER_STATE_UPDATER;
    private final ResourceLeak leak;
    private final HashedWheelTimer$Worker worker = new HashedWheelTimer$Worker(this, null);
    private final Thread workerThread;
    public static final int WORKER_STATE_INIT = 0;
    public static final int WORKER_STATE_STARTED = 1;
    public static final int WORKER_STATE_SHUTDOWN = 2;
    private volatile int workerState = 0;
    private final long tickDuration;
    private final HashedWheelTimer$HashedWheelBucket[] wheel;
    private final int mask;
    private final CountDownLatch startTimeInitialized = new CountDownLatch(1);
    private final Queue<HashedWheelTimer$HashedWheelTimeout> timeouts = PlatformDependent.newMpscQueue();
    private final Queue<HashedWheelTimer$HashedWheelTimeout> cancelledTimeouts = PlatformDependent.newMpscQueue();
    private volatile long startTime;

    public HashedWheelTimer() {
        this(Executors.defaultThreadFactory());
    }

    public HashedWheelTimer(long l2, TimeUnit timeUnit) {
        this(Executors.defaultThreadFactory(), l2, timeUnit);
    }

    public HashedWheelTimer(long l2, TimeUnit timeUnit, int n2) {
        this(Executors.defaultThreadFactory(), l2, timeUnit, n2);
    }

    public HashedWheelTimer(ThreadFactory threadFactory) {
        this(threadFactory, 100L, TimeUnit.MILLISECONDS);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l2, TimeUnit timeUnit) {
        this(threadFactory, l2, timeUnit, 512);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l2, TimeUnit timeUnit, int n2) {
        this(threadFactory, l2, timeUnit, n2, true);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long l2, TimeUnit timeUnit, int n2, boolean bl) {
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("tickDuration must be greater than 0: " + l2);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("ticksPerWheel must be greater than 0: " + n2);
        }
        this.wheel = HashedWheelTimer.createWheel(n2);
        this.mask = this.wheel.length - 1;
        this.tickDuration = timeUnit.toNanos(l2);
        if (this.tickDuration >= Long.MAX_VALUE / (long)this.wheel.length) {
            throw new IllegalArgumentException(String.format("tickDuration: %d (expected: 0 < tickDuration in nanos < %d", l2, Long.MAX_VALUE / (long)this.wheel.length));
        }
        this.workerThread = threadFactory.newThread(this.worker);
        this.leak = bl || !this.workerThread.isDaemon() ? leakDetector.open(this) : null;
    }

    private static HashedWheelTimer$HashedWheelBucket[] createWheel(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("ticksPerWheel must be greater than 0: " + n2);
        }
        if (n2 > 0x40000000) {
            throw new IllegalArgumentException("ticksPerWheel may not be greater than 2^30: " + n2);
        }
        n2 = HashedWheelTimer.normalizeTicksPerWheel(n2);
        HashedWheelTimer$HashedWheelBucket[] hashedWheelTimer$HashedWheelBucketArray = new HashedWheelTimer$HashedWheelBucket[n2];
        for (int i2 = 0; i2 < hashedWheelTimer$HashedWheelBucketArray.length; ++i2) {
            hashedWheelTimer$HashedWheelBucketArray[i2] = new HashedWheelTimer$HashedWheelBucket(null);
        }
        return hashedWheelTimer$HashedWheelBucketArray;
    }

    private static int normalizeTicksPerWheel(int n2) {
        int n3;
        for (n3 = 1; n3 < n2; n3 <<= 1) {
        }
        return n3;
    }

    public void start() {
        switch (WORKER_STATE_UPDATER.get(this)) {
            case 0: {
                if (!WORKER_STATE_UPDATER.compareAndSet(this, 0, 1)) break;
                this.workerThread.start();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                throw new IllegalStateException("cannot be started once stopped");
            }
            default: {
                throw new Error("Invalid WorkerState");
            }
        }
        while (this.startTime == 0L) {
            try {
                this.startTimeInitialized.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public Set<Timeout> stop() {
        if (Thread.currentThread() == this.workerThread) {
            throw new IllegalStateException(HashedWheelTimer.class.getSimpleName() + ".stop() cannot be called from " + TimerTask.class.getSimpleName());
        }
        if (!WORKER_STATE_UPDATER.compareAndSet(this, 1, 2)) {
            WORKER_STATE_UPDATER.set(this, 2);
            if (this.leak != null) {
                this.leak.close();
            }
            return Collections.emptySet();
        }
        boolean bl = false;
        while (this.workerThread.isAlive()) {
            this.workerThread.interrupt();
            try {
                this.workerThread.join(100L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        if (this.leak != null) {
            this.leak.close();
        }
        return this.worker.unprocessedTimeouts();
    }

    @Override
    public Timeout newTimeout(TimerTask object, long l2, TimeUnit timeUnit) {
        if (object == null) {
            throw new NullPointerException("task");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit");
        }
        this.start();
        long l3 = System.nanoTime() + timeUnit.toNanos(l2) - this.startTime;
        object = new HashedWheelTimer$HashedWheelTimeout(this, (TimerTask)object, l3);
        this.timeouts.add((HashedWheelTimer$HashedWheelTimeout)object);
        return object;
    }

    static /* synthetic */ long access$202(HashedWheelTimer hashedWheelTimer, long l2) {
        hashedWheelTimer.startTime = l2;
        return hashedWheelTimer.startTime;
    }

    static /* synthetic */ long access$200(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.startTime;
    }

    static /* synthetic */ CountDownLatch access$300(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.startTimeInitialized;
    }

    static /* synthetic */ int access$400(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.mask;
    }

    static /* synthetic */ HashedWheelTimer$HashedWheelBucket[] access$500(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.wheel;
    }

    static /* synthetic */ AtomicIntegerFieldUpdater access$600() {
        return WORKER_STATE_UPDATER;
    }

    static /* synthetic */ Queue access$700(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.timeouts;
    }

    static /* synthetic */ long access$900(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.tickDuration;
    }

    static /* synthetic */ Queue access$1000(HashedWheelTimer hashedWheelTimer) {
        return hashedWheelTimer.cancelledTimeouts;
    }

    static {
        AtomicIntegerFieldUpdater<HashedWheelTimer> atomicIntegerFieldUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(HashedWheelTimer.class, "workerState");
        if (atomicIntegerFieldUpdater == null) {
            atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(HashedWheelTimer.class, "workerState");
        }
        WORKER_STATE_UPDATER = atomicIntegerFieldUpdater;
    }
}

