/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util;

import com.aliyun.openservices.shade.io.netty.util.NetUtil$1;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class NetUtil {
    public static final Inet4Address LOCALHOST4;
    public static final Inet6Address LOCALHOST6;
    public static final InetAddress LOCALHOST;
    public static final NetworkInterface LOOPBACK_IF;
    public static final int SOMAXCONN;
    private static final int IPV6_WORD_COUNT = 8;
    private static final int IPV6_MAX_CHAR_COUNT = 39;
    private static final int IPV6_BYTE_COUNT = 16;
    private static final int IPV6_MAX_CHAR_BETWEEN_SEPARATOR = 4;
    private static final int IPV6_MIN_SEPARATORS = 2;
    private static final int IPV6_MAX_SEPARATORS = 8;
    private static final int IPV4_BYTE_COUNT = 4;
    private static final int IPV4_MAX_CHAR_BETWEEN_SEPARATOR = 3;
    private static final int IPV4_SEPARATORS = 3;
    private static final boolean IPV4_PREFERRED;
    private static final InternalLogger logger;

    public static boolean isIpV4StackPreferred() {
        return IPV4_PREFERRED;
    }

    public static byte[] createByteArrayFromIpAddressString(String arrayList) {
        if (NetUtil.isValidIpV4Address((String)((Object)arrayList))) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)((Object)arrayList), ".");
            arrayList = (ArrayList<String>)new byte[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                String string = stringTokenizer.nextToken();
                int n2 = Integer.parseInt(string);
                arrayList[i2] = (byte)n2;
            }
            return arrayList;
        }
        if (NetUtil.isValidIpV6Address((String)((Object)arrayList))) {
            int n3;
            int n4;
            if (((String)((Object)arrayList)).charAt(0) == '[') {
                arrayList = ((String)((Object)arrayList)).substring(1, ((String)((Object)arrayList)).length() - 1);
            }
            if ((n4 = ((String)((Object)arrayList)).indexOf(37)) >= 0) {
                arrayList = ((String)((Object)arrayList)).substring(0, n4);
            }
            StringTokenizer stringTokenizer = new StringTokenizer((String)((Object)arrayList), ":.", true);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList = new ArrayList<String>();
            String string = "";
            String string2 = "";
            int n5 = -1;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string;
                string = stringTokenizer.nextToken();
                if (":".equals(string)) {
                    if (":".equals(string2)) {
                        n5 = arrayList2.size();
                        continue;
                    }
                    if (string2.isEmpty()) continue;
                    arrayList2.add(string2);
                    continue;
                }
                if (!".".equals(string)) continue;
                arrayList.add(string2);
            }
            if (":".equals(string2)) {
                if (":".equals(string)) {
                    n5 = arrayList2.size();
                } else {
                    arrayList2.add(string);
                }
            } else if (".".equals(string2)) {
                arrayList.add(string);
            }
            int n6 = 8;
            if (!arrayList.isEmpty()) {
                n6 -= 2;
            }
            if (n5 != -1) {
                n6 -= arrayList2.size();
                for (int i3 = 0; i3 < n6; ++i3) {
                    arrayList2.add(n5, "0");
                }
            }
            byte[] byArray = new byte[16];
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                NetUtil.convertToBytes((String)arrayList2.get(n3), byArray, n3 << 1);
            }
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                byArray[n3 + 12] = (byte)Integer.parseInt((String)arrayList.get(n3));
            }
            return byArray;
        }
        return null;
    }

    private static void convertToBytes(String string, byte[] byArray, int n2) {
        int n3;
        int n4 = string.length();
        int n5 = 0;
        byArray[n2] = 0;
        byArray[n2 + 1] = 0;
        if (n4 > 3) {
            ++n5;
            n3 = NetUtil.getIntValue(string.charAt(0));
            int n6 = n2;
            byArray[n6] = (byte)(byArray[n6] | n3 << 4);
        }
        if (n4 > 2) {
            n3 = NetUtil.getIntValue(string.charAt(n5++));
            int n7 = n2;
            byArray[n7] = (byte)(byArray[n7] | n3);
        }
        if (n4 > 1) {
            n3 = NetUtil.getIntValue(string.charAt(n5++));
            int n8 = n2 + 1;
            byArray[n8] = (byte)(byArray[n8] | n3 << 4);
        }
        n3 = NetUtil.getIntValue(string.charAt(n5));
        int n9 = n2 + 1;
        byArray[n9] = (byte)(byArray[n9] | n3 & 0xF);
    }

    static int getIntValue(char c2) {
        switch (c2) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        c2 = Character.toLowerCase(c2);
        switch (c2) {
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    public static boolean isValidIpV6Address(String string) {
        int n2;
        int n3 = string.length();
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        char c2 = '\u0000';
        int n6 = 0;
        int n7 = string.length();
        if (n7 < 2) {
            return false;
        }
        if (string.charAt(0) == '[') {
            if (string.charAt(n7 - 1) != ']') {
                return false;
            }
            n6 = 1;
            --n7;
        }
        if ((n2 = string.indexOf(37, n6)) >= 0) {
            n7 = n2;
        }
        block4: for (n2 = n6; n2 < n7; ++n2) {
            char c3 = c2;
            c2 = string.charAt(n2);
            switch (c2) {
                case '.': {
                    if (++n5 > 3) {
                        return false;
                    }
                    if (!NetUtil.isValidIp4Word(stringBuilder.toString())) {
                        return false;
                    }
                    if (n4 != 6 && !bl) {
                        return false;
                    }
                    if (n4 == 7 && string.charAt(n6) != ':' && string.charAt(n6 + 1) != ':') {
                        return false;
                    }
                    stringBuilder.delete(0, stringBuilder.length());
                    continue block4;
                }
                case ':': {
                    if (n2 == n6 && (string.length() <= n2 || string.charAt(n2 + 1) != ':')) {
                        return false;
                    }
                    if (++n4 > 7) {
                        return false;
                    }
                    if (n5 > 0) {
                        return false;
                    }
                    if (c3 == ':') {
                        if (bl) {
                            return false;
                        }
                        bl = true;
                    }
                    stringBuilder.delete(0, stringBuilder.length());
                    continue block4;
                }
                default: {
                    if (stringBuilder.length() > 3) {
                        return false;
                    }
                    if (!NetUtil.isValidHexChar(c2)) {
                        return false;
                    }
                    stringBuilder.append(c2);
                }
            }
        }
        if (n5 > 0) {
            if (n5 != 3 || !NetUtil.isValidIp4Word(stringBuilder.toString()) || n4 >= 7) {
                return false;
            }
        } else {
            if (n4 != 7 && !bl) {
                return false;
            }
            if (stringBuilder.length() == 0 && string.charAt(n3 - 1 - n6) == ':' && string.charAt(n3 - 2 - n6) != ':') {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public static boolean isValidIp4Word(String string) {
        if (string.length() <= 0 || string.length() > 3) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') continue;
            return false;
        }
        return Integer.parseInt(string) <= 255;
    }

    private static boolean isValidHexChar(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f';
    }

    private static boolean isValidNumericChar(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    public static boolean isValidIpV4Address(String string) {
        int n2 = 0;
        int n3 = string.length();
        if (n3 > 15) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '.') {
                if (++n2 > 3) {
                    return false;
                }
                if (stringBuilder.length() == 0) {
                    return false;
                }
                if (Integer.parseInt(stringBuilder.toString()) > 255) {
                    return false;
                }
                stringBuilder.delete(0, stringBuilder.length());
                continue;
            }
            if (!Character.isDigit(c2)) {
                return false;
            }
            if (stringBuilder.length() > 2) {
                return false;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder.length() == 0 || Integer.parseInt(stringBuilder.toString()) > 255) {
            return false;
        }
        return n2 == 3;
    }

    public static Inet6Address getByName(CharSequence charSequence) {
        return NetUtil.getByName(charSequence, true);
    }

    public static Inet6Address getByName(CharSequence charSequence, boolean bl) {
        int n2;
        char c2;
        int n3;
        byte[] byArray = new byte[16];
        int n4 = charSequence.length();
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = -1;
        int n10 = 0;
        int n11 = 0;
        boolean bl2 = false;
        block6: for (n3 = 0; n3 < n4; ++n3) {
            c2 = charSequence.charAt(n3);
            switch (c2) {
                case ':': {
                    if (n3 - n9 > 4 || n11 > 0 || ++n10 > 8 || n7 + 1 >= byArray.length) {
                        return null;
                    }
                    n8 <<= 4 - (n3 - n9) << 2;
                    if (n6 > 0) {
                        n6 -= 2;
                    }
                    byArray[n7++] = (byte)((n8 & 0xF) << 4 | n8 >> 4 & 0xF);
                    byArray[n7++] = (byte)((n8 >> 8 & 0xF) << 4 | n8 >> 12 & 0xF);
                    n2 = n3 + 1;
                    if (n2 < n4 && charSequence.charAt(n2) == ':') {
                        if (n5 != 0 || ++n2 < n4 && charSequence.charAt(n2) == ':') {
                            return null;
                        }
                        bl2 = ++n10 == 2 && n8 == 0;
                        n5 = n7;
                        n6 = byArray.length - n5 - 2;
                        ++n3;
                    }
                    n8 = 0;
                    n9 = -1;
                    continue block6;
                }
                case '.': {
                    if (n3 - n9 > 3 || ++n11 > 3 || n10 > 0 && n7 + n6 < 12 || n3 + 1 >= n4 || n7 >= byArray.length || n9 < 0 || n9 == 0 && (n3 == 3 && (!NetUtil.isValidNumericChar(charSequence.charAt(2)) || !NetUtil.isValidNumericChar(charSequence.charAt(1)) || !NetUtil.isValidNumericChar(charSequence.charAt(0))) || n3 == 2 && (!NetUtil.isValidNumericChar(charSequence.charAt(1)) || !NetUtil.isValidNumericChar(charSequence.charAt(0))) || n3 == 1 && !NetUtil.isValidNumericChar(charSequence.charAt(0)))) {
                        return null;
                    }
                    if ((n9 = ((n8 <<= 3 - (n3 - n9) << 2) & 0xF) * 100 + (n8 >> 4 & 0xF) * 10 + (n8 >> 8 & 0xF)) < 0 || n9 > 255) {
                        return null;
                    }
                    byArray[n7++] = (byte)n9;
                    n8 = 0;
                    n9 = -1;
                    continue block6;
                }
                default: {
                    if (!NetUtil.isValidHexChar(c2) || n11 > 0 && !NetUtil.isValidNumericChar(c2)) {
                        return null;
                    }
                    if (n9 < 0) {
                        n9 = n3;
                    } else if (n3 - n9 > 4) {
                        return null;
                    }
                    n8 += NetUtil.getIntValue(c2) << (n3 - n9 << 2);
                }
            }
        }
        char c3 = c2 = n5 > 0 ? (char)'\u0001' : '\u0000';
        if (n11 > 0) {
            if (n9 > 0 && n3 - n9 > 3 || n11 != 3 || n7 >= byArray.length) {
                return null;
            }
            if (n10 == 0) {
                n6 = 12;
            } else if (n10 >= 2 && charSequence.charAt(n4 - 1) != ':' && (c2 == '\u0000' && n10 == 6 && charSequence.charAt(0) != ':' || c2 != '\u0000' && n10 + 1 < 8 && (charSequence.charAt(0) != ':' || n5 <= 2))) {
                n6 -= 2;
            } else {
                return null;
            }
            n8 <<= 3 - (n3 - n9) << 2;
            n9 = (n8 & 0xF) * 100 + (n8 >> 4 & 0xF) * 10 + (n8 >> 8 & 0xF);
            if (n9 < 0 || n9 > 255) {
                return null;
            }
            byArray[n7++] = (byte)n9;
        } else {
            n2 = n4 - 1;
            if (n9 > 0 && n3 - n9 > 4 || n10 < 2 || c2 == '\u0000' && (n10 + 1 != 8 || charSequence.charAt(0) == ':' || charSequence.charAt(n2) == ':') || c2 != '\u0000' && (n10 > 8 || n10 == 8 && (n5 <= 2 && charSequence.charAt(0) != ':' || n5 >= 14 && charSequence.charAt(n2) != ':')) || n7 + 1 >= byArray.length) {
                return null;
            }
            if (n9 >= 0 && n3 - n9 <= 4) {
                n8 <<= 4 - (n3 - n9) << 2;
            }
            byArray[n7++] = (byte)((n8 & 0xF) << 4 | n8 >> 4 & 0xF);
            byArray[n7++] = (byte)((n8 >> 8 & 0xF) << 4 | n8 >> 12 & 0xF);
        }
        n3 = n7 + n6;
        if (bl2 || n3 >= byArray.length) {
            if (n3 >= byArray.length) {
                ++n5;
            }
            for (n3 = n7; n3 < byArray.length; ++n3) {
                int cfr_ignored_0 = byArray.length;
                for (n9 = 15; n9 >= n5; --n9) {
                    byArray[n9] = byArray[n9 - 1];
                }
                byArray[n9] = 0;
                ++n5;
            }
        } else {
            for (n3 = 0; n3 < n6 && (n7 = (n9 = n3 + n5) + n6) < byArray.length; ++n3) {
                byArray[n7] = byArray[n9];
                byArray[n9] = 0;
            }
        }
        if (bl && n11 > 0 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 && byArray[7] == 0 && byArray[8] == 0 && byArray[9] == 0) {
            byArray[11] = -1;
            byArray[10] = -1;
        }
        try {
            return Inet6Address.getByAddress(null, byArray, -1);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException);
        }
    }

    public static String toAddressString(InetAddress inetAddress) {
        return NetUtil.toAddressString(inetAddress, false);
    }

    public static String toAddressString(InetAddress object, boolean bl) {
        int n2;
        int n3;
        if (object instanceof Inet4Address) {
            return ((InetAddress)object).getHostAddress();
        }
        if (!(object instanceof Inet6Address)) {
            throw new IllegalArgumentException("Unhandled type: " + object.getClass());
        }
        object = ((InetAddress)object).getAddress();
        int[] nArray = new int[8];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = (object[n3 << 1] & 0xFF) << 8 | object[(n3 << 1) + 1] & 0xFF;
        }
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (nArray[n3] == 0) {
                if (n4 >= 0) continue;
                n4 = n3;
                continue;
            }
            if (n4 < 0) continue;
            n2 = n3 - n4;
            if (n2 > n6) {
                n5 = n4;
                n6 = n2;
            }
            n4 = -1;
        }
        if (n4 >= 0 && (n2 = n3 - n4) > n6) {
            n5 = n4;
            n6 = n2;
        }
        if (n6 == 1) {
            n6 = 0;
            n5 = -1;
        }
        n4 = n5 + n6;
        StringBuilder stringBuilder = new StringBuilder(39);
        if (n4 < 0) {
            stringBuilder.append(Integer.toHexString(nArray[0]));
            for (n3 = 1; n3 < nArray.length; ++n3) {
                stringBuilder.append(':');
                stringBuilder.append(Integer.toHexString(nArray[n3]));
            }
        } else {
            if (NetUtil.inRangeEndExclusive(0, n5, n4)) {
                stringBuilder.append("::");
                bl = bl && n4 == 5 && nArray[5] == 65535;
            } else {
                stringBuilder.append(Integer.toHexString(nArray[0]));
                bl = false;
            }
            for (n3 = 1; n3 < nArray.length; ++n3) {
                if (!NetUtil.inRangeEndExclusive(n3, n5, n4)) {
                    if (!NetUtil.inRangeEndExclusive(n3 - 1, n5, n4)) {
                        if (!bl || n3 == 6) {
                            stringBuilder.append(':');
                        } else {
                            stringBuilder.append('.');
                        }
                    }
                    if (bl && n3 > 5) {
                        stringBuilder.append(nArray[n3] >> 8);
                        stringBuilder.append('.');
                        stringBuilder.append(nArray[n3] & 0xFF);
                        continue;
                    }
                    stringBuilder.append(Integer.toHexString(nArray[n3]));
                    continue;
                }
                if (NetUtil.inRangeEndExclusive(n3 - 1, n5, n4)) continue;
                stringBuilder.append("::");
            }
        }
        return stringBuilder.toString();
    }

    private static boolean inRangeEndExclusive(int n2, int n3, int n4) {
        return n2 >= n3 && n2 < n4;
    }

    private NetUtil() {
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }

    static {
        Enumeration<InetAddress> enumeration;
        NetworkInterface networkInterface;
        Object object;
        Object object2;
        IPV4_PREFERRED = Boolean.getBoolean("java.net.preferIPv4Stack");
        logger = InternalLoggerFactory.getInstance(NetUtil.class);
        Object object3 = new byte[]{127, 0, 0, 1};
        Object object4 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        Inet4Address inet4Address = null;
        try {
            inet4Address = (Inet4Address)InetAddress.getByAddress(object3);
        }
        catch (Exception exception) {
            object3 = exception;
            PlatformDependent.throwException(exception);
        }
        LOCALHOST4 = inet4Address;
        object3 = null;
        try {
            object3 = (Inet6Address)InetAddress.getByAddress((byte[])object4);
        }
        catch (Exception exception) {
            object4 = exception;
            PlatformDependent.throwException(exception);
        }
        LOCALHOST6 = object3;
        object4 = new ArrayList();
        try {
            object2 = NetworkInterface.getNetworkInterfaces();
            while (object2.hasMoreElements()) {
                object = object2.nextElement();
                if (!((NetworkInterface)object).getInetAddresses().hasMoreElements()) continue;
                object4.add(object);
            }
        }
        catch (SocketException socketException) {
            logger.warn("Failed to retrieve the list of available network interfaces", socketException);
        }
        object2 = null;
        object = null;
        Iterator iterator = object4.iterator();
        block12: while (iterator.hasNext()) {
            networkInterface = (NetworkInterface)iterator.next();
            enumeration = networkInterface.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                InetAddress inetAddress = enumeration.nextElement();
                if (!inetAddress.isLoopbackAddress()) continue;
                object2 = networkInterface;
                object = inetAddress;
                break block12;
            }
        }
        if (object2 == null) {
            try {
                iterator = object4.iterator();
                while (iterator.hasNext()) {
                    networkInterface = (NetworkInterface)iterator.next();
                    if (!networkInterface.isLoopback() || !(enumeration = networkInterface.getInetAddresses()).hasMoreElements()) continue;
                    object2 = networkInterface;
                    object = enumeration.nextElement();
                    break;
                }
                if (object2 == null) {
                    logger.warn("Failed to find the loopback interface");
                }
            }
            catch (SocketException socketException) {
                logger.warn("Failed to find the loopback interface", socketException);
            }
        }
        if (object2 != null) {
            logger.debug("Loopback interface: {} ({}, {})", ((NetworkInterface)object2).getName(), ((NetworkInterface)object2).getDisplayName(), ((InetAddress)object).getHostAddress());
        } else if (object == null) {
            try {
                if (NetworkInterface.getByInetAddress(LOCALHOST6) != null) {
                    logger.debug("Using hard-coded IPv6 localhost address: {}", object3);
                    object = object3;
                }
                if (object == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                    object = inet4Address;
                }
            }
            catch (Exception exception) {
                if (object == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                    object = inet4Address;
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    logger.debug("Using hard-coded IPv4 localhost address: {}", (Object)inet4Address);
                }
                throw throwable;
            }
        }
        LOOPBACK_IF = object2;
        LOCALHOST = object;
        SOMAXCONN = AccessController.doPrivileged(new NetUtil$1());
    }
}

