/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util;

import com.aliyun.openservices.shade.io.netty.util.Recycler;
import com.aliyun.openservices.shade.io.netty.util.Recycler$DefaultHandle;
import com.aliyun.openservices.shade.io.netty.util.Recycler$WeakOrderQueue;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

final class Recycler$Stack<T> {
    final Recycler<T> parent;
    final Thread thread;
    final AtomicInteger availableSharedCapacity;
    final int maxDelayedQueues;
    private final int maxCapacity;
    private final int ratioMask;
    private Recycler$DefaultHandle[] elements;
    private int size;
    private int handleRecycleCount = -1;
    private Recycler$WeakOrderQueue cursor;
    private Recycler$WeakOrderQueue prev;
    private volatile Recycler$WeakOrderQueue head;

    Recycler$Stack(Recycler<T> recycler, Thread thread, int n2, int n3, int n4, int n5) {
        this.parent = recycler;
        this.thread = thread;
        this.maxCapacity = n2;
        this.availableSharedCapacity = new AtomicInteger(Math.max(n2 / n3, Recycler.access$800()));
        this.elements = new Recycler$DefaultHandle[Math.min(Recycler.access$1700(), n2)];
        this.ratioMask = n4;
        this.maxDelayedQueues = n5;
    }

    final int increaseCapacity(int n2) {
        int n3 = this.elements.length;
        int n4 = this.maxCapacity;
        while ((n3 <<= 1) < n2 && n3 < n4) {
        }
        if ((n3 = Math.min(n3, n4)) != this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, n3);
        }
        return n3;
    }

    final Recycler$DefaultHandle pop() {
        int n2 = this.size;
        if (n2 == 0) {
            if (!this.scavenge()) {
                return null;
            }
            n2 = this.size;
        }
        Recycler$DefaultHandle recycler$DefaultHandle = this.elements[--n2];
        this.elements[n2] = null;
        if (Recycler$DefaultHandle.access$1200(recycler$DefaultHandle) != Recycler$DefaultHandle.access$1600(recycler$DefaultHandle)) {
            throw new IllegalStateException("recycled multiple times");
        }
        Recycler$DefaultHandle.access$1602(recycler$DefaultHandle, 0);
        Recycler$DefaultHandle.access$1202(recycler$DefaultHandle, 0);
        this.size = n2;
        return recycler$DefaultHandle;
    }

    final boolean scavenge() {
        if (this.scavengeSome()) {
            return true;
        }
        this.prev = null;
        this.cursor = this.head;
        return false;
    }

    final boolean scavengeSome() {
        Recycler$WeakOrderQueue recycler$WeakOrderQueue;
        Recycler$WeakOrderQueue recycler$WeakOrderQueue2 = this.cursor;
        if (recycler$WeakOrderQueue2 == null && (recycler$WeakOrderQueue2 = this.head) == null) {
            return false;
        }
        boolean bl = false;
        Recycler$WeakOrderQueue recycler$WeakOrderQueue3 = this.prev;
        do {
            if (recycler$WeakOrderQueue2.transfer(this)) {
                bl = true;
                break;
            }
            recycler$WeakOrderQueue = Recycler$WeakOrderQueue.access$1800(recycler$WeakOrderQueue2);
            if (Recycler$WeakOrderQueue.access$1900(recycler$WeakOrderQueue2).get() == null) {
                if (recycler$WeakOrderQueue2.hasFinalData()) {
                    while (recycler$WeakOrderQueue2.transfer(this)) {
                        bl = true;
                    }
                }
                if (recycler$WeakOrderQueue3 == null) continue;
                Recycler$WeakOrderQueue.access$1802(recycler$WeakOrderQueue3, recycler$WeakOrderQueue);
                continue;
            }
            recycler$WeakOrderQueue3 = recycler$WeakOrderQueue2;
        } while ((recycler$WeakOrderQueue2 = recycler$WeakOrderQueue) != null && !bl);
        this.prev = recycler$WeakOrderQueue3;
        this.cursor = recycler$WeakOrderQueue2;
        return bl;
    }

    final void push(Recycler$DefaultHandle recycler$DefaultHandle) {
        Thread thread = Thread.currentThread();
        if (this.thread == thread) {
            this.pushNow(recycler$DefaultHandle);
            return;
        }
        this.pushLater(recycler$DefaultHandle, thread);
    }

    private void pushNow(Recycler$DefaultHandle recycler$DefaultHandle) {
        if ((Recycler$DefaultHandle.access$1600(recycler$DefaultHandle) | Recycler$DefaultHandle.access$1200(recycler$DefaultHandle)) != 0) {
            throw new IllegalStateException("recycled already");
        }
        Recycler$DefaultHandle recycler$DefaultHandle2 = recycler$DefaultHandle;
        Recycler$DefaultHandle.access$1602(recycler$DefaultHandle2, Recycler$DefaultHandle.access$1202(recycler$DefaultHandle2, Recycler.access$2000()));
        int n2 = this.size;
        if (n2 >= this.maxCapacity || this.dropHandle(recycler$DefaultHandle)) {
            return;
        }
        if (n2 == this.elements.length) {
            this.elements = Arrays.copyOf(this.elements, Math.min(n2 << 1, this.maxCapacity));
        }
        this.elements[n2] = recycler$DefaultHandle;
        this.size = n2 + 1;
    }

    private void pushLater(Recycler$DefaultHandle recycler$DefaultHandle, Thread thread) {
        Map map = (Map)Recycler.access$2100().get();
        Recycler$WeakOrderQueue recycler$WeakOrderQueue = (Recycler$WeakOrderQueue)map.get(this);
        if (recycler$WeakOrderQueue == null) {
            if (map.size() >= this.maxDelayedQueues) {
                map.put(this, Recycler$WeakOrderQueue.DUMMY);
                return;
            }
            recycler$WeakOrderQueue = Recycler$WeakOrderQueue.allocate(this, thread);
            if (recycler$WeakOrderQueue == null) {
                return;
            }
            map.put(this, recycler$WeakOrderQueue);
        } else if (recycler$WeakOrderQueue == Recycler$WeakOrderQueue.DUMMY) {
            return;
        }
        recycler$WeakOrderQueue.add(recycler$DefaultHandle);
    }

    final boolean dropHandle(Recycler$DefaultHandle recycler$DefaultHandle) {
        if (!recycler$DefaultHandle.hasBeenRecycled) {
            if ((++this.handleRecycleCount & this.ratioMask) != 0) {
                return true;
            }
            recycler$DefaultHandle.hasBeenRecycled = true;
        }
        return false;
    }

    final Recycler$DefaultHandle newHandle() {
        return new Recycler$DefaultHandle(this);
    }

    static /* synthetic */ Recycler$DefaultHandle[] access$600(Recycler$Stack recycler$Stack) {
        return recycler$Stack.elements;
    }

    static /* synthetic */ int access$700(Recycler$Stack recycler$Stack) {
        return recycler$Stack.size;
    }

    static /* synthetic */ Recycler$WeakOrderQueue access$1100(Recycler$Stack recycler$Stack) {
        return recycler$Stack.head;
    }

    static /* synthetic */ Recycler$WeakOrderQueue access$1102(Recycler$Stack recycler$Stack, Recycler$WeakOrderQueue weakOrderQueue) {
        recycler$Stack.head = weakOrderQueue;
        return recycler$Stack.head;
    }

    static /* synthetic */ int access$702(Recycler$Stack recycler$Stack, int n2) {
        recycler$Stack.size = n2;
        return recycler$Stack.size;
    }
}

