/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util;

import com.aliyun.openservices.shade.io.netty.util.Recycler$1;
import com.aliyun.openservices.shade.io.netty.util.Recycler$2;
import com.aliyun.openservices.shade.io.netty.util.Recycler$3;
import com.aliyun.openservices.shade.io.netty.util.Recycler$DefaultHandle;
import com.aliyun.openservices.shade.io.netty.util.Recycler$Handle;
import com.aliyun.openservices.shade.io.netty.util.Recycler$Stack;
import com.aliyun.openservices.shade.io.netty.util.Recycler$WeakOrderQueue;
import com.aliyun.openservices.shade.io.netty.util.concurrent.FastThreadLocal;
import com.aliyun.openservices.shade.io.netty.util.internal.MathUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.SystemPropertyUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Recycler<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Recycler.class);
    private static final Recycler$Handle NOOP_HANDLE = new Recycler$1();
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(Integer.MIN_VALUE);
    private static final int OWN_THREAD_ID = ID_GENERATOR.getAndIncrement();
    private static final int DEFAULT_INITIAL_MAX_CAPACITY = 32768;
    private static final int DEFAULT_MAX_CAPACITY;
    private static final int INITIAL_CAPACITY;
    private static final int MAX_SHARED_CAPACITY_FACTOR;
    private static final int MAX_DELAYED_QUEUES_PER_THREAD;
    private static final int LINK_CAPACITY;
    private static final int RATIO;
    private final int maxCapacity;
    private final int maxSharedCapacityFactor;
    private final int ratioMask;
    private final int maxDelayedQueuesPerThread;
    private final FastThreadLocal<Recycler$Stack<T>> threadLocal = new Recycler$2(this);
    private static final FastThreadLocal<Map<Recycler$Stack<?>, Recycler$WeakOrderQueue>> DELAYED_RECYCLED;

    public Recycler() {
        this(DEFAULT_MAX_CAPACITY);
    }

    protected Recycler(int n2) {
        this(n2, MAX_SHARED_CAPACITY_FACTOR);
    }

    protected Recycler(int n2, int n3) {
        this(n2, n3, RATIO, MAX_DELAYED_QUEUES_PER_THREAD);
    }

    protected Recycler(int n2, int n3, int n4, int n5) {
        this.ratioMask = MathUtil.safeFindNextPositivePowerOfTwo(n4) - 1;
        if (n2 <= 0) {
            this.maxCapacity = 0;
            this.maxSharedCapacityFactor = 1;
            this.maxDelayedQueuesPerThread = 0;
            return;
        }
        this.maxCapacity = n2;
        this.maxSharedCapacityFactor = Math.max(1, n3);
        this.maxDelayedQueuesPerThread = Math.max(0, n5);
    }

    public final T get() {
        if (this.maxCapacity == 0) {
            return this.newObject(NOOP_HANDLE);
        }
        Recycler$Stack<T> recycler$Stack = this.threadLocal.get();
        Recycler$DefaultHandle recycler$DefaultHandle = recycler$Stack.pop();
        if (recycler$DefaultHandle == null) {
            recycler$DefaultHandle = recycler$Stack.newHandle();
            Recycler$DefaultHandle.access$402(recycler$DefaultHandle, this.newObject(recycler$DefaultHandle));
        }
        return (T)Recycler$DefaultHandle.access$400(recycler$DefaultHandle);
    }

    public final boolean recycle(T t2, Recycler$Handle recycler$Handle) {
        if (recycler$Handle == NOOP_HANDLE) {
            return false;
        }
        recycler$Handle = (Recycler$DefaultHandle)recycler$Handle;
        if (Recycler$DefaultHandle.access$500((Recycler$DefaultHandle)recycler$Handle).parent != this) {
            return false;
        }
        if (t2 != Recycler$DefaultHandle.access$400((Recycler$DefaultHandle)recycler$Handle)) {
            throw new IllegalArgumentException("o does not belong to handle");
        }
        ((Recycler$DefaultHandle)recycler$Handle).recycle();
        return true;
    }

    protected abstract T newObject(Recycler$Handle var1);

    final int threadLocalCapacity() {
        return Recycler$Stack.access$600(this.threadLocal.get()).length;
    }

    final int threadLocalSize() {
        return Recycler$Stack.access$700(this.threadLocal.get());
    }

    static /* synthetic */ int access$000(Recycler recycler) {
        return recycler.maxCapacity;
    }

    static /* synthetic */ int access$100(Recycler recycler) {
        return recycler.maxSharedCapacityFactor;
    }

    static /* synthetic */ int access$200(Recycler recycler) {
        return recycler.ratioMask;
    }

    static /* synthetic */ int access$300(Recycler recycler) {
        return recycler.maxDelayedQueuesPerThread;
    }

    static /* synthetic */ int access$800() {
        return LINK_CAPACITY;
    }

    static /* synthetic */ AtomicInteger access$900() {
        return ID_GENERATOR;
    }

    static /* synthetic */ int access$1700() {
        return INITIAL_CAPACITY;
    }

    static /* synthetic */ int access$2000() {
        return OWN_THREAD_ID;
    }

    static /* synthetic */ FastThreadLocal access$2100() {
        return DELAYED_RECYCLED;
    }

    static {
        int n2 = SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.recycler.maxCapacity.default", 32768);
        if (n2 < 0) {
            n2 = 32768;
        }
        DEFAULT_MAX_CAPACITY = n2;
        MAX_SHARED_CAPACITY_FACTOR = Math.max(2, SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.recycler.maxSharedCapacityFactor", 2));
        MAX_DELAYED_QUEUES_PER_THREAD = Math.max(0, SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.recycler.maxDelayedQueuesPerThread", Runtime.getRuntime().availableProcessors() << 1));
        LINK_CAPACITY = MathUtil.safeFindNextPositivePowerOfTwo(Math.max(SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.recycler.linkCapacity", 16), 16));
        RATIO = MathUtil.safeFindNextPositivePowerOfTwo(SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.recycler.ratio", 8));
        if (logger.isDebugEnabled()) {
            if (DEFAULT_MAX_CAPACITY == 0) {
                logger.debug("-Dio.netty.recycler.maxCapacity.default: disabled");
                logger.debug("-Dio.netty.recycler.maxSharedCapacityFactor: disabled");
                logger.debug("-Dio.netty.recycler.linkCapacity: disabled");
                logger.debug("-Dio.netty.recycler.ratio: disabled");
            } else {
                logger.debug("-Dio.netty.recycler.maxCapacity.default: {}", (Object)DEFAULT_MAX_CAPACITY);
                logger.debug("-Dio.netty.recycler.maxSharedCapacityFactor: {}", (Object)MAX_SHARED_CAPACITY_FACTOR);
                logger.debug("-Dio.netty.recycler.linkCapacity: {}", (Object)LINK_CAPACITY);
                logger.debug("-Dio.netty.recycler.ratio: {}", (Object)RATIO);
            }
        }
        INITIAL_CAPACITY = Math.min(DEFAULT_MAX_CAPACITY, 256);
        DELAYED_RECYCLED = new Recycler$3();
    }
}

