/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util;

import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil$ReleasingTask;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCounted;
import com.aliyun.openservices.shade.io.netty.util.ThreadDeathWatcher;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;

public final class ReferenceCountUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountUtil.class);

    public static <T> T retain(T t2) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).retain();
        }
        return t2;
    }

    public static <T> T retain(T t2, int n2) {
        if (t2 instanceof ReferenceCounted) {
            return (T)((ReferenceCounted)t2).retain(n2);
        }
        return t2;
    }

    public static boolean release(Object object) {
        if (object instanceof ReferenceCounted) {
            return ((ReferenceCounted)object).release();
        }
        return false;
    }

    public static boolean release(Object object, int n2) {
        if (object instanceof ReferenceCounted) {
            return ((ReferenceCounted)object).release(n2);
        }
        return false;
    }

    public static void safeRelease(Object object) {
        try {
            ReferenceCountUtil.release(object);
            return;
        }
        catch (Throwable throwable) {
            logger.warn("Failed to release a message: {}", object, (Object)throwable);
            return;
        }
    }

    public static void safeRelease(Object object, int n2) {
        try {
            ReferenceCountUtil.release(object, n2);
            return;
        }
        catch (Throwable throwable) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to release a message: {} (decrement: {})", object, n2, throwable);
            }
            return;
        }
    }

    public static <T> T releaseLater(T t2) {
        return ReferenceCountUtil.releaseLater(t2, 1);
    }

    public static <T> T releaseLater(T t2, int n2) {
        if (t2 instanceof ReferenceCounted) {
            ThreadDeathWatcher.watch(Thread.currentThread(), new ReferenceCountUtil$ReleasingTask((ReferenceCounted)t2, n2));
        }
        return t2;
    }

    private ReferenceCountUtil() {
    }

    static /* synthetic */ InternalLogger access$000() {
        return logger;
    }
}

