/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util;

import com.aliyun.openservices.shade.io.netty.util.ResourceLeak;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeakDetector;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeakDetector$Level;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.lang.ref.PhantomReference;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicBoolean;

final class ResourceLeakDetector$DefaultResourceLeak
extends PhantomReference<Object>
implements ResourceLeak {
    private final String creationRecord;
    private final Deque<String> lastRecords;
    private final AtomicBoolean freed;
    private ResourceLeakDetector$DefaultResourceLeak prev;
    private ResourceLeakDetector$DefaultResourceLeak next;
    private int removedRecords;
    final /* synthetic */ ResourceLeakDetector this$0;

    ResourceLeakDetector$DefaultResourceLeak(ResourceLeakDetector resourceLeakDetector, Object object) {
        this.this$0 = resourceLeakDetector;
        Object object2 = object;
        super(object2, object2 != null ? ResourceLeakDetector.access$200(resourceLeakDetector) : null);
        this.lastRecords = new ArrayDeque<String>();
        if (object != null) {
            object = ResourceLeakDetector.getLevel();
            this.creationRecord = ((Enum)object).ordinal() >= ResourceLeakDetector$Level.ADVANCED.ordinal() ? ResourceLeakDetector.newRecord(3) : null;
            object = ResourceLeakDetector.access$300(resourceLeakDetector);
            synchronized (object) {
                this.prev = ResourceLeakDetector.access$300(resourceLeakDetector);
                this.next = ResourceLeakDetector.access$300((ResourceLeakDetector)resourceLeakDetector).next;
                ResourceLeakDetector.access$300((ResourceLeakDetector)resourceLeakDetector).next.prev = this;
                ResourceLeakDetector.access$300((ResourceLeakDetector)resourceLeakDetector).next = this;
                ResourceLeakDetector.access$408(resourceLeakDetector);
            }
            this.freed = new AtomicBoolean();
            return;
        }
        this.creationRecord = null;
        this.freed = new AtomicBoolean(true);
    }

    @Override
    public final void record() {
        if (this.creationRecord != null) {
            String string = ResourceLeakDetector.newRecord(2);
            Deque<String> deque = this.lastRecords;
            synchronized (deque) {
                int n2 = this.lastRecords.size();
                if (n2 == 0 || !this.lastRecords.getLast().equals(string)) {
                    this.lastRecords.add(string);
                }
                if (n2 > ResourceLeakDetector.access$500()) {
                    this.lastRecords.removeFirst();
                    ++this.removedRecords;
                }
                return;
            }
        }
    }

    @Override
    public final boolean close() {
        if (this.freed.compareAndSet(false, true)) {
            ResourceLeakDetector$DefaultResourceLeak resourceLeakDetector$DefaultResourceLeak = ResourceLeakDetector.access$300(this.this$0);
            synchronized (resourceLeakDetector$DefaultResourceLeak) {
                ResourceLeakDetector.access$410(this.this$0);
                this.prev.next = this.next;
                this.next.prev = this.prev;
                this.prev = null;
                this.next = null;
            }
            return true;
        }
        return false;
    }

    public final String toString() {
        int n2;
        Object[] objectArray;
        if (this.creationRecord == null) {
            return "";
        }
        Object object = this.lastRecords;
        synchronized (object) {
            objectArray = this.lastRecords.toArray();
            n2 = this.removedRecords;
        }
        object = new StringBuilder(16384).append(StringUtil.NEWLINE);
        if (n2 > 0) {
            ((StringBuilder)object).append("WARNING: ").append(n2).append(" leak records were discarded because the leak record count is limited to ").append(ResourceLeakDetector.access$500()).append(". Use system property com.aliyun.openservices.shade.io.netty.leakDetection.maxRecords").append(" to increase the limit.").append(StringUtil.NEWLINE);
        }
        ((StringBuilder)object).append("Recent access records: ").append(objectArray.length).append(StringUtil.NEWLINE);
        if (objectArray.length > 0) {
            for (n2 = objectArray.length - 1; n2 >= 0; --n2) {
                ((StringBuilder)object).append('#').append(n2 + 1).append(':').append(StringUtil.NEWLINE).append(objectArray[n2]);
            }
        }
        ((StringBuilder)object).append("Created at:").append(StringUtil.NEWLINE).append(this.creationRecord);
        Object object2 = object;
        ((StringBuilder)object2).setLength(((StringBuilder)object2).length() - StringUtil.NEWLINE.length());
        return ((StringBuilder)object).toString();
    }

    static /* synthetic */ ResourceLeakDetector$DefaultResourceLeak access$002(ResourceLeakDetector$DefaultResourceLeak resourceLeakDetector$DefaultResourceLeak, ResourceLeakDetector$DefaultResourceLeak resourceLeakDetector$DefaultResourceLeak2) {
        resourceLeakDetector$DefaultResourceLeak.next = resourceLeakDetector$DefaultResourceLeak2;
        return resourceLeakDetector$DefaultResourceLeak.next;
    }

    static /* synthetic */ ResourceLeakDetector$DefaultResourceLeak access$102(ResourceLeakDetector$DefaultResourceLeak resourceLeakDetector$DefaultResourceLeak, ResourceLeakDetector$DefaultResourceLeak resourceLeakDetector$DefaultResourceLeak2) {
        resourceLeakDetector$DefaultResourceLeak.prev = resourceLeakDetector$DefaultResourceLeak2;
        return resourceLeakDetector$DefaultResourceLeak.prev;
    }
}

