/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util;

import com.aliyun.openservices.shade.io.netty.util.ResourceLeak;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeakDetector$DefaultResourceLeak;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeakDetector$Level;
import com.aliyun.openservices.shade.io.netty.util.internal.MathUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.SystemPropertyUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResourceLeakDetector<T> {
    private static final String PROP_LEVEL_OLD = "com.aliyun.openservices.shade.io.netty.leakDetectionLevel";
    private static final String PROP_LEVEL = "com.aliyun.openservices.shade.io.netty.leakDetection.level";
    private static final ResourceLeakDetector$Level DEFAULT_LEVEL;
    private static final String PROP_MAX_RECORDS = "com.aliyun.openservices.shade.io.netty.leakDetection.maxRecords";
    private static final int DEFAULT_MAX_RECORDS = 4;
    private static final int MAX_RECORDS;
    private static ResourceLeakDetector$Level level;
    private static final InternalLogger logger;
    static final int DEFAULT_SAMPLING_INTERVAL = 128;
    private final ResourceLeakDetector$DefaultResourceLeak head = new ResourceLeakDetector$DefaultResourceLeak(this, (Object)null);
    private final ResourceLeakDetector$DefaultResourceLeak tail = new ResourceLeakDetector$DefaultResourceLeak(this, (Object)null);
    private final ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private final ConcurrentMap<String, Boolean> reportedLeaks = PlatformDependent.newConcurrentHashMap();
    private final String resourceType;
    private final int samplingInterval;
    private final int mask;
    private final long maxActive;
    private long active;
    private final AtomicBoolean loggedTooManyActive = new AtomicBoolean();
    private long leakCheckCnt;
    private static final String[] STACK_TRACE_ELEMENT_EXCLUSIONS;

    @Deprecated
    public static void setEnabled(boolean bl) {
        ResourceLeakDetector.setLevel(bl ? ResourceLeakDetector$Level.SIMPLE : ResourceLeakDetector$Level.DISABLED);
    }

    public static boolean isEnabled() {
        return ResourceLeakDetector.getLevel().ordinal() > ResourceLeakDetector$Level.DISABLED.ordinal();
    }

    public static void setLevel(ResourceLeakDetector$Level resourceLeakDetector$Level) {
        if (resourceLeakDetector$Level == null) {
            throw new NullPointerException("level");
        }
        level = resourceLeakDetector$Level;
    }

    public static ResourceLeakDetector$Level getLevel() {
        return level;
    }

    @Deprecated
    public ResourceLeakDetector(Class<?> clazz) {
        this(StringUtil.simpleClassName(clazz));
    }

    @Deprecated
    public ResourceLeakDetector(String string) {
        this(string, 128, Long.MAX_VALUE);
    }

    public ResourceLeakDetector(Class<?> clazz, int n2, long l2) {
        this(StringUtil.simpleClassName(clazz), n2, l2);
    }

    @Deprecated
    public ResourceLeakDetector(String string, int n2, long l2) {
        if (string == null) {
            throw new NullPointerException("resourceType");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("maxActive: " + l2 + " (expected: 1+)");
        }
        this.resourceType = string;
        this.samplingInterval = MathUtil.safeFindNextPositivePowerOfTwo(n2);
        this.mask = this.samplingInterval - 1;
        this.maxActive = l2;
        ResourceLeakDetector$DefaultResourceLeak.access$002(this.head, this.tail);
        ResourceLeakDetector$DefaultResourceLeak.access$102(this.tail, this.head);
    }

    public final ResourceLeak open(T t2) {
        ResourceLeakDetector$Level resourceLeakDetector$Level = level;
        if (resourceLeakDetector$Level == ResourceLeakDetector$Level.DISABLED) {
            return null;
        }
        if (resourceLeakDetector$Level.ordinal() < ResourceLeakDetector$Level.PARANOID.ordinal()) {
            if ((++this.leakCheckCnt & (long)this.mask) == 0L) {
                this.reportLeak(resourceLeakDetector$Level);
                return new ResourceLeakDetector$DefaultResourceLeak(this, t2);
            }
            return null;
        }
        this.reportLeak(resourceLeakDetector$Level);
        return new ResourceLeakDetector$DefaultResourceLeak(this, t2);
    }

    private void reportLeak(ResourceLeakDetector$Level object) {
        Object object2;
        int n2;
        if (!logger.isErrorEnabled()) {
            while ((object = (ResourceLeakDetector$DefaultResourceLeak)this.refQueue.poll()) != null) {
                ((ResourceLeakDetector$DefaultResourceLeak)object).close();
            }
            return;
        }
        int n3 = n2 = object == ResourceLeakDetector$Level.PARANOID ? 1 : this.samplingInterval;
        if (this.active * (long)n2 > this.maxActive && this.loggedTooManyActive.compareAndSet(false, true)) {
            ResourceLeakDetector resourceLeakDetector = this;
            resourceLeakDetector.reportInstancesLeak(resourceLeakDetector.resourceType);
        }
        while ((object2 = (ResourceLeakDetector$DefaultResourceLeak)this.refQueue.poll()) != null) {
            ((Reference)object2).clear();
            if (!((ResourceLeakDetector$DefaultResourceLeak)object2).close() || this.reportedLeaks.putIfAbsent((String)(object2 = ((ResourceLeakDetector$DefaultResourceLeak)object2).toString()), Boolean.TRUE) != null) continue;
            if (((String)object2).isEmpty()) {
                ResourceLeakDetector resourceLeakDetector = this;
                resourceLeakDetector.reportUntracedLeak(resourceLeakDetector.resourceType);
                continue;
            }
            ResourceLeakDetector resourceLeakDetector = this;
            resourceLeakDetector.reportTracedLeak(resourceLeakDetector.resourceType, (String)object2);
        }
    }

    protected void reportTracedLeak(String string, String string2) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. See http://netty.io/wiki/reference-counted-objects.html for more information.{}", (Object)string, (Object)string2);
    }

    protected void reportUntracedLeak(String string) {
        logger.error("LEAK: {}.release() was not called before it's garbage-collected. Enable advanced leak reporting to find out where the leak occurred. To enable advanced leak reporting, specify the JVM option '-D{}={}' or call {}.setLevel() See http://netty.io/wiki/reference-counted-objects.html for more information.", string, PROP_LEVEL, ResourceLeakDetector$Level.ADVANCED.name().toLowerCase(), StringUtil.simpleClassName(this));
    }

    protected void reportInstancesLeak(String string) {
        logger.error("LEAK: You are creating too many " + string + " instances.  " + string + " is a shared resource that must be reused across the JVM,so that only a few instances are created.");
    }

    static String newRecord(int n2) {
        StringBuilder stringBuilder = new StringBuilder(4096);
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        stackTraceElementArray2 = stackTraceElementArray;
        int n3 = stackTraceElementArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = stackTraceElementArray2[i2];
            if (n2 > 0) {
                --n2;
                continue;
            }
            object = ((StackTraceElement)object).toString();
            boolean bl = false;
            String[] stringArray = STACK_TRACE_ELEMENT_EXCLUSIONS;
            int n4 = STACK_TRACE_ELEMENT_EXCLUSIONS.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                String string = stringArray[i3];
                if (!((String)object).startsWith(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            stringBuilder.append('\t');
            stringBuilder.append((String)object);
            stringBuilder.append(StringUtil.NEWLINE);
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ ReferenceQueue access$200(ResourceLeakDetector resourceLeakDetector) {
        return resourceLeakDetector.refQueue;
    }

    static /* synthetic */ ResourceLeakDetector$DefaultResourceLeak access$300(ResourceLeakDetector resourceLeakDetector) {
        return resourceLeakDetector.head;
    }

    static /* synthetic */ long access$408(ResourceLeakDetector resourceLeakDetector) {
        return resourceLeakDetector.active++;
    }

    static /* synthetic */ int access$500() {
        return MAX_RECORDS;
    }

    static /* synthetic */ long access$410(ResourceLeakDetector resourceLeakDetector) {
        return resourceLeakDetector.active--;
    }

    static {
        boolean bl;
        DEFAULT_LEVEL = ResourceLeakDetector$Level.SIMPLE;
        logger = InternalLoggerFactory.getInstance(ResourceLeakDetector.class);
        if (SystemPropertyUtil.get("com.aliyun.openservices.shade.io.netty.noResourceLeakDetection") != null) {
            bl = SystemPropertyUtil.getBoolean("com.aliyun.openservices.shade.io.netty.noResourceLeakDetection", false);
            logger.debug("-Dio.netty.noResourceLeakDetection: {}", (Object)bl);
            logger.warn("-Dio.netty.noResourceLeakDetection is deprecated. Use '-D{}={}' instead.", (Object)PROP_LEVEL, (Object)DEFAULT_LEVEL.name().toLowerCase());
        } else {
            bl = false;
        }
        Object object = bl ? ResourceLeakDetector$Level.DISABLED : DEFAULT_LEVEL;
        object = SystemPropertyUtil.get(PROP_LEVEL_OLD, ((Enum)object).name()).trim().toUpperCase();
        object = SystemPropertyUtil.get(PROP_LEVEL, (String)object).trim().toUpperCase();
        ResourceLeakDetector$Level resourceLeakDetector$Level = DEFAULT_LEVEL;
        for (ResourceLeakDetector$Level resourceLeakDetector$Level2 : EnumSet.allOf(ResourceLeakDetector$Level.class)) {
            if (!((String)object).equals(resourceLeakDetector$Level2.name()) && !((String)object).equals(String.valueOf(resourceLeakDetector$Level2.ordinal()))) continue;
            resourceLeakDetector$Level = resourceLeakDetector$Level2;
        }
        MAX_RECORDS = SystemPropertyUtil.getInt(PROP_MAX_RECORDS, 4);
        level = resourceLeakDetector$Level;
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_LEVEL, (Object)resourceLeakDetector$Level.name().toLowerCase());
            logger.debug("-D{}: {}", (Object)PROP_MAX_RECORDS, (Object)MAX_RECORDS);
        }
        STACK_TRACE_ELEMENT_EXCLUSIONS = new String[]{"com.aliyun.openservices.shade.io.netty.buffer.AbstractByteBufAllocator.toLeakAwareBuffer(", "com.aliyun.openservices.shade.io.netty.buffer.AdvancedLeakAwareByteBuf.recordLeakNonRefCountingOperation("};
    }
}

