/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.collection;

import com.aliyun.openservices.shade.io.netty.util.collection.IntObjectHashMap$1;
import com.aliyun.openservices.shade.io.netty.util.collection.IntObjectHashMap$IteratorImpl;
import com.aliyun.openservices.shade.io.netty.util.collection.IntObjectMap;
import com.aliyun.openservices.shade.io.netty.util.collection.IntObjectMap$Entry;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class IntObjectHashMap<V>
implements IntObjectMap<V>,
Iterable<IntObjectMap$Entry<V>> {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private int[] keys;
    private V[] values;
    private Collection<V> valueCollection;
    private int size;

    public IntObjectHashMap() {
        this(11, 0.5f);
    }

    public IntObjectHashMap(int n2) {
        this(n2, 0.5f);
    }

    public IntObjectHashMap(int n2, float f2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 1");
        }
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f2;
        n2 = IntObjectHashMap.adjustCapacity(n2);
        this.keys = new int[n2];
        Object[] objectArray = new Object[n2];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n2);
    }

    private static <T> T toExternal(T t2) {
        if (t2 == NULL_VALUE) {
            return null;
        }
        return t2;
    }

    private static <T> T toInternal(T t2) {
        if (t2 == null) {
            return (T)NULL_VALUE;
        }
        return t2;
    }

    @Override
    public V get(int n2) {
        if ((n2 = this.indexOf(n2)) == -1) {
            return null;
        }
        return IntObjectHashMap.toExternal(this.values[n2]);
    }

    @Override
    public V put(int n2, V v2) {
        int n3;
        int n4 = n3 = this.hashIndex(n2);
        do {
            if (this.values[n4] == null) {
                this.keys[n4] = n2;
                this.values[n4] = IntObjectHashMap.toInternal(v2);
                this.growSize();
                return null;
            }
            if (this.keys[n4] != n2) continue;
            V v3 = this.values[n4];
            this.values[n4] = IntObjectHashMap.toInternal(v2);
            return IntObjectHashMap.toExternal(v3);
        } while ((n4 = this.probeNext(n4)) != n3);
        throw new IllegalStateException("Unable to insert");
    }

    private int probeNext(int n2) {
        if (n2 == this.values.length - 1) {
            return 0;
        }
        return n2 + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(IntObjectMap<V> object) {
        if (object instanceof IntObjectHashMap) {
            void intObjectMap$Entry;
            object = (IntObjectHashMap)((Object)object);
            boolean i2 = false;
            while (intObjectMap$Entry < ((IntObjectHashMap)((Object)object)).values.length) {
                V v2 = ((IntObjectHashMap)((Object)object)).values[intObjectMap$Entry];
                if (v2 != null) {
                    this.put(((IntObjectHashMap)((Object)object)).keys[intObjectMap$Entry], v2);
                }
                ++intObjectMap$Entry;
            }
            return;
        }
        for (IntObjectMap$Entry intObjectMap$Entry : object.entries()) {
            this.put(intObjectMap$Entry.key(), intObjectMap$Entry.value());
        }
    }

    @Override
    public V remove(int n2) {
        if ((n2 = this.indexOf(n2)) == -1) {
            return null;
        }
        V v2 = this.values[n2];
        this.removeAt(n2);
        return IntObjectHashMap.toExternal(v2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(int n2) {
        return this.indexOf(n2) >= 0;
    }

    @Override
    public boolean containsValue(V v2) {
        v2 = IntObjectHashMap.toInternal(v2);
        V[] VArray = this.values;
        int n2 = this.values.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            V v3 = VArray[i2];
            if (v3 == null || !v3.equals(v2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<IntObjectMap$Entry<V>> entries() {
        return this;
    }

    @Override
    public Iterator<IntObjectMap$Entry<V>> iterator() {
        return new IntObjectHashMap$IteratorImpl(this, null);
    }

    @Override
    public int[] keys() {
        int[] nArray = new int[this.size()];
        int n2 = 0;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            if (this.values[i2] == null) continue;
            nArray[n2++] = this.keys[i2];
        }
        return nArray;
    }

    @Override
    public V[] values(Class<V> objectArray) {
        objectArray = (Object[])Array.newInstance(objectArray, this.size());
        int n2 = 0;
        V[] VArray = this.values;
        int n3 = this.values.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            V v2 = VArray[i2];
            if (v2 == null) continue;
            objectArray[n2++] = v2;
        }
        return objectArray;
    }

    @Override
    public Collection<V> values() {
        IntObjectHashMap$1 intObjectHashMap$1 = this.valueCollection;
        if (intObjectHashMap$1 == null) {
            this.valueCollection = intObjectHashMap$1 = new IntObjectHashMap$1(this);
        }
        return intObjectHashMap$1;
    }

    public int hashCode() {
        int n2 = this.size;
        int[] nArray = this.keys;
        int n3 = this.keys.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            n2 ^= n4;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntObjectMap)) {
            return false;
        }
        if (this.size != (object = (IntObjectMap)object).size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            int n2 = this.keys[i2];
            Object v3 = object.get(n2);
            if (!(v2 == NULL_VALUE ? v3 != null : !v2.equals(v3))) continue;
            return false;
        }
        return true;
    }

    private int indexOf(int n2) {
        int n3;
        int n4 = n3 = this.hashIndex(n2);
        do {
            if (this.values[n4] == null) {
                return -1;
            }
            if (n2 != this.keys[n4]) continue;
            return n4;
        } while ((n4 = this.probeNext(n4)) != n3);
        return -1;
    }

    private int hashIndex(int n2) {
        return (n2 % this.keys.length + this.keys.length) % this.keys.length;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            IntObjectHashMap intObjectHashMap = this;
            intObjectHashMap.rehash(IntObjectHashMap.adjustCapacity((int)Math.min((double)intObjectHashMap.keys.length * 2.0, 2.147483639E9)));
            return;
        }
        if (this.size == this.keys.length) {
            IntObjectHashMap intObjectHashMap = this;
            intObjectHashMap.rehash(intObjectHashMap.keys.length);
        }
    }

    private static int adjustCapacity(int n2) {
        return n2 | 1;
    }

    private void removeAt(int n2) {
        --this.size;
        this.keys[n2] = 0;
        this.values[n2] = null;
        int n3 = n2;
        n2 = this.probeNext(n2);
        while (this.values[n2] != null) {
            IntObjectHashMap intObjectHashMap = this;
            int n4 = intObjectHashMap.hashIndex(intObjectHashMap.keys[n2]);
            if (n2 < n4 && (n4 <= n3 || n3 <= n2) || n4 <= n3 && n3 <= n2) {
                this.keys[n3] = this.keys[n2];
                this.values[n3] = this.values[n2];
                this.keys[n2] = 0;
                this.values[n2] = null;
                n3 = n2;
            }
            n2 = this.probeNext(n2);
        }
    }

    private int calcMaxSize(int n2) {
        int n3 = n2 - 1;
        return Math.min(n3, (int)((float)n2 * this.loadFactor));
    }

    private void rehash(int n2) {
        int[] nArray = this.keys;
        V[] VArray = this.values;
        this.keys = new int[n2];
        Object object = new Object[n2];
        this.values = object;
        this.maxSize = this.calcMaxSize(n2);
        block0: for (n2 = 0; n2 < VArray.length; ++n2) {
            object = VArray[n2];
            if (object == null) continue;
            int n3 = nArray[n2];
            int n4 = this.hashIndex(n3);
            while (true) {
                if (this.values[n4] == null) {
                    this.keys[n4] = n3;
                    this.values[n4] = IntObjectHashMap.toInternal(object);
                    continue block0;
                }
                n4 = this.probeNext(n4);
            }
        }
    }

    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            V v2 = this.values[i2];
            if (v2 == null) continue;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append(stringBuilder2.length() == 0 ? "{" : ", ");
            IntObjectHashMap intObjectHashMap = this;
            stringBuilder.append(intObjectHashMap.keyToString(intObjectHashMap.keys[i2])).append('=').append((Object)(v2 == this ? "(this Map)" : v2));
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(int n2) {
        return Integer.toString(n2);
    }

    static /* synthetic */ int access$100(IntObjectHashMap intObjectHashMap) {
        return intObjectHashMap.size;
    }

    static /* synthetic */ Object[] access$200(IntObjectHashMap intObjectHashMap) {
        return intObjectHashMap.values;
    }

    static /* synthetic */ int[] access$300(IntObjectHashMap intObjectHashMap) {
        return intObjectHashMap.keys;
    }

    static /* synthetic */ void access$400(IntObjectHashMap intObjectHashMap, int n2) {
        intObjectHashMap.removeAt(n2);
    }

    static /* synthetic */ Object access$500(Object object) {
        return IntObjectHashMap.toExternal(object);
    }

    static /* synthetic */ Object access$600(Object object) {
        return IntObjectHashMap.toInternal(object);
    }
}

