/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.concurrent;

import com.aliyun.openservices.shade.io.netty.util.concurrent.AbstractEventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.AbstractScheduledEventExecutor$1;
import com.aliyun.openservices.shade.io.netty.util.concurrent.AbstractScheduledEventExecutor$2;
import com.aliyun.openservices.shade.io.netty.util.concurrent.ScheduledFuture;
import com.aliyun.openservices.shade.io.netty.util.concurrent.ScheduledFutureTask;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class AbstractScheduledEventExecutor
extends AbstractEventExecutor {
    Queue<ScheduledFutureTask<?>> scheduledTaskQueue;

    public static long nanoTime() {
        return ScheduledFutureTask.nanoTime();
    }

    Queue<ScheduledFutureTask<?>> scheduledTaskQueue() {
        if (this.scheduledTaskQueue == null) {
            this.scheduledTaskQueue = new PriorityQueue();
        }
        return this.scheduledTaskQueue;
    }

    private static boolean isNullOrEmpty(Queue<ScheduledFutureTask<?>> queue) {
        return queue == null || queue.isEmpty();
    }

    public void cancelScheduledTasks() {
        assert (this.inEventLoop());
        Queue<ScheduledFutureTask<?>> queue = this.scheduledTaskQueue;
        if (AbstractScheduledEventExecutor.isNullOrEmpty(queue)) {
            return;
        }
        Queue<ScheduledFutureTask<?>> queue2 = queue;
        ScheduledFutureTask[] scheduledFutureTaskArray = queue2.toArray(new ScheduledFutureTask[queue2.size()]);
        ScheduledFutureTask[] scheduledFutureTaskArray2 = scheduledFutureTaskArray;
        scheduledFutureTaskArray2 = scheduledFutureTaskArray;
        int n2 = scheduledFutureTaskArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ScheduledFutureTask scheduledFutureTask = scheduledFutureTaskArray2[i2];
            scheduledFutureTask.cancelWithoutRemove(false);
        }
        queue.clear();
    }

    protected final Runnable pollScheduledTask() {
        return this.pollScheduledTask(AbstractScheduledEventExecutor.nanoTime());
    }

    protected final Runnable pollScheduledTask(long l2) {
        assert (this.inEventLoop());
        Queue<ScheduledFutureTask<?>> queue = this.scheduledTaskQueue;
        ScheduledFutureTask<?> scheduledFutureTask = queue == null ? null : queue.peek();
        if (scheduledFutureTask == null) {
            return null;
        }
        if (scheduledFutureTask.deadlineNanos() <= l2) {
            queue.remove();
            return scheduledFutureTask;
        }
        return null;
    }

    protected final long nextScheduledTaskNano() {
        Object object = this.scheduledTaskQueue;
        object = object == null ? null : object.peek();
        if (object == null) {
            return -1L;
        }
        return Math.max(0L, ((ScheduledFutureTask)object).deadlineNanos() - AbstractScheduledEventExecutor.nanoTime());
    }

    final ScheduledFutureTask<?> peekScheduledTask() {
        Queue<ScheduledFutureTask<?>> queue = this.scheduledTaskQueue;
        if (queue == null) {
            return null;
        }
        return queue.peek();
    }

    protected final boolean hasScheduledTasks() {
        Object object = this.scheduledTaskQueue;
        object = object == null ? null : object.peek();
        return object != null && ((ScheduledFutureTask)object).deadlineNanos() <= AbstractScheduledEventExecutor.nanoTime();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l2, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: >= 0)", l2));
        }
        return this.schedule(new ScheduledFutureTask<Object>(this, runnable, null, ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l2))));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long l2, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(callable, "callable");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: >= 0)", l2));
        }
        return this.schedule(new ScheduledFutureTask<V>(this, callable, ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l2))));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", l2));
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException(String.format("period: %d (expected: > 0)", l3));
        }
        return this.schedule(new ScheduledFutureTask<Object>(this, Executors.callable(runnable, null), ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l2)), timeUnit.toNanos(l3)));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l2, long l3, TimeUnit timeUnit) {
        ObjectUtil.checkNotNull(runnable, "command");
        ObjectUtil.checkNotNull(timeUnit, "unit");
        if (l2 < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", l2));
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: > 0)", l3));
        }
        return this.schedule(new ScheduledFutureTask<Object>(this, Executors.callable(runnable, null), ScheduledFutureTask.deadlineNanos(timeUnit.toNanos(l2)), -timeUnit.toNanos(l3)));
    }

    <V> ScheduledFuture<V> schedule(ScheduledFutureTask<V> scheduledFutureTask) {
        if (this.inEventLoop()) {
            this.scheduledTaskQueue().add(scheduledFutureTask);
        } else {
            this.execute(new AbstractScheduledEventExecutor$1(this, scheduledFutureTask));
        }
        return scheduledFutureTask;
    }

    final void removeScheduled(ScheduledFutureTask<?> scheduledFutureTask) {
        if (this.inEventLoop()) {
            this.scheduledTaskQueue().remove(scheduledFutureTask);
            return;
        }
        this.execute(new AbstractScheduledEventExecutor$2(this, scheduledFutureTask));
    }
}

