/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.concurrent;

import com.aliyun.openservices.shade.io.netty.util.concurrent.Future;
import com.aliyun.openservices.shade.io.netty.util.concurrent.GenericFutureListener;
import com.aliyun.openservices.shade.io.netty.util.concurrent.GenericProgressiveFutureListener;
import java.util.Arrays;

final class DefaultFutureListeners {
    private GenericFutureListener<? extends Future<?>>[] listeners = new GenericFutureListener[2];
    private int size;
    private int progressiveSize;

    DefaultFutureListeners(GenericFutureListener<? extends Future<?>> genericFutureListener, GenericFutureListener<? extends Future<?>> genericFutureListener2) {
        this.listeners[0] = genericFutureListener;
        this.listeners[1] = genericFutureListener2;
        this.size = 2;
        if (genericFutureListener instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
        if (genericFutureListener2 instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
    }

    public final void add(GenericFutureListener<? extends Future<?>> genericFutureListener) {
        int n2 = this.size;
        GenericFutureListener<? extends Future<?>>[] genericFutureListenerArray = this.listeners;
        if (n2 == genericFutureListenerArray.length) {
            this.listeners = genericFutureListenerArray = Arrays.copyOf(genericFutureListenerArray, n2 << 1);
        }
        genericFutureListenerArray[n2] = genericFutureListener;
        this.size = n2 + 1;
        if (genericFutureListener instanceof GenericProgressiveFutureListener) {
            ++this.progressiveSize;
        }
    }

    public final void remove(GenericFutureListener<? extends Future<?>> genericFutureListener) {
        GenericFutureListener<? extends Future<?>>[] genericFutureListenerArray = this.listeners;
        int n2 = this.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (genericFutureListenerArray[i2] != genericFutureListener) continue;
            int n3 = n2 - i2 - 1;
            if (n3 > 0) {
                System.arraycopy(genericFutureListenerArray, i2 + 1, genericFutureListenerArray, i2, n3);
            }
            genericFutureListenerArray[--n2] = null;
            this.size = n2;
            if (genericFutureListener instanceof GenericProgressiveFutureListener) {
                --this.progressiveSize;
            }
            return;
        }
    }

    public final GenericFutureListener<? extends Future<?>>[] listeners() {
        return this.listeners;
    }

    public final int size() {
        return this.size;
    }

    public final int progressiveSize() {
        return this.progressiveSize;
    }
}

