/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.concurrent;

import com.aliyun.openservices.shade.io.netty.util.concurrent.DefaultThreadFactory$DefaultRunnableDecorator;
import com.aliyun.openservices.shade.io.netty.util.concurrent.FastThreadLocalThread;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolId = new AtomicInteger();
    private final AtomicInteger nextId = new AtomicInteger();
    private final String prefix;
    private final boolean daemon;
    private final int priority;
    protected final ThreadGroup threadGroup;

    public DefaultThreadFactory(Class<?> clazz) {
        this(clazz, false, 5);
    }

    public DefaultThreadFactory(String string) {
        this(string, false, 5);
    }

    public DefaultThreadFactory(Class<?> clazz, boolean bl) {
        this(clazz, bl, 5);
    }

    public DefaultThreadFactory(String string, boolean bl) {
        this(string, bl, 5);
    }

    public DefaultThreadFactory(Class<?> clazz, int n2) {
        this(clazz, false, n2);
    }

    public DefaultThreadFactory(String string, int n2) {
        this(string, false, n2);
    }

    public DefaultThreadFactory(Class<?> clazz, boolean bl, int n2) {
        this(DefaultThreadFactory.toPoolName(clazz), bl, n2);
    }

    public static String toPoolName(Class<?> object) {
        if (object == null) {
            throw new NullPointerException("poolType");
        }
        object = StringUtil.simpleClassName(object);
        switch (((String)object).length()) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return ((String)object).toLowerCase(Locale.US);
            }
        }
        if (Character.isUpperCase(((String)object).charAt(0)) && Character.isLowerCase(((String)object).charAt(1))) {
            return Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
        }
        return object;
    }

    public DefaultThreadFactory(String string, boolean bl, int n2, ThreadGroup threadGroup) {
        if (string == null) {
            throw new NullPointerException("poolName");
        }
        if (n2 <= 0 || n2 > 10) {
            throw new IllegalArgumentException("priority: " + n2 + " (expected: Thread.MIN_PRIORITY <= priority <= Thread.MAX_PRIORITY)");
        }
        this.prefix = string + '-' + poolId.incrementAndGet() + '-';
        this.daemon = bl;
        this.priority = n2;
        this.threadGroup = threadGroup;
    }

    public DefaultThreadFactory(String string, boolean bl, int n2) {
        this(string, bl, n2, System.getSecurityManager() == null ? Thread.currentThread().getThreadGroup() : System.getSecurityManager().getThreadGroup());
    }

    @Override
    public Thread newThread(Runnable runnable) {
        runnable = this.newThread(new DefaultThreadFactory$DefaultRunnableDecorator(runnable), this.prefix + this.nextId.incrementAndGet());
        try {
            if (((Thread)runnable).isDaemon()) {
                if (!this.daemon) {
                    ((Thread)runnable).setDaemon(false);
                }
            } else if (this.daemon) {
                ((Thread)runnable).setDaemon(true);
            }
            if (((Thread)runnable).getPriority() != this.priority) {
                ((Thread)runnable).setPriority(this.priority);
            }
        }
        catch (Exception exception) {}
        return runnable;
    }

    protected Thread newThread(Runnable runnable, String string) {
        return new FastThreadLocalThread(this.threadGroup, runnable, string);
    }
}

