/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.concurrent;

import com.aliyun.openservices.shade.io.netty.util.internal.InternalThreadLocalMap;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

public class FastThreadLocal<V> {
    private static final int variablesToRemoveIndex = InternalThreadLocalMap.nextVariableIndex();
    private final int index = InternalThreadLocalMap.nextVariableIndex();

    public static void removeAll() {
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.getIfSet();
        if (internalThreadLocalMap == null) {
            return;
        }
        try {
            FastThreadLocal[] fastThreadLocalArray = internalThreadLocalMap.indexedVariable(variablesToRemoveIndex);
            if (fastThreadLocalArray != null && fastThreadLocalArray != InternalThreadLocalMap.UNSET) {
                fastThreadLocalArray = (Set)fastThreadLocalArray;
                FastThreadLocal[] fastThreadLocalArray2 = fastThreadLocalArray.toArray(new FastThreadLocal[fastThreadLocalArray.size()]);
                fastThreadLocalArray = fastThreadLocalArray2;
                fastThreadLocalArray = fastThreadLocalArray2;
                int n2 = fastThreadLocalArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    FastThreadLocal fastThreadLocal = fastThreadLocalArray[i2];
                    fastThreadLocal.remove(internalThreadLocalMap);
                }
            }
            return;
        }
        finally {
            InternalThreadLocalMap.remove();
        }
    }

    public static int size() {
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.getIfSet();
        if (internalThreadLocalMap == null) {
            return 0;
        }
        return internalThreadLocalMap.size();
    }

    public static void destroy() {
        InternalThreadLocalMap.destroy();
    }

    private static void addToVariablesToRemove(InternalThreadLocalMap internalThreadLocalMap, FastThreadLocal<?> fastThreadLocal) {
        Set set = internalThreadLocalMap.indexedVariable(variablesToRemoveIndex);
        if (set == InternalThreadLocalMap.UNSET || set == null) {
            set = Collections.newSetFromMap(new IdentityHashMap());
            internalThreadLocalMap.setIndexedVariable(variablesToRemoveIndex, set);
        } else {
            set = set;
        }
        set.add(fastThreadLocal);
    }

    private static void removeFromVariablesToRemove(InternalThreadLocalMap object, FastThreadLocal<?> fastThreadLocal) {
        if ((object = ((InternalThreadLocalMap)object).indexedVariable(variablesToRemoveIndex)) == InternalThreadLocalMap.UNSET || object == null) {
            return;
        }
        object = (Set)object;
        object.remove(fastThreadLocal);
    }

    public final V get() {
        return this.get(InternalThreadLocalMap.get());
    }

    public final V get(InternalThreadLocalMap internalThreadLocalMap) {
        Object object = internalThreadLocalMap.indexedVariable(this.index);
        if (object != InternalThreadLocalMap.UNSET) {
            return (V)object;
        }
        return this.initialize(internalThreadLocalMap);
    }

    private V initialize(InternalThreadLocalMap internalThreadLocalMap) {
        V v2 = null;
        try {
            v2 = this.initialValue();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            PlatformDependent.throwException(exception);
        }
        internalThreadLocalMap.setIndexedVariable(this.index, v2);
        FastThreadLocal.addToVariablesToRemove(internalThreadLocalMap, this);
        return v2;
    }

    public final void set(V v2) {
        if (v2 != InternalThreadLocalMap.UNSET) {
            this.set(InternalThreadLocalMap.get(), v2);
            return;
        }
        this.remove();
    }

    public final void set(InternalThreadLocalMap internalThreadLocalMap, V v2) {
        if (v2 != InternalThreadLocalMap.UNSET) {
            if (internalThreadLocalMap.setIndexedVariable(this.index, v2)) {
                FastThreadLocal.addToVariablesToRemove(internalThreadLocalMap, this);
                return;
            }
        } else {
            this.remove(internalThreadLocalMap);
        }
    }

    public final boolean isSet() {
        return this.isSet(InternalThreadLocalMap.getIfSet());
    }

    public final boolean isSet(InternalThreadLocalMap internalThreadLocalMap) {
        return internalThreadLocalMap != null && internalThreadLocalMap.isIndexedVariableSet(this.index);
    }

    public final void remove() {
        this.remove(InternalThreadLocalMap.getIfSet());
    }

    public final void remove(InternalThreadLocalMap object) {
        if (object == null) {
            return;
        }
        Object object2 = ((InternalThreadLocalMap)object).removeIndexedVariable(this.index);
        FastThreadLocal.removeFromVariablesToRemove((InternalThreadLocalMap)object, this);
        if (object2 != InternalThreadLocalMap.UNSET) {
            try {
                this.onRemoval(object2);
                return;
            }
            catch (Exception exception) {
                object = exception;
                PlatformDependent.throwException(exception);
            }
        }
    }

    protected V initialValue() {
        return null;
    }

    protected void onRemoval(V v2) {
    }
}

