/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.concurrent;

import com.aliyun.openservices.shade.io.netty.util.concurrent.AbstractEventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutorGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.FailedFuture;
import com.aliyun.openservices.shade.io.netty.util.concurrent.FastThreadLocal;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Future;
import com.aliyun.openservices.shade.io.netty.util.concurrent.GlobalEventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.ImmediateEventExecutor$1;
import com.aliyun.openservices.shade.io.netty.util.concurrent.ImmediateEventExecutor$2;
import com.aliyun.openservices.shade.io.netty.util.concurrent.ImmediateEventExecutor$ImmediateProgressivePromise;
import com.aliyun.openservices.shade.io.netty.util.concurrent.ImmediateEventExecutor$ImmediatePromise;
import com.aliyun.openservices.shade.io.netty.util.concurrent.ProgressivePromise;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Promise;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public final class ImmediateEventExecutor
extends AbstractEventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ImmediateEventExecutor.class);
    public static final ImmediateEventExecutor INSTANCE = new ImmediateEventExecutor();
    private static final FastThreadLocal<Queue<Runnable>> DELAYED_RUNNABLES = new ImmediateEventExecutor$1();
    private static final FastThreadLocal<Boolean> RUNNING = new ImmediateEventExecutor$2();
    private final Future<?> terminationFuture = new FailedFuture(GlobalEventExecutor.INSTANCE, new UnsupportedOperationException());

    private ImmediateEventExecutor() {
    }

    @Override
    public final EventExecutorGroup parent() {
        return null;
    }

    @Override
    public final boolean inEventLoop() {
        return true;
    }

    @Override
    public final boolean inEventLoop(Thread thread) {
        return true;
    }

    @Override
    public final Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        return this.terminationFuture();
    }

    @Override
    public final Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public final void shutdown() {
    }

    @Override
    public final boolean isShuttingDown() {
        return false;
    }

    @Override
    public final boolean isShutdown() {
        return false;
    }

    @Override
    public final boolean isTerminated() {
        return false;
    }

    @Override
    public final boolean awaitTermination(long l2, TimeUnit timeUnit) {
        return false;
    }

    @Override
    public final void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("command");
        }
        if (!RUNNING.get().booleanValue()) {
            RUNNING.set(Boolean.TRUE);
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                logger.info("Throwable caught while executing Runnable {}", (Object)runnable, (Object)throwable);
            }
            finally {
                Queue<Runnable> queue = DELAYED_RUNNABLES.get();
                while ((runnable = queue.poll()) != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        logger.info("Throwable caught while executing Runnable {}", (Object)runnable, (Object)throwable);
                    }
                }
                RUNNING.set(Boolean.FALSE);
            }
        } else {
            DELAYED_RUNNABLES.get().add(runnable);
        }
    }

    @Override
    public final <V> Promise<V> newPromise() {
        return new ImmediateEventExecutor$ImmediatePromise(this);
    }

    @Override
    public final <V> ProgressivePromise<V> newProgressivePromise() {
        return new ImmediateEventExecutor$ImmediateProgressivePromise(this);
    }
}

