/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.util.concurrent;

import com.aliyun.openservices.shade.io.netty.util.concurrent.AbstractEventExecutorGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.DefaultPromise;
import com.aliyun.openservices.shade.io.netty.util.concurrent.DefaultThreadFactory;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Future;
import com.aliyun.openservices.shade.io.netty.util.concurrent.GlobalEventExecutor;
import com.aliyun.openservices.shade.io.netty.util.concurrent.MultithreadEventExecutorGroup$1;
import com.aliyun.openservices.shade.io.netty.util.concurrent.MultithreadEventExecutorGroup$EventExecutorChooser;
import com.aliyun.openservices.shade.io.netty.util.concurrent.MultithreadEventExecutorGroup$GenericEventExecutorChooser;
import com.aliyun.openservices.shade.io.netty.util.concurrent.MultithreadEventExecutorGroup$PowerOfTwoEventExecutorChooser;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Promise;
import com.aliyun.openservices.shade.io.netty.util.concurrent.SingleThreadEventExecutor;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MultithreadEventExecutorGroup
extends AbstractEventExecutorGroup {
    private final EventExecutor[] children;
    private final AtomicInteger childIndex = new AtomicInteger();
    private final AtomicInteger terminatedChildren = new AtomicInteger();
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private final MultithreadEventExecutorGroup$EventExecutorChooser chooser;

    public MultithreadEventExecutorGroup(int n2, ThreadFactory threadFactory, Object ... object) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(String.format("nThreads: %d (expected: > 0)", n2));
        }
        if (threadFactory == null) {
            threadFactory = this.newDefaultThreadFactory();
        }
        this.children = new SingleThreadEventExecutor[n2];
        this.chooser = MultithreadEventExecutorGroup.isPowerOfTwo(this.children.length) ? new MultithreadEventExecutorGroup$PowerOfTwoEventExecutorChooser(this, null) : new MultithreadEventExecutorGroup$GenericEventExecutorChooser(this, null);
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                try {
                    this.children[i2] = this.newChild(threadFactory, (Object[])object);
                    continue;
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to create a child event loop", exception);
                }
            }
            catch (Throwable throwable) {
                int n3;
                for (n3 = 0; n3 < i2; ++n3) {
                    this.children[n3].shutdownGracefully();
                }
                for (n3 = 0; n3 < i2; ++n3) {
                    object = this.children[n3];
                    try {
                        while (!object.isTerminated()) {
                            object.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
                        }
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                throw throwable;
            }
        }
        MultithreadEventExecutorGroup$1 multithreadEventExecutorGroup$1 = new MultithreadEventExecutorGroup$1(this);
        EventExecutor[] eventExecutorArray = this.children;
        int n4 = this.children.length;
        for (int i3 = 0; i3 < n4; ++i3) {
            EventExecutor eventExecutor = eventExecutorArray[i3];
            eventExecutor.terminationFuture().addListener(multithreadEventExecutorGroup$1);
        }
    }

    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass());
    }

    @Override
    public EventExecutor next() {
        return this.chooser.next();
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return this.children().iterator();
    }

    public final int executorCount() {
        return this.children.length;
    }

    protected Set<EventExecutor> children() {
        Set<EventExecutor> set = Collections.newSetFromMap(new LinkedHashMap());
        Collections.addAll(set, this.children);
        return set;
    }

    protected abstract EventExecutor newChild(ThreadFactory var1, Object ... var2);

    @Override
    public Future<?> shutdownGracefully(long l2, long l3, TimeUnit timeUnit) {
        EventExecutor[] eventExecutorArray = this.children;
        int n2 = this.children.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            EventExecutor eventExecutor = eventExecutorArray[i2];
            eventExecutor.shutdownGracefully(l2, l3, timeUnit);
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        EventExecutor[] eventExecutorArray = this.children;
        int n2 = this.children.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            EventExecutor eventExecutor = eventExecutorArray[i2];
            eventExecutor.shutdown();
        }
    }

    @Override
    public boolean isShuttingDown() {
        EventExecutor[] eventExecutorArray = this.children;
        int n2 = this.children.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            EventExecutor eventExecutor = eventExecutorArray[i2];
            if (eventExecutor.isShuttingDown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isShutdown() {
        EventExecutor[] eventExecutorArray = this.children;
        int n2 = this.children.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            EventExecutor eventExecutor = eventExecutorArray[i2];
            if (eventExecutor.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        EventExecutor[] eventExecutorArray = this.children;
        int n2 = this.children.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            EventExecutor eventExecutor = eventExecutorArray[i2];
            if (eventExecutor.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long l2, TimeUnit timeUnit) {
        long l3 = System.nanoTime() + timeUnit.toNanos(l2);
        EventExecutor[] eventExecutorArray = this.children;
        int n2 = this.children.length;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            long l4;
            EventExecutor eventExecutor = eventExecutorArray[i2];
            while ((l4 = l3 - System.nanoTime()) > 0L) {
                if (!eventExecutor.awaitTermination(l4, TimeUnit.NANOSECONDS)) continue;
                continue block0;
            }
            break block0;
        }
        return this.isTerminated();
    }

    private static boolean isPowerOfTwo(int n2) {
        int n3 = n2;
        return (n3 & -n3) == n2;
    }

    static /* synthetic */ AtomicInteger access$200(MultithreadEventExecutorGroup multithreadEventExecutorGroup) {
        return multithreadEventExecutorGroup.terminatedChildren;
    }

    static /* synthetic */ EventExecutor[] access$300(MultithreadEventExecutorGroup multithreadEventExecutorGroup) {
        return multithreadEventExecutorGroup.children;
    }

    static /* synthetic */ Promise access$400(MultithreadEventExecutorGroup multithreadEventExecutorGroup) {
        return multithreadEventExecutorGroup.terminationFuture;
    }

    static /* synthetic */ AtomicInteger access$500(MultithreadEventExecutorGroup multithreadEventExecutorGroup) {
        return multithreadEventExecutorGroup.childIndex;
    }
}

